/*
 *  Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
 
#include <tqfontmetrics.h>
#include <tqpainter.h>
#include <tqspinbox.h>
#include <tqcheckbox.h> 
#include <tqlabel.h>

#include <tdefontdialog.h>

#include <klineedit.h>
#include "kis_text_brush.h"

void KisTextBrushResource::updateBrush()
{
	TQFontMetrics metric(m_font);
	int w = metric.width(m_txt);
	int h = metric.height();
	TQPixmap px(w,h);
	TQPainter p;
	p.begin(&px);
	p.setFont( m_font );
	p.fillRect(0,0, w, h, TQt::white);
	p.setPen(TQt::black);
	p.drawText(0, metric.ascent(), m_txt );
	p.end();
	setImage(px.convertToImage ());
}

KisTextBrush::KisTextBrush(TQWidget *parent, const char* name, const TQString& caption) 
	: KisWdgTextBrush(parent, name), 
	  m_textBrushResource(new KisTextBrushResource())
{
	setCaption(caption);
	connect((TQObject*)lineEdit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(rebuildTextBrush()));
	connect((TQObject*)bnFont, TQ_SIGNAL(clicked()), this, TQ_SLOT(getFont()));
	m_font = font();
	rebuildTextBrush();
}


void KisTextBrush::getFont()
{
	TDEFontDialog::getFont( m_font, false/*, TQWidget* parent! */ );
	rebuildTextBrush();
}

void KisTextBrush::rebuildTextBrush()
{
	lblFont->setText(TQString(m_font.family() + ", %1").arg(m_font.pointSize()));
	lblFont->setFont(m_font);
	m_textBrushResource->setFont(m_font);
	m_textBrushResource->setText(lineEdit->text());
	m_textBrushResource->updateBrush();
	emit(activatedResource(m_textBrushResource));
}

#include "kis_text_brush.moc"
