/*
 *  Copyright (c) 2002 Patrick Julien <freak@codepimps.org>
 *                2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KIS_LABEL_PROGRESS_H_
#define KIS_LABEL_PROGRESS_H_

#include <tqlabel.h>
#include <tqevent.h>

#include "kis_progress_display_interface.h"

class TQToolButton;
class KProgress;

class KisLabelProgress : public TQLabel, public KisProgressDisplayInterface {
    TQ_OBJECT
  
    typedef TQLabel super;

public:
    KisLabelProgress(TQWidget *parent, const char *name = 0, WFlags f = 0);
    virtual ~KisLabelProgress();

public:
    // Implements KisProgressDisplayInterface
    void setSubject(KisProgressSubject *subject, bool modal, bool canCancel);

    // Overrides TQLabel::event()
    bool event(TQEvent * ev);

private slots:
    virtual void update(int percent);
    virtual void updateStage(const TQString& stage, int percent);
    virtual void done();
    virtual void error();
    virtual void subjectDestroyed();

private slots:
    void cancelPressed();

private:
    void reset();

    KisProgressSubject *m_subject;
    KProgress *m_bar;
    TQToolButton *m_cancelButton;
    bool m_modal;
};

#endif // KIS_LABEL_PROGRESS_H_

