/***************************************************************************
 *   Copyright (C) 2006  Jonathan Riddell                                  *
 *   jriddell@ubuntu.com                                                   *
 *                                                                         *
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <kservice.h> 
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdeapplication.h>

#include <tqclipboard.h>

#include "spellcatalog.h"
#include "spelling.h"


Spelling::Spelling(SpellCatalog* catalog, const TQString& text): KatapultItem(), _catalog(catalog), _text(text)
{
	spellChecker = new KSpell( 0, "caption", this, TQ_SLOT(spellCheckerReady()) );

	connect( spellChecker, TQ_SIGNAL(misspelling(const TQString&, const TQStringList&, unsigned int)),
		 this, TQ_SLOT(spellCheckerMisspelling(const TQString&, const TQStringList&, unsigned int)) );

	connect( spellChecker, TQ_SIGNAL(corrected(const TQString&, const TQString&, unsigned int)), 
		 this, TQ_SLOT(spellCheckerCorrected(const TQString&, const TQString&, unsigned int)) );

	evaluate();
}

Spelling::~Spelling() {
	delete spellChecker;
}

void Spelling::spellCheckerReady() {
}

void Spelling::spellCheckerCorrected(const TQString& /*originalword*/, const TQString& /*newword*/, unsigned int /*pos*/) {
	corrected = true;
}

void Spelling::spellCheckerMisspelling(const TQString& /*originalword*/, const TQStringList& suggestions, unsigned int /*pos*/) {
	misspelt = true;
	suggestedWords = suggestions.join(",");
}

TQPixmap Spelling::icon(int size) const
{
	const char* icon = "checkmark";
	if (_parseError || misspelt) {
		icon = "no";
	}
	return TDEGlobal::iconLoader()->loadIcon(icon, TDEIcon::NoGroup, size);
}

TQString Spelling::text() const
{
	return _text;
}

void Spelling::setText(const TQString& text)
{
	_text = text;
	evaluate();
}

TQString Spelling::result() const
{
	return _result;
}

bool Spelling::parseError() const
{
	return _parseError;
}

SpellCatalog* Spelling::catalog() const
{
	return _catalog;
}

void Spelling::evaluate() const
{
	int length = catalog()->triggerWordLength();
	
	TQString text = _text.mid(length + 1); // + 1 for space
	
	misspelt = false;
	corrected = false;
	
	_parseError = false;
	if (!_text.isEmpty()) {
		_result = "my result";
		spellChecker->checkWord(text);
	
		while (!corrected) {
			kapp->processEvents();
		}
	
		if (misspelt) {
			_result = suggestedWords;
		} else {
			_result = "Correct";
		}
	} else {
		_parseError = true;
	}
}

void Spelling::copyToClipboard() const {
	TQClipboard* clipBoard = TQApplication::clipboard();
	clipBoard->setText(suggestedWords, TQClipboard::Clipboard);
	clipBoard->setText(suggestedWords, TQClipboard::Selection);
}

#include "spelling.moc"
