/*
 * gstreamer_part.h
 *
 * Copyright (C) 2006 Christophe Thommeret <hftom@free.fr>
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef GSTREAMER_PART_H
#define GSTREAMER_PART_H

#include <tdeparts/factory.h>

#include <gst/gst.h>

#include "kaffeinepart.h"

#include "timer.h"
#include "video.h"
#include "videosettings.h"
#include "gstreamerconfig.h"



class GStreamerPart : public KaffeinePart
{
	TQ_OBJECT
  
public:
	GStreamerPart( TQWidget*, const char*, TQObject*, const char*, const TQStringList& );
	virtual ~GStreamerPart();

	/*
	 *Reimplement from KaffeinePart
	 */
	bool isPlaying();
	bool isPaused();
	uint volume() const; /* percent */
	uint position() const; /* percent */
	bool hasVideo();

	bool closeURL();
	static TDEAboutData* createAboutData();

public slots:
	/*
	 * Reimplement from KaffeinePart
	 */
	bool openURL( const MRL& mrl );
	void slotPlay();
	void slotTogglePause( bool );
	void slotSetVolume( uint ); /* percent */
	void slotSetPosition( uint ); /* percent */
	void slotStop();
	void slotMute();
	void slotPrepareForFullscreen( bool fullscreen );

private slots:
	void slotNext();
	void slotPrevious();
	void slotVolume( int );
	void slotSaturation( int ); /* -1000...1000 */
	void slotHue( int ); /* -1000...1000 */
	void slotContrast( int ); /* -1000...1000 */
	void slotBrightness( int ); /* -1000...1000 */
	void slotContextMenu( const TQPoint& pos );
	void slotInfo();
	void slotSetVisualPlugin( const TQString& );
	void slotVideoSettings();
	void slotConfigDialog();
	void slotEngineError();

	void slotReadBus();

private:
	bool initGStreamer();
	bool createPlaybin();
	void deletePlaybin();
	void loadConfig();
	void saveConfig();
	void gstPlay( const TQString& trackUrl, const TQString& subtitleUrl );
	void initActions();
	void showError();
	void gstStateChanged();
	void foundTag( GstTagList *taglist );
	void processMetaInfo();
	void setAudioSink( TQString sinkName );
	void setDevice( TQString device );

private:
	GstElement *m_play;
	GstElement *m_videosink;
	GstElement *m_audiosink;
	GstElement *m_visual;
	GstBus *bus;
	GstState m_status;

	TQTimer busTimer;

	VideoWindow* m_video;
	Timer* m_timer;
	VideoSettings* m_videoSettings;
	GStreamerConfig* m_gstConfig;
	TQSlider* m_volume;
	TDESelectAction* m_audioVisual;

	MRL m_mrl;
	TQValueList<MRL> m_playlist;
	uint m_current;
	bool m_mute;
	TQString m_logoPath;

	TQString m_errorMsg;
	TQString m_errorDetails;

	TQString m_url;
	TQString m_title;
	TQString m_artist;
	TQString m_album;
	TQString m_track;
	TQString m_year;
	TQString m_genre;
	TQString m_comment;
	TQString m_audioCodec;
	TQString m_videoCodec;
	TQString errorMessage;
	TQString errorDetails;

	TQString m_audioSinkName;
	TQString m_videoSinkName;
	TQString m_visualPluginName;
	TQStringList m_audioVisualPluginList;
	TQStringList m_audioPluginList;
	TQStringList m_videoPluginList;
	TQString m_device, currentDevice;
	int m_savedVolume;
	int muteVolume;

	TDEToolBar* m_posToolbar;
};

#endif /* GSTREAMER_PART_H */
