//
// C++ Interface:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9PROGRESS_H
#define K9PROGRESS_H

#include "k9common.h"
#include "../libk9copy/progress.h"
#include <k9process.h>
#include <tqimage.h>
#include <tqtimer.h>
#include "k9drawimage.h"

class k9Progress : public Progress {
    TQ_OBJECT
  

public:
    k9Progress(TQWidget* parent = 0, const char* name = 0, const TQStringList &args=0);
    ~k9Progress();
    virtual k9Process * getProcess() const;
    virtual void setProgress(long _position,long _total);
    virtual void setLabelText(const TQString _text);
    virtual void setElapsed(const TQString _text);
    virtual void setTitle(const TQString _text);
    virtual void setImage(TQString _fileName) ;
    virtual void setImage(const TQImage &_image);
    virtual void setMovie(TQString _fileName);

    virtual int execute();

    bool getCanceled() const;

    /*$PUBLIC_FUNCTIONS$*/

public slots:
    /*$PUBLIC_SLOTS$*/

protected:
    /*$PROTECTED_FUNCTIONS$*/
    k9Process *m_process;
    k9DrawImage *m_wimage;
    void bCancelClick();
    bool m_canceled;
protected slots:
    /*$PROTECTED_SLOTS$*/
};

#endif

