/* Author: Max Howell <max.howell@methylblue.com>, (C) 2004
   Copyright: See COPYING file that comes with this distribution

   This has to be a c file or for some reason it won't link! (GCC 3.4.1)
*/

#ifndef XINESCOPE_H
#define XINESCOPE_H

/* need access to some stuff for scope time stamping */
#define METRONOM_INTERNAL

#include <sys/types.h>
#include <xine/metronom.h>

#ifdef __cplusplus
extern "C"
{
#endif
#include <xine/xine_plugin.h>
#ifdef __cplusplus
}
#endif

typedef struct my_node_s MyNode;

struct my_node_s
{
    MyNode  *next;
    int16_t *mem;
    int      num_frames;
    int64_t  vpts;
    int64_t  vpts_end;
};

extern MyNode* const myList;

#ifdef __cplusplus
extern "C"
{
#if XINE_MAJOR_VERSION > 1 || (XINE_MAJOR_VERSION == 1 && XINE_MINOR_VERSION > 2) || \
   (XINE_MAJOR_VERSION == 1 && XINE_MINOR_VERSION == 2 && XINE_SUB_VERSION >= 10)
    extern const plugin_info_t scope_plugin_info[];
#else
    xine_post_t* scope_plugin_new( xine_t*, xine_audio_port_t* );
#endif
    int64_t scope_plugin_pts_per_smpls( void* );
}
#endif

#endif
