// File autogenerated

#if !defined(WIFIPROXY_H_INCLUDED)
#define WIFIPROXY_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQT_DBusConnection;
class TQT_DBusDataList;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;
class TQT_DBusVariant;
template <typename T> class TQValueList;

namespace DBus
{

class WiFiDeviceProxy : public TQObject
{
    TQ_OBJECT
    
public:
    WiFiDeviceProxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~WiFiDeviceProxy();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void PropertiesChanged(const TQMap< TQString, TQT_DBusVariant >& properties);

    void AccessPointAdded(const TQT_DBusObjectPath& access_point);

    void AccessPointRemoved(const TQT_DBusObjectPath& access_point);

    void RequestScanAsyncReply(int asyncCallId);


public:
    virtual bool GetAccessPoints(TQValueList< TQT_DBusObjectPath >& access_points, TQT_DBusError& error);

    virtual bool RequestScanAsync(int& asyncCallId, const TQMap< TQString, TQT_DBusVariant >& options, TQT_DBusError& error);

public:
    virtual void setDBusProperty(const TQString& name, const TQT_DBusVariant& variant, TQT_DBusError& error);
    virtual TQT_DBusVariant getDBusProperty(const TQString& name, TQT_DBusError& error) const;

    virtual TQString getHwAddress(TQT_DBusError& error) const;

    virtual TQString getPermHwAddress(TQT_DBusError& error) const;

    virtual TQ_UINT32 getMode(TQT_DBusError& error) const;

    virtual TQ_UINT32 getBitrate(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getActiveAccessPoint(TQT_DBusError& error) const;

    virtual TQ_UINT32 getWirelessCapabilities(TQT_DBusError& error) const;

protected slots: // usually no need to reimplement
    virtual void slotHandleDBusSignal(const TQT_DBusMessage& message);

    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    WiFiDeviceProxy(const WiFiDeviceProxy&);
    WiFiDeviceProxy& operator=(const WiFiDeviceProxy&);
}; // class WiFiDeviceProxy

}; // namespace DBus

#endif //WIFIPROXY_H_INCLUDED

// End of File

