// File autogenerated

// declaration include
#include "accesspointproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

AccessPointProxy::AccessPointProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.AccessPoint");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

AccessPointProxy::~AccessPointProxy()
{
    delete m_baseProxy;
}

void AccessPointProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

void AccessPointProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant AccessPointProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQ_UINT32 AccessPointProxy::getFlags(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Flags", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 AccessPointProxy::getWpaFlags(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WpaFlags", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 AccessPointProxy::getRsnFlags(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("RsnFlags", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQValueList< TQ_UINT8 > AccessPointProxy::getSsid(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Ssid", error);

    if (error.isValid()) return TQValueList< TQ_UINT8 >();

    bool ok = false;

    bool subOK = false;

    TQValueList< TQ_UINT8 > result =  variant.value.toList(&ok).toByteList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQ_UINT32 AccessPointProxy::getFrequency(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Frequency", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQString AccessPointProxy::getHwAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("HwAddress", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 AccessPointProxy::getMode(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Mode", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 AccessPointProxy::getMaxBitrate(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("MaxBitrate", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT8 AccessPointProxy::getStrength(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Strength", error);

    if (error.isValid()) return TQ_UINT8();

    bool ok = false;

    TQ_UINT8 result =  variant.value.toByte(&ok);
    if (!ok) {}

    return result;
}

void AccessPointProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
}

}; // namespace DBus

#include "accesspointproxy.moc"

// End of File

