/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SW_INC_HELPIDS_H
#define INCLUDED_SW_INC_HELPIDS_H

#include <rtl/ustring.hxx>

inline constexpr OUStringLiteral HID_EDIT_WIN = u"SW_HID_EDIT_WIN";

inline constexpr OUStringLiteral HID_PAGEPREVIEW = u"SW_HID_PAGEPREVIEW";
inline constexpr OUStringLiteral HID_SOURCE_EDITWIN = u"SW_HID_SOURCE_EDITWIN";

// Dialog Help-IDs

inline constexpr OUStringLiteral HID_NAVIGATOR_TREELIST = u"SW_HID_NAVIGATOR_TREELIST";
inline constexpr OUStringLiteral HID_NAVIGATOR_TOOLBOX = u"SW_HID_NAVIGATOR_TOOLBOX";
inline constexpr OUStringLiteral HID_NAVIGATOR_LISTBOX = u"SW_HID_NAVIGATOR_LISTBOX";
inline constexpr OUStringLiteral HID_NAVIGATOR_GLOBAL_TOOLBOX = u"SW_HID_NAVIGATOR_GLOBAL_TOOLBOX";
inline constexpr OUStringLiteral HID_NAVIGATOR_GLOB_TREELIST = u"SW_HID_NAVIGATOR_GLOB_TREELIST";

// TabPage Help-IDs

inline constexpr OUStringLiteral HID_LINGU_AUTOCORR = u"SW_HID_LINGU_AUTOCORR";
inline constexpr OUStringLiteral HID_LINGU_REPLACE = u"SW_HID_LINGU_REPLACE";
inline constexpr OUStringLiteral HID_LINGU_IGNORE_SELECTION = u"SW_HID_LINGU_IGNORE_SELECTION";    // grammar check context menu

// More Help-IDs
inline constexpr OUStringLiteral HID_EDIT_FORMULA = u"SW_HID_EDIT_FORMULA";

inline constexpr OUStringLiteral HID_AUTH_FIELD_IDENTIFIER = u"SW_HID_AUTH_FIELD_IDENTIFIER";
inline constexpr OUStringLiteral HID_AUTH_FIELD_AUTHORITY_TYPE = u"SW_HID_AUTH_FIELD_AUTHORITY_TYPE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_ADDRESS = u"SW_HID_AUTH_FIELD_ADDRESS";
inline constexpr OUStringLiteral HID_AUTH_FIELD_ANNOTE = u"SW_HID_AUTH_FIELD_ANNOTE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_AUTHOR = u"SW_HID_AUTH_FIELD_AUTHOR";
inline constexpr OUStringLiteral HID_AUTH_FIELD_BOOKTITLE = u"SW_HID_AUTH_FIELD_BOOKTITLE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CHAPTER = u"SW_HID_AUTH_FIELD_CHAPTER";
inline constexpr OUStringLiteral HID_AUTH_FIELD_EDITION = u"SW_HID_AUTH_FIELD_EDITION";
inline constexpr OUStringLiteral HID_AUTH_FIELD_EDITOR = u"SW_HID_AUTH_FIELD_EDITOR";
inline constexpr OUStringLiteral HID_AUTH_FIELD_HOWPUBLISHED = u"SW_HID_AUTH_FIELD_HOWPUBLISHED";
inline constexpr OUStringLiteral HID_AUTH_FIELD_INSTITUTION = u"SW_HID_AUTH_FIELD_INSTITUTION";
inline constexpr OUStringLiteral HID_AUTH_FIELD_JOURNAL = u"SW_HID_AUTH_FIELD_JOURNAL";
inline constexpr OUStringLiteral HID_AUTH_FIELD_MONTH = u"SW_HID_AUTH_FIELD_MONTH";
inline constexpr OUStringLiteral HID_AUTH_FIELD_NOTE = u"SW_HID_AUTH_FIELD_NOTE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_NUMBER = u"SW_HID_AUTH_FIELD_NUMBER";
inline constexpr OUStringLiteral HID_AUTH_FIELD_ORGANIZATIONS = u"SW_HID_AUTH_FIELD_ORGANIZATIONS";
inline constexpr OUStringLiteral HID_AUTH_FIELD_PAGES = u"SW_HID_AUTH_FIELD_PAGES";
inline constexpr OUStringLiteral HID_AUTH_FIELD_PUBLISHER = u"SW_HID_AUTH_FIELD_PUBLISHER";
inline constexpr OUStringLiteral HID_AUTH_FIELD_SCHOOL = u"SW_HID_AUTH_FIELD_SCHOOL";
inline constexpr OUStringLiteral HID_AUTH_FIELD_SERIES = u"SW_HID_AUTH_FIELD_SERIES";
inline constexpr OUStringLiteral HID_AUTH_FIELD_TITLE = u"SW_HID_AUTH_FIELD_TITLE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_REPORT_TYPE = u"SW_HID_AUTH_FIELD_REPORT_TYPE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_VOLUME = u"SW_HID_AUTH_FIELD_VOLUME";
inline constexpr OUStringLiteral HID_AUTH_FIELD_YEAR = u"SW_HID_AUTH_FIELD_YEAR";
inline constexpr OUStringLiteral HID_AUTH_FIELD_URL = u"SW_HID_AUTH_FIELD_URL";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CUSTOM1 = u"SW_HID_AUTH_FIELD_CUSTOM1";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CUSTOM2 = u"SW_HID_AUTH_FIELD_CUSTOM2";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CUSTOM3 = u"SW_HID_AUTH_FIELD_CUSTOM3";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CUSTOM4 = u"SW_HID_AUTH_FIELD_CUSTOM4";
inline constexpr OUStringLiteral HID_AUTH_FIELD_CUSTOM5 = u"SW_HID_AUTH_FIELD_CUSTOM5";
inline constexpr OUStringLiteral HID_AUTH_FIELD_ISBN = u"SW_HID_AUTH_FIELD_ISBN";
inline constexpr OUStringLiteral HID_AUTH_FIELD_LOCAL_URL = u"SW_HID_AUTH_FIELD_LOCAL_URL";
inline constexpr OUStringLiteral HID_AUTH_FIELD_TARGET_TYPE = u"SW_HID_AUTH_FIELD_TARGET_TYPE";
inline constexpr OUStringLiteral HID_AUTH_FIELD_TARGET_URL = u"SW_HID_AUTH_FIELD_TARGET_URL";


inline constexpr OUStringLiteral HID_BUSINESS_FMT_PAGE = u"SW_HID_BUSINESS_FMT_PAGE";
inline constexpr OUStringLiteral HID_BUSINESS_FMT_PAGE_CONT = u"SW_HID_BUSINESS_FMT_PAGE_CONT";
inline constexpr OUStringLiteral HID_BUSINESS_FMT_PAGE_SHEET = u"SW_HID_BUSINESS_FMT_PAGE_SHEET";
inline constexpr OUStringLiteral HID_BUSINESS_FMT_PAGE_BRAND = u"SW_HID_BUSINESS_FMT_PAGE_BRAND";
inline constexpr OUStringLiteral HID_BUSINESS_FMT_PAGE_TYPE = u"SW_HID_BUSINESS_FMT_PAGE_TYPE";
#define HID_SEND_MASTER_CTRL_PUSHBUTTON_OK                      "SW_HID_SEND_MASTER_CTRL_PUSHBUTTON_OK"
#define HID_SEND_MASTER_CTRL_PUSHBUTTON_CANCEL                  "SW_HID_SEND_MASTER_CTRL_PUSHBUTTON_CANCEL"
#define HID_SEND_MASTER_CTRL_LISTBOX_FILTER                     "SW_HID_SEND_MASTER_CTRL_LISTBOX_FILTER"
#define HID_SEND_MASTER_CTRL_CONTROL_FILEVIEW                   "SW_HID_SEND_MASTER_CTRL_CONTROL_FILEVIEW"
#define HID_SEND_MASTER_CTRL_EDIT_FILEURL                       "SW_HID_SEND_MASTER_CTRL_EDIT_FILEURL"
#define HID_SEND_MASTER_CTRL_CHECKBOX_AUTOEXTENSION             "SW_HID_SEND_MASTER_CTRL_CHECKBOX_AUTOEXTENSION"
#define HID_SEND_MASTER_CTRL_LISTBOX_TEMPLATE                   "SW_HID_SEND_MASTER_CTRL_LISTBOX_TEMPLATE"

#define HID_SEND_HTML_CTRL_PUSHBUTTON_OK                        "SW_HID_SEND_HTML_CTRL_PUSHBUTTON_OK"
#define HID_SEND_HTML_CTRL_PUSHBUTTON_CANCEL                    "SW_HID_SEND_HTML_CTRL_PUSHBUTTON_CANCEL"
#define HID_SEND_HTML_CTRL_LISTBOX_FILTER                       "SW_HID_SEND_HTML_CTRL_LISTBOX_FILTER"
#define HID_SEND_HTML_CTRL_CONTROL_FILEVIEW                     "SW_HID_SEND_HTML_CTRL_CONTROL_FILEVIEW"
#define HID_SEND_HTML_CTRL_EDIT_FILEURL                         "SW_HID_SEND_HTML_CTRL_EDIT_FILEURL"
#define HID_SEND_HTML_CTRL_CHECKBOX_AUTOEXTENSION               "SW_HID_SEND_HTML_CTRL_CHECKBOX_AUTOEXTENSION"
#define HID_SEND_HTML_CTRL_LISTBOX_TEMPLATE                     "SW_HID_SEND_HTML_CTRL_LISTBOX_TEMPLATE"

inline constexpr OUStringLiteral HID_PVIEW_ZOOM_LB = u"SW_HID_PVIEW_ZOOM_LB";

inline constexpr OUStringLiteral HID_MM_NEXT_PAGE = u"SW_HID_MM_NEXT_PAGE";
inline constexpr OUStringLiteral HID_MM_PREV_PAGE = u"SW_HID_MM_PREV_PAGE";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_ELEMENTS = u"SW_HID_MM_ADDBLOCK_ELEMENTS";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_INSERT = u"SW_HID_MM_ADDBLOCK_INSERT";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_REMOVE = u"SW_HID_MM_ADDBLOCK_REMOVE";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_DRAG = u"SW_HID_MM_ADDBLOCK_DRAG";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_PREVIEW = u"SW_HID_MM_ADDBLOCK_PREVIEW";
inline constexpr OUStringLiteral HID_MM_ADDBLOCK_MOVEBUTTONS = u"SW_HID_MM_ADDBLOCK_MOVEBUTTONS";

inline constexpr OUStringLiteral HID_TBX_FORMULA_CALC = u"SW_HID_TBX_FORMULA_CALC";
inline constexpr OUStringLiteral HID_TBX_FORMULA_CANCEL = u"SW_HID_TBX_FORMULA_CANCEL";
inline constexpr OUStringLiteral HID_TBX_FORMULA_APPLY = u"SW_HID_TBX_FORMULA_APPLY";

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
