/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.trove.TLongHashingStrategy;
import com.squareup.haha.trove.TLongProcedure;
import com.squareup.haha.trove.TPrimitiveHash;

public abstract class TLongHash
extends TPrimitiveHash
implements TLongHashingStrategy {
    protected transient long[] _set;
    protected TLongHashingStrategy _hashingStrategy = this;

    @Override
    public Object clone() {
        TLongHash h = (TLongHash)super.clone();
        ((TLongHash)super.clone())._set = (long[])this._set.clone();
        return h;
    }

    @Override
    protected final int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new long[capacity];
        return capacity;
    }

    public final boolean contains(long val) {
        long l = val;
        TLongHash tLongHash = this;
        byte[] byArray = tLongHash._states;
        long[] lArray = tLongHash._set;
        int n = byArray.length;
        int n2 = tLongHash._hashingStrategy.computeHashCode(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
            int n4 = 1 + n2 % (n - 2);
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l));
        }
        return (byArray[n3] == 0 ? -1 : n3) >= 0;
    }

    public final boolean forEach(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] set = this._set;
        int i = this._set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final void removeAt(int index) {
        this._set[index] = 0L;
        super.removeAt(index);
    }

    protected final int insertionIndex(long val) {
        byte[] states = this._states;
        long[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            if (states[index] == 1) {
                return -index - 1;
            }
            return firstRemoved;
        }
        if (states[index] == 1) {
            return -index - 1;
        }
        return index;
    }

    @Override
    public final int computeHashCode(long val) {
        long l = val;
        return (int)(l ^ l >> 32);
    }
}

