/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.trove.TObjectHash;
import com.squareup.haha.trove.TObjectHashIterator;
import com.squareup.haha.trove.TObjectProcedure;
import com.squareup.haha.trove.ToObjectArrayProcedure;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class THashSet<E>
extends TObjectHash<E>
implements Set<E> {
    @Override
    public final boolean add(E obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    @Override
    public final boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll(that);
    }

    @Override
    public final int hashCode() {
        HashProcedure p = new HashProcedure(this);
        this.forEach(p);
        HashProcedure hashProcedure = p;
        return hashProcedure.h;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    @Override
    public final Object[] toArray() {
        Object[] result = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure<Object>(result));
        return result;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        T[] result = a;
        Iterator<E> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public final void clear() {
        super.clear();
        Object[] set = this._set;
        int i = this._set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    @Override
    public final boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public final Iterator<E> iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        int size = collection.size();
        this.ensureCapacity(size);
        Iterator<E> it = collection.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        int size = collection.size();
        Iterator<?> it = collection.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        int size = this.size();
        Iterator<E> it = this.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    final class HashProcedure
    implements TObjectProcedure<E> {
        int h;
        private /* synthetic */ THashSet this$0;

        HashProcedure(THashSet tHashSet) {
            this.this$0 = tHashSet;
        }

        @Override
        public final boolean execute(E key) {
            this.h += this.this$0._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

