/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptMemberFilter;

public class DescriptorKeepChecker
extends SimplifiedVisitor
implements MemberVisitor,
ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private Clazz referencingClass;
    private Member referencingMember;
    private boolean isField;

    public DescriptorKeepChecker(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
    }

    public void checkClassSpecifications(List list) {
        this.programClassPool.classesAccept(new ClassCleaner());
        this.libraryClassPool.classesAccept(new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(list, keepMarker, keepMarker, false, true, true);
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        this.programClassPool.classesAccept(new AllMemberVisitor(new KeptMemberFilter(this)));
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.referencingClass = programClass;
        this.referencingMember = programMethod;
        this.isField = false;
        Clazz[] clazzArray = programMethod.referencedClasses;
        if (clazzArray != null) {
            int n = clazzArray.length;
            if (ClassUtil.isInternalClassType(programMethod.getDescriptor(programClass))) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                if (clazzArray[i] == null) continue;
                clazzArray[i].accept(this);
            }
        }
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!KeepMarker.isKept(programClass)) {
            this.notePrinter.print(this.referencingClass.getName(), programClass.getName(), "Note: the configuration keeps the entry point '" + ClassUtil.externalClassName(this.referencingClass.getName()) + " { " + (this.isField ? ClassUtil.externalFullFieldDescription(0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass)) : ClassUtil.externalFullMethodDescription(this.referencingClass.getName(), 0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass))) + "; }', but not the descriptor class '" + ClassUtil.externalClassName(programClass.getName()) + "'");
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

