/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2010, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms,
with or without modification, are permitted provided that the
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** MACHINE-GENERATED by scripts/ICFImporter/CppGenerator.py */


#ifndef ASSIMP_BUILD_NO_IFC_IMPORTER

#include "IFCReaderGen.h"

namespace Assimp {
using namespace IFC;

namespace STEP {

template <> size_t GenericFill<IfcLightSource>(const DB& db, const LIST& params, IfcLightSource* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLightSourceAmbient>(const DB& db, const LIST& params, IfcLightSourceAmbient* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLightSource*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLightSourceDirectional>(const DB& db, const LIST& params, IfcLightSourceDirectional* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLightSource*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLightSourceGoniometric>(const DB& db, const LIST& params, IfcLightSourceGoniometric* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLightSource*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLightSourcePositional>(const DB& db, const LIST& params, IfcLightSourcePositional* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLightSource*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLightSourceSpot>(const DB& db, const LIST& params, IfcLightSourceSpot* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLightSourcePositional*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLine>(const DB& db, const LIST& params, IfcLine* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCurve*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcLine"); }    do { // convert the 'Pnt' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Pnt, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcLine to be a `IfcCartesianPoint`")); }
    } while(0);
    do { // convert the 'Dir' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Dir, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcLine to be a `IfcVector`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLinearDimension>(const DB& db, const LIST& params, IfcLinearDimension* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcDimensionCurveDirectedCallout*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcLocalPlacement>(const DB& db, const LIST& params, IfcLocalPlacement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcObjectPlacement*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcLocalPlacement"); }    do { // convert the 'PlacementRelTo' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->PlacementRelTo, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcLocalPlacement to be a `IfcObjectPlacement`")); }
    } while(0);
    do { // convert the 'RelativePlacement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelativePlacement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcLocalPlacement to be a `IfcAxis2Placement`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMappedItem>(const DB& db, const LIST& params, IfcMappedItem* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRepresentationItem*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcMappedItem"); }    do { // convert the 'MappingSource' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->MappingSource, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcMappedItem to be a `IfcRepresentationMap`")); }
    } while(0);
    do { // convert the 'MappingTarget' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->MappingTarget, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcMappedItem to be a `IfcCartesianTransformationOperator`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProductRepresentation>(const DB& db, const LIST& params, IfcProductRepresentation* in)
{
    size_t base = 0;
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to IfcProductRepresentation"); }    do { // convert the 'Name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcProductRepresentation,3>::aux_is_derived[0]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Name, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcProductRepresentation to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'Description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcProductRepresentation,3>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Description, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcProductRepresentation to be a `IfcText`")); }
    } while(0);
    do { // convert the 'Representations' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcProductRepresentation,3>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->Representations, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcProductRepresentation to be a `LIST [1:?] OF IfcRepresentation`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMaterialDefinitionRepresentation>(const DB& db, const LIST& params, IfcMaterialDefinitionRepresentation* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProductRepresentation*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMeasureWithUnit>(const DB& db, const LIST& params, IfcMeasureWithUnit* in)
{
    size_t base = 0;
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcMeasureWithUnit"); }    do { // convert the 'ValueComponent' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->ValueComponent, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcMeasureWithUnit to be a `IfcValue`")); }
    } while(0);
    do { // convert the 'UnitComponent' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->UnitComponent, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcMeasureWithUnit to be a `IfcUnit`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMechanicalFastener>(const DB& db, const LIST& params, IfcMechanicalFastener* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFastener*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMechanicalFastenerType>(const DB& db, const LIST& params, IfcMechanicalFastenerType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFastenerType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMember>(const DB& db, const LIST& params, IfcMember* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMemberType>(const DB& db, const LIST& params, IfcMemberType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMotorConnectionType>(const DB& db, const LIST& params, IfcMotorConnectionType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEnergyConversionDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProcess>(const DB& db, const LIST& params, IfcProcess* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcObject*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTask>(const DB& db, const LIST& params, IfcTask* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProcess*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcMove>(const DB& db, const LIST& params, IfcMove* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTask*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOccupant>(const DB& db, const LIST& params, IfcOccupant* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcActor*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOffsetCurve2D>(const DB& db, const LIST& params, IfcOffsetCurve2D* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCurve*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOffsetCurve3D>(const DB& db, const LIST& params, IfcOffsetCurve3D* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCurve*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOneDirectionRepeatFactor>(const DB& db, const LIST& params, IfcOneDirectionRepeatFactor* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOpenShell>(const DB& db, const LIST& params, IfcOpenShell* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcConnectedFaceSet*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOpeningElement>(const DB& db, const LIST& params, IfcOpeningElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFeatureElementSubtraction*>(in));
    if (params.GetSize() < 8) { throw STEP::TypeError("expected 8 arguments to IfcOpeningElement"); }   return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOrderAction>(const DB& db, const LIST& params, IfcOrderAction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTask*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOrientedEdge>(const DB& db, const LIST& params, IfcOrientedEdge* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEdge*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcOutletType>(const DB& db, const LIST& params, IfcOutletType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowTerminalType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPath>(const DB& db, const LIST& params, IfcPath* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTopologicalRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPerformanceHistory>(const DB& db, const LIST& params, IfcPerformanceHistory* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPermit>(const DB& db, const LIST& params, IfcPermit* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPile>(const DB& db, const LIST& params, IfcPile* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPipeFittingType>(const DB& db, const LIST& params, IfcPipeFittingType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowFittingType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPipeSegmentType>(const DB& db, const LIST& params, IfcPipeSegmentType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowSegmentType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPlanarExtent>(const DB& db, const LIST& params, IfcPlanarExtent* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPlanarBox>(const DB& db, const LIST& params, IfcPlanarBox* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcPlanarExtent*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPlane>(const DB& db, const LIST& params, IfcPlane* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcElementarySurface*>(in));
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcPlane"); }    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPlate>(const DB& db, const LIST& params, IfcPlate* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPlateType>(const DB& db, const LIST& params, IfcPlateType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPointOnCurve>(const DB& db, const LIST& params, IfcPointOnCurve* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcPoint*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPointOnSurface>(const DB& db, const LIST& params, IfcPointOnSurface* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcPoint*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPolyLoop>(const DB& db, const LIST& params, IfcPolyLoop* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLoop*>(in));
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcPolyLoop"); }    do { // convert the 'Polygon' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Polygon, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcPolyLoop to be a `LIST [3:?] OF IfcCartesianPoint`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPolygonalBoundedHalfSpace>(const DB& db, const LIST& params, IfcPolygonalBoundedHalfSpace* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcHalfSpaceSolid*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcPolygonalBoundedHalfSpace"); }    do { // convert the 'Position' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Position, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcPolygonalBoundedHalfSpace to be a `IfcAxis2Placement3D`")); }
    } while(0);
    do { // convert the 'PolygonalBoundary' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->PolygonalBoundary, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcPolygonalBoundedHalfSpace to be a `IfcBoundedCurve`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPolyline>(const DB& db, const LIST& params, IfcPolyline* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBoundedCurve*>(in));
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcPolyline"); }    do { // convert the 'Points' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Points, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcPolyline to be a `LIST [2:?] OF IfcCartesianPoint`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPresentationStyleAssignment>(const DB& db, const LIST& params, IfcPresentationStyleAssignment* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcPresentationStyleAssignment"); }    do { // convert the 'Styles' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Styles, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcPresentationStyleAssignment to be a `SET [1:?] OF IfcPresentationStyleSelect`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProcedure>(const DB& db, const LIST& params, IfcProcedure* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProcess*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProductDefinitionShape>(const DB& db, const LIST& params, IfcProductDefinitionShape* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProductRepresentation*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProject>(const DB& db, const LIST& params, IfcProject* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcObject*>(in));
    if (params.GetSize() < 9) { throw STEP::TypeError("expected 9 arguments to IfcProject"); }    do { // convert the 'LongName' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->LongName, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcProject to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'Phase' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Phase, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 6 to IfcProject to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'RepresentationContexts' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RepresentationContexts, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 7 to IfcProject to be a `SET [1:?] OF IfcRepresentationContext`")); }
    } while(0);
    do { // convert the 'UnitsInContext' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->UnitsInContext, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 8 to IfcProject to be a `IfcUnitAssignment`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProjectOrder>(const DB& db, const LIST& params, IfcProjectOrder* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProjectOrderRecord>(const DB& db, const LIST& params, IfcProjectOrderRecord* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProjectionCurve>(const DB& db, const LIST& params, IfcProjectionCurve* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcAnnotationCurveOccurrence*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProjectionElement>(const DB& db, const LIST& params, IfcProjectionElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFeatureElementAddition*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSimpleProperty>(const DB& db, const LIST& params, IfcSimpleProperty* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProperty*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcSimpleProperty"); }   return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertyBoundedValue>(const DB& db, const LIST& params, IfcPropertyBoundedValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertyEnumeratedValue>(const DB& db, const LIST& params, IfcPropertyEnumeratedValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertyListValue>(const DB& db, const LIST& params, IfcPropertyListValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcPropertyListValue"); }    do { // convert the 'ListValues' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->ListValues, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcPropertyListValue to be a `LIST [1:?] OF IfcValue`")); }
    } while(0);
    do { // convert the 'Unit' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Unit, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcPropertyListValue to be a `IfcUnit`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertyReferenceValue>(const DB& db, const LIST& params, IfcPropertyReferenceValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertySet>(const DB& db, const LIST& params, IfcPropertySet* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcPropertySetDefinition*>(in));
    if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to IfcPropertySet"); }    do { // convert the 'HasProperties' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->HasProperties, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcPropertySet to be a `SET [1:?] OF IfcProperty`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertySingleValue>(const DB& db, const LIST& params, IfcPropertySingleValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcPropertySingleValue"); }    do { // convert the 'NominalValue' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->NominalValue, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcPropertySingleValue to be a `IfcValue`")); }
    } while(0);
    do { // convert the 'Unit' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Unit, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcPropertySingleValue to be a `IfcUnit`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPropertyTableValue>(const DB& db, const LIST& params, IfcPropertyTableValue* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSimpleProperty*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProtectiveDeviceType>(const DB& db, const LIST& params, IfcProtectiveDeviceType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowControllerType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcProxy>(const DB& db, const LIST& params, IfcProxy* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProduct*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcPumpType>(const DB& db, const LIST& params, IfcPumpType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowMovingDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRadiusDimension>(const DB& db, const LIST& params, IfcRadiusDimension* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcDimensionCurveDirectedCallout*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRailing>(const DB& db, const LIST& params, IfcRailing* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRailingType>(const DB& db, const LIST& params, IfcRailingType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRamp>(const DB& db, const LIST& params, IfcRamp* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRampFlight>(const DB& db, const LIST& params, IfcRampFlight* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRampFlightType>(const DB& db, const LIST& params, IfcRampFlightType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRationalBezierCurve>(const DB& db, const LIST& params, IfcRationalBezierCurve* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBezierCurve*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRectangleProfileDef>(const DB& db, const LIST& params, IfcRectangleProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcParameterizedProfileDef*>(in));
    if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to IfcRectangleProfileDef"); }    do { // convert the 'XDim' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRectangleProfileDef,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->XDim, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcRectangleProfileDef to be a `IfcPositiveLengthMeasure`")); }
    } while(0);
    do { // convert the 'YDim' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRectangleProfileDef,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->YDim, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRectangleProfileDef to be a `IfcPositiveLengthMeasure`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRectangleHollowProfileDef>(const DB& db, const LIST& params, IfcRectangleHollowProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRectangleProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRectangularPyramid>(const DB& db, const LIST& params, IfcRectangularPyramid* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCsgPrimitive3D*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRectangularTrimmedSurface>(const DB& db, const LIST& params, IfcRectangularTrimmedSurface* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBoundedSurface*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcReinforcingElement>(const DB& db, const LIST& params, IfcReinforcingElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementComponent*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcReinforcingBar>(const DB& db, const LIST& params, IfcReinforcingBar* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcReinforcingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcReinforcingMesh>(const DB& db, const LIST& params, IfcReinforcingMesh* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcReinforcingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelationship>(const DB& db, const LIST& params, IfcRelationship* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRoot*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcRelationship"); } return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelDecomposes>(const DB& db, const LIST& params, IfcRelDecomposes* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelationship*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelDecomposes"); }    do { // convert the 'RelatingObject' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRelDecomposes,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->RelatingObject, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRelDecomposes to be a `IfcObjectDefinition`")); }
    } while(0);
    do { // convert the 'RelatedObjects' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRelDecomposes,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->RelatedObjects, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcRelDecomposes to be a `SET [1:?] OF IfcObjectDefinition`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelAggregates>(const DB& db, const LIST& params, IfcRelAggregates* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelDecomposes*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelAggregates"); }    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelConnects>(const DB& db, const LIST& params, IfcRelConnects* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelationship*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcRelConnects"); }  return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelContainedInSpatialStructure>(const DB& db, const LIST& params, IfcRelContainedInSpatialStructure* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelConnects*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelContainedInSpatialStructure"); }    do { // convert the 'RelatedElements' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatedElements, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRelContainedInSpatialStructure to be a `SET [1:?] OF IfcProduct`")); }
    } while(0);
    do { // convert the 'RelatingStructure' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatingStructure, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcRelContainedInSpatialStructure to be a `IfcSpatialStructureElement`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelDefines>(const DB& db, const LIST& params, IfcRelDefines* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelationship*>(in));
    if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to IfcRelDefines"); }    do { // convert the 'RelatedObjects' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRelDefines,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->RelatedObjects, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRelDefines to be a `SET [1:?] OF IfcObject`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelDefinesByProperties>(const DB& db, const LIST& params, IfcRelDefinesByProperties* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelDefines*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelDefinesByProperties"); }    do { // convert the 'RelatingPropertyDefinition' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRelDefinesByProperties,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->RelatingPropertyDefinition, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcRelDefinesByProperties to be a `IfcPropertySetDefinition`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelFillsElement>(const DB& db, const LIST& params, IfcRelFillsElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelConnects*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelFillsElement"); }    do { // convert the 'RelatingOpeningElement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatingOpeningElement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRelFillsElement to be a `IfcOpeningElement`")); }
    } while(0);
    do { // convert the 'RelatedBuildingElement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatedBuildingElement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcRelFillsElement to be a `IfcElement`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelOverridesProperties>(const DB& db, const LIST& params, IfcRelOverridesProperties* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelDefinesByProperties*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRelVoidsElement>(const DB& db, const LIST& params, IfcRelVoidsElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRelConnects*>(in));
    if (params.GetSize() < 6) { throw STEP::TypeError("expected 6 arguments to IfcRelVoidsElement"); }    do { // convert the 'RelatingBuildingElement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatingBuildingElement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcRelVoidsElement to be a `IfcElement`")); }
    } while(0);
    do { // convert the 'RelatedOpeningElement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->RelatedOpeningElement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcRelVoidsElement to be a `IfcFeatureElementSubtraction`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRepresentation>(const DB& db, const LIST& params, IfcRepresentation* in)
{
    size_t base = 0;
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcRepresentation"); }    do { // convert the 'ContextOfItems' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRepresentation,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->ContextOfItems, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcRepresentation to be a `IfcRepresentationContext`")); }
    } while(0);
    do { // convert the 'RepresentationIdentifier' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRepresentation,4>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->RepresentationIdentifier, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcRepresentation to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'RepresentationType' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRepresentation,4>::aux_is_derived[2]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->RepresentationType, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcRepresentation to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'Items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcRepresentation,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->Items, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcRepresentation to be a `SET [1:?] OF IfcRepresentationItem`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRepresentationMap>(const DB& db, const LIST& params, IfcRepresentationMap* in)
{
    size_t base = 0;
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcRepresentationMap"); }    do { // convert the 'MappingOrigin' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->MappingOrigin, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcRepresentationMap to be a `IfcAxis2Placement`")); }
    } while(0);
    do { // convert the 'MappedRepresentation' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->MappedRepresentation, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcRepresentationMap to be a `IfcRepresentation`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRevolvedAreaSolid>(const DB& db, const LIST& params, IfcRevolvedAreaSolid* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSweptAreaSolid*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcRevolvedAreaSolid"); }    do { // convert the 'Axis' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Axis, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcRevolvedAreaSolid to be a `IfcAxis1Placement`")); }
    } while(0);
    do { // convert the 'Angle' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Angle, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcRevolvedAreaSolid to be a `IfcPlaneAngleMeasure`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRightCircularCone>(const DB& db, const LIST& params, IfcRightCircularCone* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCsgPrimitive3D*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRightCircularCylinder>(const DB& db, const LIST& params, IfcRightCircularCylinder* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCsgPrimitive3D*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRoof>(const DB& db, const LIST& params, IfcRoof* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRoundedEdgeFeature>(const DB& db, const LIST& params, IfcRoundedEdgeFeature* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEdgeFeature*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcRoundedRectangleProfileDef>(const DB& db, const LIST& params, IfcRoundedRectangleProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRectangleProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSIUnit>(const DB& db, const LIST& params, IfcSIUnit* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcNamedUnit*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to IfcSIUnit"); }    do { // convert the 'Prefix' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Prefix, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcSIUnit to be a `IfcSIPrefix`")); }
    } while(0);
    do { // convert the 'Name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Name, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcSIUnit to be a `IfcSIUnitName`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSanitaryTerminalType>(const DB& db, const LIST& params, IfcSanitaryTerminalType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowTerminalType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcScheduleTimeControl>(const DB& db, const LIST& params, IfcScheduleTimeControl* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSectionedSpine>(const DB& db, const LIST& params, IfcSectionedSpine* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSensorType>(const DB& db, const LIST& params, IfcSensorType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcDistributionControlElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcServiceLife>(const DB& db, const LIST& params, IfcServiceLife* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcShapeModel>(const DB& db, const LIST& params, IfcShapeModel* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRepresentation*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcShapeRepresentation>(const DB& db, const LIST& params, IfcShapeRepresentation* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcShapeModel*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcShellBasedSurfaceModel>(const DB& db, const LIST& params, IfcShellBasedSurfaceModel* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcShellBasedSurfaceModel"); }    do { // convert the 'SbsmBoundary' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->SbsmBoundary, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcShellBasedSurfaceModel to be a `SET [1:?] OF IfcShell`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSite>(const DB& db, const LIST& params, IfcSite* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSpatialStructureElement*>(in));
    if (params.GetSize() < 14) { throw STEP::TypeError("expected 14 arguments to IfcSite"); }    do { // convert the 'RefLatitude' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->RefLatitude, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 9 to IfcSite to be a `IfcCompoundPlaneAngleMeasure`")); }
    } while(0);
    do { // convert the 'RefLongitude' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->RefLongitude, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 10 to IfcSite to be a `IfcCompoundPlaneAngleMeasure`")); }
    } while(0);
    do { // convert the 'RefElevation' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->RefElevation, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 11 to IfcSite to be a `IfcLengthMeasure`")); }
    } while(0);
    do { // convert the 'LandTitleNumber' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->LandTitleNumber, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 12 to IfcSite to be a `IfcLabel`")); }
    } while(0);
    do { // convert the 'SiteAddress' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->SiteAddress, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 13 to IfcSite to be a `IfcPostalAddress`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSlab>(const DB& db, const LIST& params, IfcSlab* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSlabType>(const DB& db, const LIST& params, IfcSlabType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSpace>(const DB& db, const LIST& params, IfcSpace* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSpatialStructureElement*>(in));
    if (params.GetSize() < 11) { throw STEP::TypeError("expected 11 arguments to IfcSpace"); }    do { // convert the 'InteriorOrExteriorSpace' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->InteriorOrExteriorSpace, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 9 to IfcSpace to be a `IfcInternalOrExternalEnum`")); }
    } while(0);
    do { // convert the 'ElevationWithFlooring' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->ElevationWithFlooring, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 10 to IfcSpace to be a `IfcLengthMeasure`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSpaceHeaterType>(const DB& db, const LIST& params, IfcSpaceHeaterType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEnergyConversionDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSpaceProgram>(const DB& db, const LIST& params, IfcSpaceProgram* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSpatialStructureElementType>(const DB& db, const LIST& params, IfcSpatialStructureElementType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSpaceType>(const DB& db, const LIST& params, IfcSpaceType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSpatialStructureElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSphere>(const DB& db, const LIST& params, IfcSphere* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcCsgPrimitive3D*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStackTerminalType>(const DB& db, const LIST& params, IfcStackTerminalType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowTerminalType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStair>(const DB& db, const LIST& params, IfcStair* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStairFlight>(const DB& db, const LIST& params, IfcStairFlight* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStairFlightType>(const DB& db, const LIST& params, IfcStairFlightType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralActivity>(const DB& db, const LIST& params, IfcStructuralActivity* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProduct*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralAction>(const DB& db, const LIST& params, IfcStructuralAction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralActivity*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralAnalysisModel>(const DB& db, const LIST& params, IfcStructuralAnalysisModel* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSystem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralItem>(const DB& db, const LIST& params, IfcStructuralItem* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcProduct*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralConnection>(const DB& db, const LIST& params, IfcStructuralConnection* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralCurveConnection>(const DB& db, const LIST& params, IfcStructuralCurveConnection* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralConnection*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralMember>(const DB& db, const LIST& params, IfcStructuralMember* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralCurveMember>(const DB& db, const LIST& params, IfcStructuralCurveMember* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralMember*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralCurveMemberVarying>(const DB& db, const LIST& params, IfcStructuralCurveMemberVarying* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralCurveMember*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralLinearAction>(const DB& db, const LIST& params, IfcStructuralLinearAction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralAction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralLinearActionVarying>(const DB& db, const LIST& params, IfcStructuralLinearActionVarying* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralLinearAction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralLoadGroup>(const DB& db, const LIST& params, IfcStructuralLoadGroup* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGroup*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralPlanarAction>(const DB& db, const LIST& params, IfcStructuralPlanarAction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralAction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralPlanarActionVarying>(const DB& db, const LIST& params, IfcStructuralPlanarActionVarying* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralPlanarAction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralPointAction>(const DB& db, const LIST& params, IfcStructuralPointAction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralAction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralPointConnection>(const DB& db, const LIST& params, IfcStructuralPointConnection* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralConnection*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralReaction>(const DB& db, const LIST& params, IfcStructuralReaction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralActivity*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralPointReaction>(const DB& db, const LIST& params, IfcStructuralPointReaction* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralReaction*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralResultGroup>(const DB& db, const LIST& params, IfcStructuralResultGroup* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGroup*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralSurfaceConnection>(const DB& db, const LIST& params, IfcStructuralSurfaceConnection* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralConnection*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralSurfaceMember>(const DB& db, const LIST& params, IfcStructuralSurfaceMember* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralMember*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuralSurfaceMemberVarying>(const DB& db, const LIST& params, IfcStructuralSurfaceMemberVarying* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStructuralSurfaceMember*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStructuredDimensionCallout>(const DB& db, const LIST& params, IfcStructuredDimensionCallout* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcDraughtingCallout*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStyleModel>(const DB& db, const LIST& params, IfcStyleModel* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcRepresentation*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcStyledRepresentation>(const DB& db, const LIST& params, IfcStyledRepresentation* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcStyleModel*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSubContractResource>(const DB& db, const LIST& params, IfcSubContractResource* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcConstructionResource*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSubedge>(const DB& db, const LIST& params, IfcSubedge* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEdge*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceCurveSweptAreaSolid>(const DB& db, const LIST& params, IfcSurfaceCurveSweptAreaSolid* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSweptAreaSolid*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSweptSurface>(const DB& db, const LIST& params, IfcSweptSurface* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSurface*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceOfLinearExtrusion>(const DB& db, const LIST& params, IfcSurfaceOfLinearExtrusion* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSweptSurface*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceOfRevolution>(const DB& db, const LIST& params, IfcSurfaceOfRevolution* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSweptSurface*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceStyle>(const DB& db, const LIST& params, IfcSurfaceStyle* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcPresentationStyle*>(in));
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to IfcSurfaceStyle"); }    do { // convert the 'Side' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Side, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcSurfaceStyle to be a `IfcSurfaceSide`")); }
    } while(0);
    do { // convert the 'Styles' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Styles, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcSurfaceStyle to be a `SET [1:5] OF IfcSurfaceStyleElementSelect`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceStyleShading>(const DB& db, const LIST& params, IfcSurfaceStyleShading* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcSurfaceStyleShading"); }    do { // convert the 'SurfaceColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::IFC::IfcSurfaceStyleShading,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->SurfaceColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcSurfaceStyleShading to be a `IfcColourRgb`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceStyleRendering>(const DB& db, const LIST& params, IfcSurfaceStyleRendering* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSurfaceStyleShading*>(in));
    if (params.GetSize() < 9) { throw STEP::TypeError("expected 9 arguments to IfcSurfaceStyleRendering"); }    do { // convert the 'Transparency' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->Transparency, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcSurfaceStyleRendering to be a `IfcNormalisedRatioMeasure`")); }
    } while(0);
    do { // convert the 'DiffuseColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->DiffuseColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcSurfaceStyleRendering to be a `IfcColourOrFactor`")); }
    } while(0);
    do { // convert the 'TransmissionColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->TransmissionColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcSurfaceStyleRendering to be a `IfcColourOrFactor`")); }
    } while(0);
    do { // convert the 'DiffuseTransmissionColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->DiffuseTransmissionColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcSurfaceStyleRendering to be a `IfcColourOrFactor`")); }
    } while(0);
    do { // convert the 'ReflectionColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->ReflectionColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to IfcSurfaceStyleRendering to be a `IfcColourOrFactor`")); }
    } while(0);
    do { // convert the 'SpecularColour' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->SpecularColour, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 6 to IfcSurfaceStyleRendering to be a `IfcColourOrFactor`")); }
    } while(0);
    do { // convert the 'SpecularHighlight' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->SpecularHighlight, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 7 to IfcSurfaceStyleRendering to be a `IfcSpecularHighlightSelect`")); }
    } while(0);
    do { // convert the 'ReflectanceMethod' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->ReflectanceMethod, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 8 to IfcSurfaceStyleRendering to be a `IfcReflectanceMethodEnum`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSurfaceStyleWithTextures>(const DB& db, const LIST& params, IfcSurfaceStyleWithTextures* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcSurfaceStyleWithTextures"); }    do { // convert the 'Textures' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Textures, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcSurfaceStyleWithTextures to be a `LIST [1:?] OF IfcSurfaceTexture`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSweptDiskSolid>(const DB& db, const LIST& params, IfcSweptDiskSolid* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcSolidModel*>(in));
    if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to IfcSweptDiskSolid"); }    do { // convert the 'Directrix' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Directrix, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcSweptDiskSolid to be a `IfcCurve`")); }
    } while(0);
    do { // convert the 'Radius' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Radius, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcSweptDiskSolid to be a `IfcPositiveLengthMeasure`")); }
    } while(0);
    do { // convert the 'InnerRadius' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->InnerRadius, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcSweptDiskSolid to be a `IfcPositiveLengthMeasure`")); }
    } while(0);
    do { // convert the 'StartParam' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->StartParam, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcSweptDiskSolid to be a `IfcParameterValue`")); }
    } while(0);
    do { // convert the 'EndParam' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->EndParam, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcSweptDiskSolid to be a `IfcParameterValue`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSwitchingDeviceType>(const DB& db, const LIST& params, IfcSwitchingDeviceType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowControllerType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcSystemFurnitureElementType>(const DB& db, const LIST& params, IfcSystemFurnitureElementType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFurnishingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTShapeProfileDef>(const DB& db, const LIST& params, IfcTShapeProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcParameterizedProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTankType>(const DB& db, const LIST& params, IfcTankType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowStorageDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTendon>(const DB& db, const LIST& params, IfcTendon* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcReinforcingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTendonAnchor>(const DB& db, const LIST& params, IfcTendonAnchor* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcReinforcingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTextLiteral>(const DB& db, const LIST& params, IfcTextLiteral* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTextLiteralWithExtent>(const DB& db, const LIST& params, IfcTextLiteralWithExtent* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTextLiteral*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTimeSeriesSchedule>(const DB& db, const LIST& params, IfcTimeSeriesSchedule* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTopologyRepresentation>(const DB& db, const LIST& params, IfcTopologyRepresentation* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcShapeModel*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTransformerType>(const DB& db, const LIST& params, IfcTransformerType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEnergyConversionDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTransportElement>(const DB& db, const LIST& params, IfcTransportElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTransportElementType>(const DB& db, const LIST& params, IfcTransportElementType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTrapeziumProfileDef>(const DB& db, const LIST& params, IfcTrapeziumProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcParameterizedProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTrimmedCurve>(const DB& db, const LIST& params, IfcTrimmedCurve* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBoundedCurve*>(in));
    if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to IfcTrimmedCurve"); }    do { // convert the 'BasisCurve' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->BasisCurve, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcTrimmedCurve to be a `IfcCurve`")); }
    } while(0);
    do { // convert the 'Trim1' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Trim1, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcTrimmedCurve to be a `SET [1:2] OF IfcTrimmingSelect`")); }
    } while(0);
    do { // convert the 'Trim2' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Trim2, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to IfcTrimmedCurve to be a `SET [1:2] OF IfcTrimmingSelect`")); }
    } while(0);
    do { // convert the 'SenseAgreement' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->SenseAgreement, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to IfcTrimmedCurve to be a `BOOLEAN`")); }
    } while(0);
    do { // convert the 'MasterRepresentation' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->MasterRepresentation, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to IfcTrimmedCurve to be a `IfcTrimmingPreference`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTubeBundleType>(const DB& db, const LIST& params, IfcTubeBundleType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEnergyConversionDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcTwoDirectionRepeatFactor>(const DB& db, const LIST& params, IfcTwoDirectionRepeatFactor* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcOneDirectionRepeatFactor*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcUShapeProfileDef>(const DB& db, const LIST& params, IfcUShapeProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcParameterizedProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcUnitAssignment>(const DB& db, const LIST& params, IfcUnitAssignment* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to IfcUnitAssignment"); }    do { // convert the 'Units' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Units, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcUnitAssignment to be a `SET [1:?] OF IfcUnit`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcUnitaryEquipmentType>(const DB& db, const LIST& params, IfcUnitaryEquipmentType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcEnergyConversionDeviceType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcValveType>(const DB& db, const LIST& params, IfcValveType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowControllerType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVector>(const DB& db, const LIST& params, IfcVector* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGeometricRepresentationItem*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to IfcVector"); }    do { // convert the 'Orientation' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Orientation, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to IfcVector to be a `IfcDirection`")); }
    } while(0);
    do { // convert the 'Magnitude' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->Magnitude, arg, db ); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to IfcVector to be a `IfcLengthMeasure`")); }
    } while(0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVertex>(const DB& db, const LIST& params, IfcVertex* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTopologicalRepresentationItem*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVertexLoop>(const DB& db, const LIST& params, IfcVertexLoop* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcLoop*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVertexPoint>(const DB& db, const LIST& params, IfcVertexPoint* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcVertex*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVibrationIsolatorType>(const DB& db, const LIST& params, IfcVibrationIsolatorType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcDiscreteAccessoryType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcVirtualElement>(const DB& db, const LIST& params, IfcVirtualElement* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWall>(const DB& db, const LIST& params, IfcWall* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWallStandardCase>(const DB& db, const LIST& params, IfcWallStandardCase* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcWall*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWallType>(const DB& db, const LIST& params, IfcWallType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElementType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWasteTerminalType>(const DB& db, const LIST& params, IfcWasteTerminalType* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcFlowTerminalType*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWindow>(const DB& db, const LIST& params, IfcWindow* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcBuildingElement*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWindowStyle>(const DB& db, const LIST& params, IfcWindowStyle* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcTypeProduct*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWorkControl>(const DB& db, const LIST& params, IfcWorkControl* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWorkPlan>(const DB& db, const LIST& params, IfcWorkPlan* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcWorkControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcWorkSchedule>(const DB& db, const LIST& params, IfcWorkSchedule* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcWorkControl*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcZShapeProfileDef>(const DB& db, const LIST& params, IfcZShapeProfileDef* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcParameterizedProfileDef*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<IfcZone>(const DB& db, const LIST& params, IfcZone* in)
{
    size_t base = GenericFill(db,params,static_cast<IfcGroup*>(in));
// this data structure is not used yet, so there is no code generated to fill its members
    return base;
}

} // ! STEP
} // ! Assimp

#endif
