/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.chromium.devtools.jsdoc.DoDidNodeVisitor;
import org.chromium.devtools.jsdoc.DoDidVisitorAdapter;
import org.chromium.devtools.jsdoc.ValidationCheck;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.ContextTrackingValidationCheck;

public class FileCheckerCallable
implements Callable<ValidatorContext> {
    private static Set<String> EXTRA_ANNOTATIONS = new HashSet<String>(Arrays.asList("suppressReceiverCheck", "suppressGlobalPropertiesCheck"));
    private final String fileName;

    public FileCheckerCallable(String string) {
        this.fileName = string;
    }

    @Override
    public ValidatorContext call() {
        try {
            ValidatorContext validatorContext = new ValidatorContext(this.readScriptText(), this.fileName);
            ValidationCheckDispatcher validationCheckDispatcher = new ValidationCheckDispatcher(validatorContext);
            validationCheckDispatcher.registerCheck(new ContextTrackingValidationCheck());
            NodeTraversal.traverseEs6ScopeRoots(new Compiler(), FileCheckerCallable.parseScript(validatorContext), null, validationCheckDispatcher, true);
            return validatorContext;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileCheckerCallable.logError("File not found: " + this.fileName);
        }
        catch (IOException iOException) {
            FileCheckerCallable.logError("Failed to read file " + this.fileName);
        }
        return null;
    }

    private String readScriptText() throws IOException {
        byte[] byArray = Files.readAllBytes(FileSystems.getDefault().getPath(this.fileName, new String[0]));
        String string = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray)).toString();
        return string;
    }

    private static Node parseScript(ValidatorContext validatorContext) {
        Config config = ParserRunner.createConfig(Config.LanguageMode.ECMASCRIPT6, Config.JsDocParsing.INCLUDE_DESCRIPTIONS_WITH_WHITESPACE, Config.RunMode.KEEP_GOING, EXTRA_ANNOTATIONS, true, Config.StrictMode.STRICT);
        ErrorReporter errorReporter = new ErrorReporter(){

            @Override
            public void warning(String string, String string2, int n, int n2) {
            }

            @Override
            public void error(String string, String string2, int n, int n2) {
                FileCheckerCallable.logError("at " + string2 + ":" + n + ":" + n2);
            }
        };
        try {
            return ParserRunner.parse((StaticSourceFile)validatorContext.sourceFile, (String)validatorContext.sourceFile.getCode(), (Config)config, (ErrorReporter)errorReporter).ast;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void logError(String string) {
        System.err.println("ERROR: " + string);
    }

    private static class ValidationCheckDispatcher
    extends DoDidVisitorAdapter {
        private final List<ValidationCheck> checks = new ArrayList<ValidationCheck>(2);
        private final ValidatorContext context;

        public ValidationCheckDispatcher(ValidatorContext validatorContext) {
            this.context = validatorContext;
        }

        public void registerCheck(ValidationCheck validationCheck) {
            validationCheck.setContext(this.context);
            this.checks.add(validationCheck);
        }

        @Override
        public void doVisit(Node node) {
            for (DoDidNodeVisitor doDidNodeVisitor : this.checks) {
                doDidNodeVisitor.doVisit(node);
            }
        }

        @Override
        public void didVisit(Node node) {
            for (ValidationCheck validationCheck : this.checks) {
                validationCheck.didVisit(node);
            }
        }
    }
}

