/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.base.Function;
import com.squareup.haha.guava.base.Joiner$MapJoiner;
import com.squareup.haha.guava.base.Predicate;
import com.squareup.haha.guava.base.Predicates;
import com.squareup.haha.guava.collect.Collections2;
import com.squareup.haha.guava.collect.ForwardingMap;
import com.squareup.haha.guava.collect.ImmutableEntry;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.Ordering;
import com.squareup.haha.guava.collect.Sets$ImprovedAbstractSet;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public final class Maps {
    private static Joiner$MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER$5f22bbb7.withKeyValueSeparator("=");

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return Iterators.transform(entryIterator, EntryFunction.KEY);
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return Iterators.transform(entryIterator, EntryFunction.VALUE);
    }

    static <K, V> UnmodifiableIterator<V> valueIterator(UnmodifiableIterator<Map.Entry<K, V>> entryIterator) {
        return new UnmodifiableIterator<V>(entryIterator){
            private /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public final V next() {
                return ((Map.Entry)this.val$entryIterator.next()).getValue();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Ascii.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    static <V> Predicate<Map.Entry<?, V>> valuePredicateOnEntries(Predicate<? super V> valuePredicate) {
        return Predicates.compose(valuePredicate, EntryFunction.VALUE);
    }

    static <V> V safeGet(Map<?, V> map, @Nullable Object key) {
        Ascii.checkNotNull(map);
        try {
            return map.get(key);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Ascii.checkNotNull(map);
        try {
            return map.containsKey(key);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    static <V> V safeRemove(Map<?, V> map, Object key) {
        Ascii.checkNotNull(map);
        try {
            return map.remove(key);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map o = (Map)object;
            return map.entrySet().equals(o.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        Map<?, ?> map2 = map;
        StringBuilder stringBuilder = sb;
        Joiner$MapJoiner joiner$MapJoiner = STANDARD_JOINER;
        Set<Map.Entry<?, ?>> set = map2.entrySet();
        StringBuilder stringBuilder2 = stringBuilder;
        Joiner$MapJoiner joiner$MapJoiner2 = joiner$MapJoiner;
        joiner$MapJoiner.appendTo(stringBuilder2, set.iterator());
        return sb.append('}').toString();
    }

    @Nullable
    static <K> K keyOrNull(@Nullable Map.Entry<K, ?> entry) {
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    static abstract class DescendingMap<K, V>
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private transient Comparator<? super K> comparator;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient NavigableSet<K> navigableKeySet;

        DescendingMap() {
        }

        abstract NavigableMap<K, V> forward();

        @Override
        protected final Map<K, V> delegate() {
            return this.forward();
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<? super K> result = this.comparator;
            if (result == null) {
                Comparator forwardCmp = this.forward().comparator();
                if (forwardCmp == null) {
                    forwardCmp = Ordering.natural();
                }
                Comparator comparator = forwardCmp;
                result = this.comparator = Ordering.from(comparator).reverse();
            }
            return result;
        }

        @Override
        public K firstKey() {
            return this.forward().lastKey();
        }

        @Override
        public K lastKey() {
            return this.forward().firstKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.forward().higherEntry(key);
        }

        @Override
        public K lowerKey(K key) {
            return this.forward().higherKey(key);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.forward().ceilingEntry(key);
        }

        @Override
        public K floorKey(K key) {
            return this.forward().ceilingKey(key);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.forward().floorEntry(key);
        }

        @Override
        public K ceilingKey(K key) {
            return this.forward().floorKey(key);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.forward().lowerEntry(key);
        }

        @Override
        public K higherKey(K key) {
            return this.forward().lowerKey(key);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.forward().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.forward().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.forward().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.forward().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.forward();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                DescendingMap descendingMap = this;
                this.entrySet = new EntrySet<K, V>(descendingMap){
                    private /* synthetic */ DescendingMap this$0;
                    {
                        this.this$0 = descendingMap;
                    }

                    @Override
                    final Map<K, V> map() {
                        return this.this$0;
                    }

                    @Override
                    public final Iterator<Map.Entry<K, V>> iterator() {
                        return this.this$0.entryIterator();
                    }
                };
                return this.entrySet;
            }
            return result;
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            NavigableSet<K> result = this.navigableKeySet;
            if (result == null) {
                this.navigableKeySet = new NavigableKeySet(this);
                return this.navigableKeySet;
            }
            return result;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.forward().navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return this.forward().subMap(toKey, toInclusive, fromKey, fromInclusive).descendingMap();
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            return this.forward().tailMap(toKey, inclusive).descendingMap();
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            return this.forward().headMap(fromKey, inclusive).descendingMap();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public Collection<V> values() {
            return new Values(this);
        }

        @Override
        public String toString() {
            DescendingMap descendingMap = this;
            return Maps.toStringImpl(descendingMap);
        }
    }

    static abstract class EntrySet<K, V>
    extends Sets$ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                V value = Maps.safeGet(this.map(), key);
                return Ascii.equal(value, entry.getValue()) && (value != null || this.map().containsKey(key));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return Ascii.removeAllImpl(this, c.iterator());
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                int n = c.size();
                HashSet keys = new HashSet(Maps.capacity(n));
                for (Object o : c) {
                    if (!this.contains(o)) continue;
                    Map.Entry entry = (Map.Entry)o;
                    keys.add(entry.getKey());
                }
                return this.map().keySet().retainAll(keys);
            }
        }
    }

    static class Values<K, V>
    extends AbstractCollection<V> {
        private Map<K, V> map;

        Values(Map<K, V> map) {
            this.map = Ascii.checkNotNull(map);
        }

        @Override
        public Iterator<V> iterator() {
            Values values = this;
            return Maps.valueIterator(values.map.entrySet().iterator());
        }

        @Override
        public boolean remove(Object o) {
            try {
                return super.remove(o);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Values values = this;
                for (Map.Entry<K, V> entry : values.map.entrySet()) {
                    if (!Ascii.equal(o, entry.getValue())) continue;
                    values = this;
                    values.map.remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> toRemove = new HashSet<K>();
                Values values = this;
                for (Map.Entry<K, V> entry : values.map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                values = this;
                return values.map.keySet().removeAll(toRemove);
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> toRetain = new HashSet<K>();
                Values values = this;
                for (Map.Entry<K, V> entry : values.map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRetain.add(entry.getKey());
                }
                values = this;
                return values.map.keySet().retainAll(toRetain);
            }
        }

        @Override
        public int size() {
            Values values = this;
            return values.map.size();
        }

        @Override
        public boolean isEmpty() {
            Values values = this;
            return values.map.isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            Values values = this;
            return values.map.containsValue(o);
        }

        @Override
        public void clear() {
            Values values = this;
            values.map.clear();
        }
    }

    static final class NavigableKeySet<K, V>
    extends SortedKeySet<K, V>
    implements NavigableSet<K> {
        NavigableKeySet(NavigableMap<K, V> map) {
            super(map);
        }

        @Override
        public final K lower(K e) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).lowerKey(e);
        }

        @Override
        public final K floor(K e) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).floorKey(e);
        }

        @Override
        public final K ceiling(K e) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).ceilingKey(e);
        }

        @Override
        public final K higher(K e) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).higherKey(e);
        }

        @Override
        public final K pollFirst() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollFirstEntry());
        }

        @Override
        public final K pollLast() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollLastEntry());
        }

        @Override
        public final NavigableSet<K> descendingSet() {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).descendingKeySet();
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public final NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).subMap(fromElement, fromInclusive, toElement, toInclusive).navigableKeySet();
        }

        @Override
        public final NavigableSet<K> headSet(K toElement, boolean inclusive) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).headMap(toElement, inclusive).navigableKeySet();
        }

        @Override
        public final NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).tailMap(fromElement, inclusive).navigableKeySet();
        }

        @Override
        public final SortedSet<K> subSet(K fromElement, K toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public final SortedSet<K> headSet(K toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public final SortedSet<K> tailSet(K fromElement) {
            return this.tailSet(fromElement, true);
        }
    }

    static class SortedKeySet<K, V>
    extends KeySet<K, V>
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, V> map) {
            super(map);
        }

        @Override
        SortedMap<K, V> map() {
            return (SortedMap)super.map();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map().comparator();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new SortedKeySet(this.map().subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return new SortedKeySet(this.map().headMap(toElement));
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return new SortedKeySet(this.map().tailMap(fromElement));
        }

        @Override
        public K first() {
            return this.map().firstKey();
        }

        @Override
        public K last() {
            return this.map().lastKey();
        }
    }

    static class KeySet<K, V>
    extends Sets$ImprovedAbstractSet<K> {
        final Map<K, V> map;

        KeySet(Map<K, V> map) {
            this.map = Ascii.checkNotNull(map);
        }

        Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(this.map().entrySet().iterator());
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map().containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                this.map().remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    static abstract class ImprovedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Set<K> keySet;
        private transient Collection<V> values;

        ImprovedAbstractMap() {
        }

        abstract Set<Map.Entry<K, V>> createEntrySet();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = this.createEntrySet();
                return this.entrySet;
            }
            return result;
        }

        @Override
        public Set<K> keySet() {
            Set<K> result = this.keySet;
            if (result == null) {
                this.keySet = this.createKeySet();
                return this.keySet;
            }
            return result;
        }

        Set<K> createKeySet() {
            return new KeySet(this);
        }

        @Override
        public Collection<V> values() {
            Collection<V> result = this.values;
            if (result == null) {
                this.values = this.createValues();
                return this.values;
            }
            return result;
        }

        Collection<V> createValues() {
            return new Values(this);
        }
    }

    static final class FilteredMapValues<K, V>
    extends Values<K, V> {
        private Map<K, V> unfiltered;
        private Predicate<? super Map.Entry<K, V>> predicate;

        FilteredMapValues(Map<K, V> filteredMap, Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
            super(filteredMap);
            this.unfiltered = unfiltered;
            this.predicate = predicate;
        }

        @Override
        public final boolean remove(Object o) {
            Object v0;
            block1: {
                Predicate<Map.Entry<?, Object>> predicate = Predicates.and(this.predicate, Maps.valuePredicateOnEntries(Predicates.equalTo(o)));
                Set<Map.Entry<K, V>> set = this.unfiltered.entrySet();
                Ascii.checkNotNull(predicate);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!predicate.apply((Map.Entry<?, Object>)t)) continue;
                    iterator.remove();
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        @Override
        private boolean removeIf(Predicate<? super V> valuePredicate) {
            Predicate<Map.Entry<?, ? super V>> predicate = Predicates.and(this.predicate, Maps.valuePredicateOnEntries(valuePredicate));
            Set<Map.Entry<K, V>> set = this.unfiltered.entrySet();
            if (set instanceof RandomAccess && set instanceof List) {
                return Ascii.removeIfFromRandomAccessList((List)((Object)set), Ascii.checkNotNull(predicate));
            }
            return Iterators.removeIf(set.iterator(), predicate);
        }

        @Override
        public final boolean removeAll(Collection<?> collection) {
            return this.removeIf(Predicates.in(collection));
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            return this.removeIf(Predicates.not(Predicates.in(collection)));
        }

        @Override
        public final Object[] toArray() {
            return Ascii.newArrayList(this.iterator()).toArray();
        }

        @Override
        public final <T> T[] toArray(T[] array) {
            return Ascii.newArrayList(this.iterator()).toArray(array);
        }
    }

    static abstract class AbstractFilteredMap<K, V>
    extends ImprovedAbstractMap<K, V> {
        private Map<K, V> unfiltered;
        private Predicate<? super Map.Entry<K, V>> predicate;

        private boolean apply(@Nullable Object key, @Nullable V value) {
            Object k = key;
            return this.predicate.apply(Maps.immutableEntry(k, value));
        }

        @Override
        public V put(K key, V value) {
            Ascii.checkArgument(this.apply(key, value));
            return this.unfiltered.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Ascii.checkArgument(this.apply(entry.getKey(), entry.getValue()));
            }
            this.unfiltered.putAll(map);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.unfiltered.containsKey(key) && this.apply(key, this.unfiltered.get(key));
        }

        @Override
        public V get(Object key) {
            V value = this.unfiltered.get(key);
            if (value != null && this.apply(key, value)) {
                return value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public V remove(Object key) {
            if (this.containsKey(key)) {
                return this.unfiltered.remove(key);
            }
            return null;
        }

        @Override
        final Collection<V> createValues() {
            return new FilteredMapValues<K, V>(this, this.unfiltered, this.predicate);
        }
    }

    static abstract class EntryFunction
    extends Enum<EntryFunction>
    implements Function<Map.Entry<?, ?>, Object> {
        public static final /* enum */ EntryFunction KEY = new EntryFunction(){};
        public static final /* enum */ EntryFunction VALUE = new EntryFunction(){};

        private EntryFunction() {
        }

        /* synthetic */ EntryFunction(String x0, int x1, byte by) {
            this();
        }

        static {
            EntryFunction[] entryFunctionArray = new EntryFunction[]{KEY, VALUE};
        }
    }
}

