/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.os.IBinder;
import com.google.vr.dynamite.client.IObjectWrapper;
import com.google.vr.dynamite.client.UsedByReflection;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

@UsedByReflection(value="ObjectWrapper.java")
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    @UsedByReflection(value="ObjectWrapper.java")
    private final T wrappedObject;

    private ObjectWrapper(T object) {
        this.wrappedObject = object;
    }

    public static <T> IObjectWrapper wrap(T object) {
        return new ObjectWrapper<T>(object);
    }

    @UsedByReflection(value="ObjectWrapper.java")
    public static <T> T unwrap(IObjectWrapper remote, Class<T> clazz) {
        if (remote == null) {
            return null;
        }
        if (remote instanceof ObjectWrapper) {
            ObjectWrapper typedRemote = (ObjectWrapper)remote;
            return typedRemote.wrappedObject;
        }
        IBinder remoteBinder = remote.asBinder();
        Class<?> remoteClazz = remoteBinder.getClass();
        AccessibleObject validField = null;
        for (Field field : remoteClazz.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            if (validField != null) {
                validField = null;
                break;
            }
            validField = field;
        }
        if (validField != null) {
            if (!validField.isAccessible()) {
                ((Field)validField).setAccessible(true);
                try {
                    Object wrappedObject = ((Field)validField).get(remoteBinder);
                    if (wrappedObject == null) {
                        return null;
                    }
                    if (!clazz.isInstance(wrappedObject)) {
                        throw new IllegalArgumentException("remoteBinder is the wrong class.");
                    }
                    return clazz.cast(wrappedObject);
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Binder object is null.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("remoteBinder is the wrong class.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Could not access the field in remoteBinder.", e);
                }
            }
            throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly one declared *private* field for the wrapped object. Preferably, this is an instance of the ObjectWrapper<T> class.");
        }
        throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly *one* declared private field for the wrapped object.  Preferably, this is an instance of the ObjectWrapper<T> class.");
    }
}

