# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: BSD-3-Clause

if(CMAKE_SYSTEM_NAME STREQUAL "Linux")
    set(LINUX 1)
else()
    set(LINUX 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "HPUX")
    set(HPUX 1)
else()
    set(HPUX 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "Android")
    set(ANDROID 1)
else()
    set(ANDROID 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "Integrity")
    set(INTEGRITY 1)
else()
    set(INTEGRITY 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "VxWorks")
    set(VXWORKS 1)
else()
    set(VXWORKS 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "QNX")
    set(QNX 1)
else()
    set(QNX 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "OpenBSD")
    set(OPENBSD 1)
else()
    set(OPENBSD 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "FreeBSD")
    set(FREEBSD 1)
else()
    set(FREEBSD 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "NetBSD")
    set(NETBSD 1)
else()
    set(NETBSD 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "Emscripten" OR EMSCRIPTEN)
    set(WASM 1)
else()
    set(WASM 0)
endif()

if(QT_QMAKE_TARGET_MKSPEC STREQUAL "wasm-emscripten-64")
    set(WASM64 1)
else()
    set(WASM64 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "SunOS")
    set(SOLARIS 1)
else()
    set(SOLARIS 0)
endif()

if(CMAKE_SYSTEM_NAME STREQUAL "GNU")
    set(HURD 1)
else()
    set(HURD 0)
endif()

# This is the only reliable way we can determine the webOS platform as the yocto recipe adds this
# compile definition into its generated toolchain.cmake file
if(CMAKE_CXX_FLAGS MATCHES "-D__WEBOS__")
    set(WEBOS 1)
else()
    set(WEBOS 0)
endif()

if(APPLE OR OPENBSD OR FREEBSD OR NETBSD)
    set(BSD 1)
else()
    set(BSD 0)
endif()

if(APPLE)
    if(CMAKE_SYSTEM_NAME STREQUAL "iOS")
        set(IOS 1)
    else()
        set(IOS 0)
    endif()

    if(CMAKE_SYSTEM_NAME STREQUAL "tvOS")
        set(TVOS 1)
    else()
        set(TVOS 0)
    endif()

    if(CMAKE_SYSTEM_NAME STREQUAL "watchOS")
        set(WATCHOS 1)
    else()
        set(WATCHOS 0)
    endif()

    if(CMAKE_SYSTEM_NAME STREQUAL "visionOS")
        set(VISIONOS 1)
    else()
        set(VISIONOS 0)
    endif()

    if(IOS OR TVOS OR WATCHOS OR VISIONOS)
        set(UIKIT 1)
        set(MACOS 0)
    else()
        set(UIKIT 0)
        set(MACOS 1)
    endif()
endif()

if(CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
    set(GCC 1)
else()
    set(GCC 0)
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES "Clang|IntelLLVM")
    set(CLANG 1)
else()
    set(CLANG 0)
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES "AppleClang")
    set(APPLECLANG 1)
else()
    set(APPLECLANG 0)
endif()

if(CMAKE_CXX_COMPILER_ID STREQUAL "IntelLLVM")
    set(IntelLLVM 1)
else()
    set(IntelLLVM 0)
endif()

if(CMAKE_CXX_COMPILER_ID STREQUAL "QCC")
    set(QCC 1)
else()
    set(QCC 0)
endif()

if(CMAKE_SIZEOF_VOID_P EQUAL 8)
    set(QT_64BIT TRUE)
elseif(CMAKE_SIZEOF_VOID_P EQUAL 4)
    set(QT_32BIT TRUE)
endif()

# Parses a version string like "xx.yy.zz" and sets the major, minor and patch variables.
function(qt_parse_version_string version_string out_var_prefix)
    string(REPLACE "." ";" version_list ${version_string})
    list(LENGTH version_list length)

    set(out_var "${out_var_prefix}_MAJOR")
    set(value "")
    if(length GREATER 0)
        list(GET version_list 0 value)
        list(REMOVE_AT version_list 0)
        math(EXPR length "${length}-1")
    endif()
    set(${out_var} "${value}" PARENT_SCOPE)

    set(out_var "${out_var_prefix}_MINOR")
    set(value "")
    if(length GREATER 0)
        list(GET version_list 0 value)
        set(${out_var} "${value}" PARENT_SCOPE)
        list(REMOVE_AT version_list 0)
        math(EXPR length "${length}-1")
    endif()
    set(${out_var} "${value}" PARENT_SCOPE)

    set(out_var "${out_var_prefix}_PATCH")
    set(value "")
    if(length GREATER 0)
        list(GET version_list 0 value)
        set(${out_var} "${value}" PARENT_SCOPE)
        list(REMOVE_AT version_list 0)
        math(EXPR length "${length}-1")
    endif()
    set(${out_var} "${value}" PARENT_SCOPE)
endfunction()

# Set up the separate version components for the compiler version, to allow mapping of qmake
# conditions like 'equals(QT_GCC_MAJOR_VERSION,5)'.
if(CMAKE_CXX_COMPILER_VERSION)
    qt_parse_version_string("${CMAKE_CXX_COMPILER_VERSION}" "QT_COMPILER_VERSION")
endif()
