/**************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**************************************************************************/

#ifndef ELEVATEDEXECUTEOPERATION_H
#define ELEVATEDEXECUTEOPERATION_H

#include "qinstallerglobal.h"

namespace QInstaller {

class INSTALLER_EXPORT ElevatedExecuteOperation : public QObject, public Operation
{
    Q_OBJECT

public:
    enum Error {
        NoError = 0,
        Error,
        NeedsRerun
    };

    explicit ElevatedExecuteOperation(PackageManagerCore *core);
    ~ElevatedExecuteOperation();

    void backup() override;
    bool performOperation() override;
    bool undoOperation() override;
    bool testOperation() override;

Q_SIGNALS:
    void cancelProcess();
    void outputTextChanged(const QString &text);

public Q_SLOTS:
    void cancelOperation();

private:
    Q_PRIVATE_SLOT(d, void readProcessOutput())

    class Private;
    Private *d;
};

} // namespace

#endif
