untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3kasVF8CJ1CGP+9xG1bBjx5FFYcYF5HGIg+QkFceU3VbzXIPorTZE2d6/z2WWA0tNuHV20rigXJOn2u1Y7hLBws=

OpenBSD 6.7 errata 034, January 11, 2021:

When an NDP entry is invalidated the associated layer 2 address
is not invalidated.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 034_nd6.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet6/nd6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/nd6.c,v
diff -u -p -r1.231 nd6.c
--- sys/netinet6/nd6.c	22 Apr 2020 07:51:38 -0000	1.231
+++ sys/netinet6/nd6.c	5 Jan 2021 17:45:09 -0000
@@ -690,8 +690,10 @@ void
 nd6_invalidate(struct rtentry *rt)
 {
 	struct llinfo_nd6 *ln = (struct llinfo_nd6 *)rt->rt_llinfo;
+	struct sockaddr_dl *sdl = satosdl(rt->rt_gateway);
 
 	m_freem(ln->ln_hold);
+	sdl->sdl_alen = 0;
 	ln->ln_hold = NULL;
 	ln->ln_state = ND6_LLINFO_INCOMPLETE;
 	ln->ln_asked = 0;

