untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT/rgcj9Y6htaMDPPUMT0/FFcgFipVV/QwD3POpVV7mUz9BYRPN4PgDJog1d0fBEOSCacRNUNjfZd+FdpM6wJ5Aw=

OpenBSD 6.5 errata 002, May 16, 2019:

LibreSSL servers did not provide an SRTP profile, so DTLS negotiation failed.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 002_srtp.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then build and install libssl:
    cd /usr/src/lib/libssl
    make obj
    make
    make install

Index: lib/libssl/ssl_tlsext.c
===================================================================
diff -u -p -r1.44 ssl_tlsext.c
--- lib/libssl/ssl_tlsext.c	25 Mar 2019 17:21:18 -0000	1.44
+++ lib/libssl/ssl_tlsext.c	9 May 2019 09:58:04 -0000
@@ -1822,7 +1822,8 @@ static struct tls_extension tls_extensio
 #ifndef OPENSSL_NO_SRTP
 	{
 		.type = TLSEXT_TYPE_use_srtp,
-		.messages = SSL_TLSEXT_MSG_CH | SSL_TLSEXT_MSG_EE,
+		.messages = SSL_TLSEXT_MSG_CH | SSL_TLSEXT_MSG_SH /* XXX */ |
+		    SSL_TLSEXT_MSG_EE,
 		.client = {
 			.needs = tlsext_srtp_client_needs,
 			.build = tlsext_srtp_client_build,
