/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of 'Malaysia'

* @author docmoe
*/
(function($) {
    $.extend(true, $.fn.mapael, 
        {
            maps :{
                malaysia : {
                    width : 792.50256,
                    height : 262.17609,
                    getCoords : function (lat, lon) {
                        // todo
                        return {"x" : lat, "y" : lon};
                    },
                    elems : {
                        "Brunei" : "m 626.19,99.58 0.17,0.66 0.56,0.76 0.53,0.15 -0.08,0.45 0,0 0.6,0.52 0,0 1.28,0.85 0.48,0.61 -0.25,1.38 0.11,0.32 0.65,0.57 0.22,0.37 0.07,0.63 -0.19,0.82 0.14,0.42 0.43,0.4 -0.06,0.61 -0.26,0.39 0.29,0.33 0.8,0.55 0.18,1.15 -0.16,0.48 -0.03,0.78 -0.63,0.9 0.13,0.48 -0.11,0.89 0.29,0.37 0,0.93 0.22,0.58 -0.2,0.69 0.17,0.56 0.24,0.45 0.67,0.74 1.46,1.1 0.46,0.89 0.54,0.61 -0.04,0.72 -0.58,0.56 -0.59,0.34 -0.26,0.07 -0.47,-0.12 -0.37,-0.37 -0.22,-0.58 -0.29,-0.25 -0.52,-0.24 -1.25,0.16 -0.21,-1.07 -0.31,-0.23 -1.57,0.12 -2.1,-0.76 0,0 -0.54,0.06 0,0 -0.18,0.1 -0.6,0 -0.47,-0.33 -0.14,-0.26 0.17,-0.92 -0.33,-1.28 0.16,-1.3 -1.32,-4.26 -0.52,-0.85 -0.18,-0.59 -0.03,-0.86 -0.15,-0.36 -0.08,-0.93 -0.31,-0.64 0,0 0.02,-0.44 0,0 0.13,-0.67 -0.39,-1.27 0.54,-1.4 0,0 -0.02,-0.17 -0.43,-0.25 -0.08,-0.39 0.08,-0.1 0.52,0.13 0.05,0.47 0.37,0.39 -0.16,-0.49 0.11,-0.96 0.25,-0.24 1.06,-0.42 0.9,-0.21 0.16,-0.45 -0.13,-0.28 -0.44,-0.22 -0.17,-0.3 -0.02,-0.49 0.76,-0.5 1.47,-0.06 z m -4.01,-5.23 0.26,0.13 1.04,-0.05 -0.94,0.68 -0.22,0.81 -0.51,-0.15 -0.57,0.08 0.1,0.88 0.37,0.4 -0.12,0.22 -0.69,0.54 -0.4,0.72 0.01,0.45 0.19,0.1 0.12,0.32 -0.05,0.35 -0.77,0.39 0,0 -1.24,2.34 -0.53,0.28 -2.2,0.31 -1.27,0.33 -0.52,0.34 -0.61,1.54 -0.44,0.37 -1.15,0.11 -0.35,0.11 -0.24,0.25 -0.17,0.77 0.03,0.74 0.88,1.46 0.16,1.01 0.41,3.73 -0.07,1.47 0.23,2.58 0.28,0.52 0.44,0.26 1.33,0.3 0.25,0.16 -0.06,1.97 -1.05,2.1 -1.36,1.54 -0.08,0.62 0.09,0.25 0.34,-0.03 0.96,-0.92 0.12,0.08 -0.43,1.26 -1.51,2.21 -0.51,0.46 -0.13,0.53 0.07,0.15 0.88,-0.11 -0.08,0.27 -0.23,0.35 -1.32,0.93 -0.66,1.09 -0.69,0.87 -0.93,0.88 -1.85,1.09 0,0 -1.64,0.51 0,0 -0.66,-0.16 0,0 0.05,-0.28 0,0 0.69,-0.75 -0.13,-0.41 -1.32,-0.22 -0.97,-0.61 -0.89,-1.42 -0.29,-0.79 -0.63,-0.65 -1.43,-0.16 -0.97,-1.6 -0.67,-1.44 -0.18,-0.77 -0.06,-1.01 -0.25,-0.31 -0.33,-0.1 -0.32,0.1 -0.46,0.64 -0.31,0.11 -1.4,-0.44 -0.27,0.06 -0.45,0.36 -0.4,0.11 -1.01,-0.25 -0.29,-0.22 -0.05,-1.31 0.5,-1.76 -0.12,-0.21 -0.73,-0.57 -0.1,-0.22 0.13,-1.61 -1.79,-3.1 -1.09,-1.41 0,0 -0.8,-0.52 0,0 -0.38,-0.11 -0.48,0.16 -0.95,-1.23 -0.63,-0.34 0,0 -1.16,-0.28 2.89,-0.12 2.25,-0.36 3.45,-1.06 4.07,-1.54 1.27,-0.64 1.48,-0.88 1.7,-1.28 5.48,-4.78 4.07,-2.64 2.57,-2.13 0.21,0.12 0.33,-0.06 6.74,-2.77 1.07,-0.32 0.05,0.23 z",
                        "Johor" : "m 152.54,244.29 -0.13,-0.1 -0.04,-0.27 0.11,-0.96 0.69,0.45 -0.02,0.59 -0.61,0.29 z m -37.49,-32.36 0.95,-0.22 0,0 0.64,-0.37 0.05,-0.94 -0.08,-0.32 -0.49,-0.46 -1.5,-0.53 -0.13,-0.53 0.05,-0.28 0.56,-0.36 0.19,-0.31 0,-1.68 0.25,-0.43 0.59,-3.18 0.88,-0.76 0.1,-0.62 1.78,-0.69 0.12,-0.54 0,0 0.06,-1.07 0.2,-0.31 0.67,-0.48 0.09,-0.36 -0.23,-0.9 0.33,-0.74 -0.23,-0.96 0.04,-0.92 0.36,-0.59 0.05,-0.42 0.69,-0.35 0.1,-0.29 -0.42,-0.73 -0.1,-0.49 2.82,-7.87 0,0 3.74,1.1 7.03,8.23 7.16,3.11 0.3,0 5.14,-2.11 2.45,-0.57 0.7,-0.03 2.44,1.35 1.4,0.23 1,1.22 4.38,2.21 0.59,0.12 0.35,-0.27 0.3,0.25 0.23,-0.03 0.48,-0.75 -0.3,-0.29 0,-0.53 -0.34,-0.53 0.02,-0.59 -0.15,-0.1 -0.76,0.2 -0.27,-0.22 0.14,-0.95 0.65,-0.27 0.25,0.04 -0.11,-0.44 -0.39,0.26 -0.15,-0.05 -0.06,-0.37 0.28,-0.31 0.57,-0.09 -0.29,-0.26 0.1,-0.37 0.23,-0.15 -0.21,-0.41 0,-0.3 0.13,-0.13 -0.25,-0.23 -0.03,-0.56 -0.2,0.66 -0.43,-0.03 -0.22,-0.31 -0.06,-0.65 0.23,-0.29 0.41,-0.11 0.66,0.22 0.29,-0.01 0.08,-0.36 0,0 0.26,0.2 0.62,0.12 0.35,-0.11 0.29,0.04 1.22,0.63 1.55,0.49 0.45,-0.18 0.03,-0.45 0.33,-0.11 0.34,0.45 -0.28,0.62 0.11,0.3 1.83,1.37 0.24,0.09 0.2,-0.28 0.26,0.16 0,0.16 -0.34,0.23 0.28,1.33 0.35,0.71 0.59,0.62 -0.11,0.16 -0.9,0.22 -0.13,0.29 0.9,2.18 0.57,0.23 0.51,0.92 1.81,2.26 0.98,0.25 0.24,0.46 0.78,0.94 -0.41,0.34 0.07,0.25 0.53,0.89 0.6,0.6 0.05,0.36 -0.44,-0.14 -0.48,0.29 -0.11,1.03 0.16,0.45 2.34,3.14 1.12,2.49 2.77,3.96 0.35,1.25 0.28,0.43 -0.02,0.27 -0.09,0.01 -0.25,-0.22 -0.1,-0.35 -0.29,-0.09 -0.25,1.11 0,0.76 0.18,0.57 0.32,0.53 0.61,0.63 0.34,0.11 0.39,-0.1 0,-0.38 0.44,0.37 -0.13,0.77 0.4,0.7 0.8,1.01 0.47,1.17 0.04,0.68 0.81,1.06 -0.26,0.36 0.03,0.31 0.69,1.04 0.64,0.64 0.06,0.22 -0.24,0.28 0.06,0.32 0.78,0.92 -0.44,0.4 0.12,0.58 -0.1,0.88 0.39,0.68 0.79,0.98 0.08,0.51 -0.45,0.25 -0.04,0.49 0.25,0.76 0.62,0.99 -0.01,0.27 -0.65,0.35 -0.08,0.19 -0.06,0.83 0.37,1.46 -0.3,0.25 -0.75,0.23 -0.27,-0.41 -0.26,-0.01 -0.78,0.75 -0.32,-0.02 -0.53,0.47 -0.58,-0.28 -0.47,-0.08 -0.55,0.26 -0.31,-0.22 -0.8,0.22 -0.3,-0.53 -0.95,-0.4 -0.68,-0.11 0.12,-0.37 0.46,-0.39 0.86,-1.06 -0.13,-0.04 -0.59,0.35 -0.5,-0.7 -2.15,-1.56 0.82,-1.09 -0.27,-0.57 0.6,-0.5 1.08,0 1.43,-0.99 0.15,-0.51 -0.83,0.69 -0.95,0.59 -0.37,-0.01 -0.5,-0.24 -0.7,0.42 -0.28,0.52 -0.03,0.3 -0.17,0.03 -0.47,-1.53 0.18,-0.73 -0.14,-0.35 -0.4,-0.64 -1.15,-1 -0.42,-0.51 -0.36,-1.23 -1.15,-0.49 -0.5,0.13 0.54,0.37 0.87,0.88 -0.09,0.49 0.25,0.82 0.11,0.17 1.05,0.69 0.67,1.52 -0.04,0.26 -0.42,0.49 0.23,1.77 -0.15,0.76 -0.74,0.65 -1.12,0.24 -1.47,-0.4 -1,0.03 -0.61,-0.31 -0.43,-0.47 -0.16,-0.48 -2.14,-0.74 -0.87,0.04 -1.11,1.16 -0.3,0.09 -0.97,-0.25 -0.37,-0.33 -0.3,-0.52 -0.3,0.07 0.17,0.56 -1.4,0.97 -1.24,1.39 -0.16,0.74 -0.36,0.59 -1.27,1.09 -0.92,0.05 -1.43,-0.39 -0.37,-1.23 0.09,-0.82 -0.2,-0.1 -0.18,0.18 0.13,1.86 0.48,0.9 -0.85,0.6 -0.43,0.58 -0.15,1.03 0.08,0.53 -0.19,0.06 -1.97,-2 -0.49,-0.24 -1.04,-2.45 -0.78,-2.59 -1.17,-2.77 -0.54,-0.84 -0.53,-0.5 -1.06,-0.76 -4.43,-1.74 -1.56,-0.77 -1.15,-0.65 -1.09,-0.95 -2.28,-1.66 -1.35,-0.66 -0.92,-0.39 -0.84,-0.17 -1.7,0.08 -2.21,-2.1 0.36,-0.37 0.03,-0.35 -2.76,-1.7 -1.15,-0.37 -1.1,-0.18 -1.59,0.02 -0.78,0.56 -0.2,-0.02 -0.75,-0.56 -1.41,-1.95 -1.62,-1.91 -2.74,-2.62 -0.28,-1.21 -0.46,-0.56 -1.59,-1.09 -0.74,-0.32 0,0 0.7,-0.17 0,0 0.19,-0.06 z m 67.7,-31.45 0.38,0.17 -0.06,0.26 0.32,0.36 0.31,1.53 0.29,0.47 0.24,0.79 0.32,0.25 -0.06,0.2 -0.23,-0.09 -0.14,0.2 0.07,0.46 0.73,0.53 -0.08,0.55 -0.25,0.39 0.14,0.38 -0.15,0.62 -0.11,0.06 -1.29,0.01 -0.58,0.17 -0.31,-0.07 -0.4,-0.22 -1.13,-1.05 0.07,-0.51 -0.2,-0.9 0.68,-0.82 1.01,-0.67 0.19,-0.34 -0.21,-0.74 -0.42,-0.35 -0.01,-0.42 0.25,-0.43 0.07,-0.65 0.56,-0.14 z",
                        "Kedah" : "m 7.63,47.01 0.11,0.32 -0.09,0.31 -0.37,0.84 -0.18,0.11 0,0.56 L 6.99,49.19 6.68,48.74 6.49,48.11 6.36,48.14 6.12,48.55 5.9,48.45 6.01,48.06 5.69,47.67 5.35,47.55 5.31,47.08 5.13,46.91 l 0.33,-0.45 0.49,-0.34 0.3,-0.72 0.1,-0.63 0.78,-0.3 0.35,-0.27 -0.01,-0.17 0.34,-0.24 0.22,0.02 0.04,0.77 -0.63,0.32 -0.05,0.41 0.09,0.27 0.08,0.08 0.25,-0.55 0.46,-0.26 0.62,0.65 0.02,0.25 -0.19,0.28 0.33,0.04 -0.01,0.21 -0.28,0.75 -0.15,0.12 -0.13,-0.53 -0.76,0.11 -0.16,0.18 0.07,0.1 z m 0.25,-10.37 0.71,0.46 0.18,0.41 -0.15,0.18 0.05,0.39 1.54,0.92 0.22,0.5 0.05,0.46 0.35,-0.19 0.08,0.11 0.04,0.29 -0.24,0.56 -0.22,0.23 0.07,0.2 0.48,0.49 -0.13,0.82 -0.43,0.05 -0.79,0.34 0.03,0.3 -0.11,0.12 -0.57,0.24 0.02,0.2 L 8.89,43.75 8.56,43.67 8.4,43.4 8.58,43.22 8.33,42.75 8.03,42.6 7.04,42.74 6.57,42.96 6.56,43.27 6.4,43.54 5.31,44.46 5.1,44.31 4.73,44.28 4.45,44.45 4.49,44.73 4.39,44.86 3.84,45.28 3.57,45.27 3.48,45.14 3.64,44.74 3.56,44.3 2.94,43.21 3.3,42.58 3.2,41.71 2.88,41.14 2.13,41.37 1.72,41.2 1.54,40.92 0.64,41.18 0.48,41.1 0.25,40.77 0.04,39.83 0.17,39.41 0.02,38.15 l 0.34,-0.09 0.7,0.46 0.27,-0.07 0.18,-0.34 0.42,0.15 0.67,-0.17 0.86,0.25 0.24,-0.04 -0.14,0.52 0.11,0.16 0.19,0.03 0.13,-0.46 0.21,-0.05 1.3,0.21 0.62,-0.13 0.84,-1.21 0.4,0.14 0.27,-0.21 0.63,0.47 -0.23,-0.62 -0.85,-0.16 -0.02,-0.15 0.28,-0.37 0.44,0.17 z m 22.15,-2.34 1.76,0.46 1.18,-0.47 0.46,0.43 0.84,-0.18 0.22,0.14 0.35,0.84 0.94,0.56 0.86,0.09 0.12,-0.23 0.4,-0.2 0.5,0.51 1.37,0.48 1.14,0.54 1.06,0.26 0.85,-0.1 1.01,-0.7 0.18,-0.45 0.79,-1.11 0.12,0 0.32,0.21 -0.02,0.66 0.13,0.74 0.25,0.42 1.21,0.18 1.13,0.42 0.52,0.58 0.09,0.37 -0.18,0.89 0.03,1.7 0.33,0.39 0.46,-0.41 0.24,0.12 0.08,1.68 -0.5,0.56 -0.07,0.38 0.75,1.82 0.28,0.15 0.27,-0.15 0.26,-0.6 0.21,-0.14 1.04,0.67 0.6,-0.26 0.82,0.07 0.29,-0.23 0.96,-1.28 0.26,-0.09 0.42,0.22 0.41,0.61 0.54,0.5 0.31,0.12 2.98,-0.3 0.68,0.36 0.07,0.13 -0.26,0.44 0.86,1.72 -0.31,0.4 -0.45,0.24 -1.29,0.37 -0.2,0.47 -0.49,0.65 1.4,0.53 1.56,1.1 0.05,0.22 -0.09,0.16 -0.43,0.27 -0.21,0.66 -0.39,0.32 -0.12,0.27 0.39,0.65 -0.24,1.6 0.83,0.84 -1.16,1.35 -0.43,0.79 L 58.43,59 58.29,59.28 57.88,59 57.11,59.08 56.3,59 l -0.43,0.21 0.14,0.46 -0.79,1.12 -0.01,1.11 0.13,0.56 -0.51,0.56 -0.49,0.32 -0.04,0.36 0.14,0.41 0,0 0.04,0.18 -0.21,0.56 -0.33,0.03 -0.82,-0.2 -0.14,0.03 -0.11,0.21 0.06,1.05 0.45,0.54 0.53,0.31 0.19,0.26 0.04,0.3 -0.39,1.1 0.02,0.74 -0.13,0.51 -0.41,0.14 -0.4,-0.08 -0.24,0.88 -0.58,0.45 -0.07,0.2 0.03,0.54 0.45,0.53 0.05,0.95 0.19,0.34 0,0.27 -0.93,1.97 -0.6,0.28 -0.69,-0.17 -0.31,0.22 -0.23,0.41 -0.27,0.82 -0.04,1.18 -0.49,0.82 0.11,0.66 -0.42,1.85 -0.5,0.26 -0.93,0.95 -0.48,-0.05 -0.67,0.22 -0.53,-0.12 -1.1,0.25 -0.08,0.4 -0.27,0.38 0.02,0.98 -0.37,0.37 -0.49,0.12 -0.42,0.25 -0.18,0.06 -0.32,-0.1 -0.1,0.08 -0.1,0.52 -0.73,1.07 0.23,0.35 -0.28,0.67 -0.21,0.14 -0.52,0.01 -0.38,0.36 -0.39,0.04 -0.65,1.53 -0.21,0.13 -0.88,0.09 -0.57,1.01 -0.5,0.51 -0.25,0.01 -0.44,-0.39 -0.54,0.19 -0.73,-0.29 -0.12,-0.35 0.28,-0.34 -0.03,-0.17 -0.31,-0.27 -0.41,0.14 -0.17,-0.42 0.35,-0.52 0,0 0.95,0.12 0.75,0.26 0.18,-0.19 -0.62,-5.08 -0.03,-1.21 -0.33,-2.82 0.06,-0.95 -0.08,-0.64 0.17,-2.9 -0.04,-3.17 -0.29,-0.25 -0.62,-0.13 -0.69,0.34 -0.34,0.05 -0.53,-0.06 -0.76,-0.31 -1.14,0.06 -1.18,-0.68 -0.65,-0.05 -0.42,0.26 -0.69,-0.02 0,0 -0.24,-0.09 -0.1,-0.2 0.09,-1.52 -0.13,-1.55 0.62,-1.11 -0.16,-0.81 0.5,-1.13 0.22,-1.49 -0.07,-2.16 -0.49,-4.61 -0.29,-1.48 -0.81,-2.68 -0.6,-0.95 -0.85,-0.74 -0.26,-0.39 -0.48,-2.25 -0.7,-1.52 -1.21,-1.59 -1.25,-0.8 0.07,-0.18 0,0 0.21,-0.89 0.33,-0.59 1.57,-1.67 0.4,-0.63 0.94,-0.87 0.9,-1.47 1.77,-1.27 0.71,-0.88 0.09,-0.23 0.17,-2.9 0,0 0.57,0.26 z",
                        "Kelantan" : "m 99,45.99 2.02,1.37 1.19,0.3 0.19,-0.22 -0.08,-0.37 1.41,-0.41 0.38,0.08 0.37,0.78 0.18,-0.13 0.15,-0.38 2.39,1.14 1.12,0.35 0.91,0.62 1.16,1.67 3.02,6.88 0.72,1.35 0.58,0.82 -0.26,0.25 0.08,0.53 1,0.81 0.37,-0.19 0.99,0.77 0,0 -0.84,1.08 -0.92,0.76 -0.81,1.1 -1.43,1.12 -0.75,0.93 -1.43,1.27 0.04,1.14 0.48,1.68 0.07,1.44 0.39,1.2 -0.14,0.53 -0.47,0.71 -0.04,0.41 0,1.36 0.3,0.66 0.06,1.13 -0.66,0.4 -0.03,0.26 0.17,0.24 1.27,0.83 0.4,0.62 0.41,0.18 0.12,0.18 -0.37,0.68 -0.08,0.75 -0.42,0.77 -0.09,0.42 -0.11,2.36 0.23,1.16 -0.28,1.41 0.75,0.11 2.08,1.03 0.38,0.51 0.8,0.49 0.49,1.01 -0.13,0.37 -0.56,0.19 -0.3,0.5 0.08,0.37 0.49,0.6 0.19,0.91 -0.54,1.2 0.47,1.64 0.01,0.4 -0.17,0.55 0.02,1.2 0.17,0.2 0.29,0.07 0.59,-0.18 0.68,0.04 0.81,0.47 0.47,0.47 0.61,0.06 1.74,1.07 0.1,0.2 -0.07,0.92 0.28,0.43 0.44,1.3 -0.1,0.34 -0.31,0.37 0,0 -0.37,0.01 -1.22,-0.65 -0.38,0.13 -0.32,0.4 -0.06,0.43 0.42,2.24 -0.43,0.16 -0.75,-0.07 -0.26,-0.05 -0.48,-0.38 -0.43,0.02 -0.79,1.07 -0.55,0.48 -0.31,0.05 -0.26,-0.1 -0.66,-0.5 -0.79,-0.91 -0.4,-0.3 -0.53,-0.13 -1.6,-0.06 -1.35,0.28 -0.13,0.27 0.17,0.91 -1.42,1.66 -0.54,0.11 -0.77,-0.31 -0.67,-0.48 -1.71,0 -0.22,0.13 -0.23,0.94 -0.31,0.04 -0.46,-0.11 -0.91,-0.91 -0.66,-0.41 -0.23,-0.85 -0.35,-0.57 -1.22,-0.85 -0.14,-1.04 -0.51,-0.57 -0.29,-0.03 -0.5,0.16 -1.44,0.69 -0.45,0.34 -0.6,-0.44 -0.58,0.29 -0.26,-0.15 -0.35,-0.49 -0.13,-0.47 -0.27,0.15 -0.21,0.58 -0.39,-0.12 -0.35,-0.52 -0.23,-0.12 -0.32,0.24 -0.26,0.41 0.16,1.43 -0.38,1.62 -0.71,0.71 -0.49,1.52 -0.25,0.07 -0.4,-0.31 -0.14,-0.27 0.06,-0.78 -0.19,-0.94 -0.45,-0.34 -1.02,-0.23 -0.16,-0.12 -0.4,-1.26 -0.18,-0.14 -0.41,0.02 -0.32,-0.35 0.19,-0.62 -0.17,-0.39 -0.39,-0.23 -1,0.01 -0.33,0.32 -0.15,0.5 0,0.47 0.23,0.75 -0.27,1.05 0.14,0.88 -0.44,1.4 -0.53,0.53 -0.7,-0.32 -0.22,0.01 -0.39,0.68 -1.02,0.29 -0.67,0.37 -0.41,0.92 -0.46,0.32 -0.42,0.03 -0.64,0.3 -0.94,-0.44 -0.49,0.33 -0.31,-0.16 -0.44,-0.57 -0.73,-0.19 -1.07,-1.27 -0.47,-0.13 -0.97,0.12 -0.35,0.27 -0.53,0.81 -0.42,0.19 -0.92,-0.52 -1.35,-1.07 -0.95,0.19 0,0 -0.57,-0.69 -0.8,-1.42 -0.37,-0.46 -0.19,-0.4 -0.01,-0.54 0.32,-0.48 0.8,0.16 0.73,-0.16 0.11,-0.29 -0.4,-1.5 0.18,-0.2 0.71,-0.25 0.62,-1.61 0.04,-0.19 -0.29,-0.87 0.08,-0.45 0.36,-0.38 1.3,-0.33 -0.4,-0.37 0.09,-0.3 0.41,-0.39 0.16,-0.54 -0.21,-1.14 0.02,-0.85 -0.85,-0.76 -0.04,-0.43 0.89,-0.87 0.05,-0.25 -0.13,-0.31 0.44,-0.56 0.29,-1.42 0.77,-0.76 -0.11,-0.79 0.21,-1.02 -0.09,-0.61 0.17,-0.46 -0.01,-0.55 0.25,-0.56 0.66,-0.81 -0.08,-0.78 0.62,-0.86 -0.19,-0.71 0.05,-0.32 0.16,-0.11 0.56,0.09 0.54,-0.58 0.6,-0.24 0.18,-1.08 0.18,-0.29 0.55,-0.39 0.2,-1.03 0.2,-0.21 0.59,0.18 0.82,0.91 1.8,0.5 0.45,-0.02 0.52,-0.22 0.31,-0.32 0.81,-0.19 0.71,-1.05 0,-0.4 -0.29,-0.48 -0.04,-0.42 0.25,0.31 2.05,1.59 1.59,0.03 1.9,0.25 0.84,-0.04 0.47,-0.35 1.84,-2.01 0.08,-0.3 -0.22,-0.94 0.03,-0.4 0.36,-0.3 0.46,-0.09 0.5,-0.73 0.03,-0.19 -0.25,-0.53 0.35,-1.57 -0.63,-0.24 -0.56,0.03 -0.09,-0.22 0.31,-1.35 -0.03,-0.49 -0.27,-0.41 -0.69,-0.39 0.23,-0.62 0.63,-0.2 0.14,-0.77 0.25,-0.31 -0.04,-0.3 -0.56,-0.7 -0.16,-0.46 0,-0.28 0.38,-0.36 0.1,-0.37 -0.28,-0.16 -0.33,0.26 -0.29,0.02 -0.35,-0.66 -0.54,-0.15 -0.15,-0.51 -1.03,-0.63 -0.17,-0.32 -0.19,-1.03 -0.48,-0.68 0,0 -0.07,-0.38 0.26,-0.63 0.54,-0.25 0.81,0.01 0.97,-0.96 0.04,-0.4 -0.38,-1.11 -0.42,-0.24 -0.04,-0.28 0.32,-0.72 0,-0.55 0.32,0.01 0.23,-0.19 -0.03,-1.1 0.14,-0.24 1.07,-0.77 -0.03,-0.54 0.66,-0.73 1.14,-0.67 1.11,-0.9 0.42,-0.16 0.32,-0.92 0.63,-0.72 0.22,-0.63 0.41,-0.42 -0.58,-1 -0.05,-0.79 0.13,-1.38 0.55,-0.64 z",
                        "Melaka" : "m 94.05,201.37 1.08,-0.47 0.38,-0.6 0.92,-0.73 0.08,-0.37 0.75,0.15 0.4,-0.83 0.56,-0.4 1.43,0.13 0.15,-0.15 1.41,-0.03 0.94,-1.41 0.61,0.17 1.36,0.9 0.93,0.25 1.5,-0.05 2.31,-0.9 0.92,-0.14 1.53,0.36 0.62,0.35 0.49,0.52 0.43,0.18 2.61,0.61 2.49,0.91 1.09,-0.09 0,0 -0.12,0.54 -1.78,0.69 -0.1,0.62 -0.88,0.76 -0.59,3.18 -0.25,0.43 0,1.68 -0.19,0.31 -0.56,0.36 -0.05,0.28 0.13,0.53 1.5,0.53 0.49,0.46 0.08,0.32 -0.05,0.94 -0.64,0.37 0,0 -1.12,0.26 0,0 -0.7,0.17 0,0 -1.25,-0.2 -1.42,-0.77 -1.31,-0.07 -1.1,-0.74 -1.04,-0.22 -0.49,-0.4 -2.43,-0.77 -2.05,-1.26 -0.78,-0.12 -0.48,0.19 -0.36,-0.03 -0.57,-1.05 -0.82,-0.99 -1.13,-0.61 -0.58,-0.5 -0.3,-0.98 -0.51,-0.79 -1.7,-1.02 -0.58,-0.15 -1.02,-0.04 -0.24,-0.27 z",
                        "Negeri-Sembilan" : "m 91.94,166.07 0.05,-0.33 0.17,-0.23 0.53,-0.32 0.29,-0.01 0.29,0.27 0.72,0.08 0.23,0.34 0.27,0.85 0.38,0.34 1.54,0.1 0.49,0.15 0.31,0.52 0.08,0.7 0.32,0.85 0.33,0.31 0.47,-0.08 0.58,-0.7 0.67,-0.07 0.38,-0.41 0.31,0.06 0.55,-0.1 0.83,0.88 0.23,0.11 4.81,1.42 4.15,0.93 0.19,0.11 2.53,3.2 0.31,0.59 0.36,0.14 7.31,4.92 0.98,0.17 0.24,0.17 0.62,2.14 0,0 -2.82,7.87 0.1,0.49 0.42,0.73 -0.1,0.29 -0.69,0.35 -0.05,0.42 -0.36,0.59 -0.04,0.92 0.23,0.96 -0.33,0.74 0.23,0.9 -0.09,0.36 -0.67,0.48 -0.2,0.31 -0.06,1.07 0,0 -1.09,0.09 -2.49,-0.91 -2.61,-0.61 -0.43,-0.18 -0.49,-0.52 -0.62,-0.35 -1.53,-0.36 -0.92,0.14 -2.31,0.9 -1.5,0.05 -0.93,-0.25 -1.36,-0.9 -0.61,-0.17 -0.94,1.41 -1.41,0.03 -0.15,0.15 -1.43,-0.13 -0.56,0.4 -0.4,0.83 -0.75,-0.15 -0.08,0.37 -0.92,0.73 -0.38,0.6 -1.08,0.47 0,0 -0.11,-0.32 0.13,-0.23 -0.16,-0.42 -0.63,-0.12 -0.32,-0.23 -0.22,-0.42 -0.37,-0.18 -0.38,-0.01 -0.96,0.33 -0.58,-0.12 -0.64,0.04 -0.29,0.16 -0.04,0.42 -0.18,0.02 -0.24,-0.32 0.32,-0.34 0.08,-0.64 -0.56,-2.08 -1.01,-1.31 -0.37,-0.09 -0.28,0.11 -0.5,-0.06 -0.04,-0.38 0.39,-0.45 -0.17,-1.29 -0.62,-0.64 -0.98,-0.49 -0.48,0.01 -0.56,0.35 -0.58,-0.06 -0.1,-0.16 0,0 0.05,-0.29 0.86,-0.28 -0.06,-0.89 0.61,-0.58 -0.16,-0.54 0.39,-0.48 0.16,-0.47 0.15,-1.26 -0.52,-6.1 4.91,0.17 0.67,-0.81 1.44,-3.31 0.67,-1.1 0.1,-0.6 1.11,-0.68 0.03,-0.66 -0.92,-2 0.08,-0.51 0.46,-0.82 0.02,-0.42 -0.48,-0.98 -0.17,-0.85 0.01,-0.99 -0.48,-0.8 -0.1,-0.85 -0.48,-0.2 z",
                        "Pahang" : "m 70.4,111.69 0.95,-0.19 1.35,1.07 0.92,0.52 0.42,-0.19 0.53,-0.81 0.35,-0.27 0.97,-0.12 0.47,0.13 1.07,1.27 0.73,0.19 0.44,0.57 0.31,0.16 0.49,-0.33 0.94,0.44 0.64,-0.3 0.42,-0.03 0.46,-0.32 0.41,-0.92 0.67,-0.37 1.02,-0.29 0.39,-0.68 0.22,-0.01 0.7,0.32 0.53,-0.53 0.44,-1.4 -0.14,-0.88 0.27,-1.05 -0.23,-0.75 0,-0.47 0.15,-0.5 0.33,-0.32 1,-0.01 0.39,0.23 0.17,0.39 -0.19,0.62 0.32,0.35 0.41,-0.02 0.18,0.14 0.4,1.26 0.16,0.12 1.02,0.23 0.45,0.34 0.19,0.94 -0.07,0.78 0.14,0.31 0.4,0.31 0.25,-0.07 0.49,-1.52 0.71,-0.71 0.38,-1.62 -0.16,-1.43 0.26,-0.41 0.32,-0.24 0.23,0.12 0.35,0.52 0.39,0.12 0.21,-0.58 0.27,-0.15 0.13,0.47 0.35,0.49 0.26,0.15 0.58,-0.29 0.6,0.44 0.45,-0.34 1.44,-0.69 0.5,-0.16 0.29,0.03 0.51,0.57 0.14,1.04 1.22,0.85 0.35,0.57 0.23,0.85 0.66,0.37 0.89,0.89 0.46,0.11 0.31,-0.04 0.23,-0.94 0.22,-0.13 1.71,0 0.67,0.48 0.77,0.31 0.54,-0.11 1.42,-1.66 -0.17,-0.91 0.13,-0.27 1.35,-0.28 1.6,0.06 0.53,0.13 0.4,0.3 0.79,0.91 0.66,0.5 0.26,0.1 0.31,-0.05 0.55,-0.48 0.79,-1.07 0.43,-0.02 0.48,0.38 0.26,0.05 0.75,0.07 0.43,-0.16 -0.42,-2.24 0.06,-0.43 0.32,-0.4 0.38,-0.13 1.22,0.65 0.37,-0.01 0,0 1.25,1.75 0.75,0.34 0.78,0.83 2.26,0.54 1.23,-0.16 1.34,0.17 -0.01,0.25 0.77,0.66 0.25,0.86 0.63,0.82 -0.98,0.42 0,0.16 0.4,0.41 -0.24,0.68 -0.92,0.24 0.07,1.27 0.44,1.3 0.5,0.34 0.38,0.62 0.47,0.27 1.6,0 1.07,-0.48 0.73,0.14 0.86,0.78 0.49,0.72 0.52,1.12 0.14,0.59 -0.59,0.72 -0.21,0.54 0.09,0.58 0.29,0.42 0.03,0.22 -0.32,0.2 -0.7,-0.15 -0.67,0.21 -0.27,0.48 -0.19,0.85 -1.02,0.97 -0.06,0.44 0.13,0.73 -0.6,0.89 -0.11,0.38 0.27,1.3 0,0.45 -0.1,0.26 -0.73,0.72 -0.14,0.35 0.11,0.35 0.57,0.64 0.92,0.51 1.18,-0.67 1.08,-0.42 1.01,0.42 0.77,-0.07 1.02,0.14 0.69,0.71 1.11,0.24 1.04,1.29 1.02,0.58 0.39,0.49 0.52,0.03 0.78,-0.29 0.16,0.03 0.2,0.58 0.28,0.29 0.26,0.04 0.71,-0.19 0.23,0.11 0.09,0.78 1.34,1.21 -0.25,0.39 0.04,0.37 1.03,1.46 0.26,0.69 0.19,0.03 0.43,-0.21 -0.36,-0.65 0,-0.25 0.85,-0.75 0.13,-0.69 0,-0.37 -0.46,-1.44 -0.01,-1.88 -0.25,-0.37 -0.54,-0.36 -0.2,-0.42 0.19,-1.36 0.56,-0.71 0.21,-0.72 -0.35,-2.06 0.16,-0.07 0.52,0.54 0.42,0.24 0.75,0.14 3.1,-0.4 0,0 0,0.18 -0.35,0.22 -0.46,-0.12 -0.35,0.16 -0.23,0.42 -0.05,1.07 -0.91,0.73 -0.08,0.48 0.09,0.84 0.45,1.82 1.05,2.23 0.65,0.85 -0.28,0.28 -1,-0.49 -0.29,0.09 -0.54,0.57 -0.82,1.41 -0.09,1.43 0.51,2.48 -0.23,0.21 0.08,0.42 -0.1,0.17 -0.58,-0.34 -0.64,0.1 -0.54,1.47 -0.11,1.26 0.54,1.61 1.23,2.12 2.7,3.44 0.74,0.75 0.55,0.36 0.32,1.12 0.03,0.31 -0.18,0.32 -0.71,0.61 -0.45,0.71 -0.59,1.9 -0.25,2.02 0.1,1.43 0.56,2.52 0.29,2.07 -0.15,1.65 0.21,1.65 -0.06,0.9 -0.27,0.29 -0.15,0.93 -0.14,2.17 0.07,1.26 -0.26,1.25 0.22,1.49 0.35,1.25 0.56,1.17 2.91,3.71 3.72,3.38 0.36,0.6 0,0 -0.08,0.36 -0.29,0.01 -0.66,-0.22 -0.41,0.11 -0.23,0.29 0.06,0.65 0.22,0.31 0.43,0.03 0.2,-0.66 0.03,0.56 0.25,0.23 -0.13,0.13 0,0.3 0.21,0.41 -0.23,0.15 -0.1,0.37 0.29,0.26 -0.57,0.09 -0.28,0.31 0.06,0.37 0.15,0.05 0.39,-0.26 0.11,0.44 -0.25,-0.04 -0.65,0.27 -0.14,0.95 0.27,0.22 0.76,-0.2 0.15,0.1 -0.02,0.59 0.34,0.53 0,0.53 0.3,0.29 -0.48,0.75 -0.23,0.03 -0.3,-0.25 -0.35,0.27 -0.59,-0.12 -4.38,-2.21 -1,-1.22 -1.4,-0.23 -2.44,-1.35 -0.7,0.03 -2.45,0.57 -5.14,2.11 -0.3,0 -7.16,-3.11 -7.03,-8.23 -3.74,-1.1 0,0 -0.62,-2.14 -0.24,-0.17 -0.98,-0.17 -7.31,-4.92 -0.36,-0.14 -0.31,-0.59 -2.53,-3.2 -0.19,-0.11 -4.15,-0.93 -4.81,-1.42 -0.23,-0.11 -0.83,-0.88 -0.55,0.1 -0.31,-0.06 -0.38,0.41 -0.67,0.07 -0.58,0.7 -0.47,0.08 -0.33,-0.31 -0.32,-0.85 -0.08,-0.7 -0.31,-0.52 -0.49,-0.15 -1.54,-0.1 -0.38,-0.34 -0.27,-0.85 -0.23,-0.34 -0.72,-0.08 -0.29,-0.27 -0.29,0.01 -0.53,0.32 -0.17,0.23 -0.05,0.33 0,0 -0.83,-0.43 -1.15,0.03 -2.07,-1.16 -1.5,-2.16 -0.13,-0.37 -0.7,-0.47 0.31,-1.05 0.7,-0.56 0.17,-0.45 -0.36,-1.51 -0.81,-1.57 0.95,-1.7 0.82,-0.31 0.18,-0.18 -0.03,-0.88 0.27,-0.61 -0.03,-0.53 -0.12,-0.28 -0.74,-0.62 -0.19,-0.32 -0.19,-0.96 -0.44,-0.7 -1.14,-1.16 -0.53,-0.27 -1.07,0.09 -0.77,-0.14 -1.13,-0.69 -1.29,-1.67 0,0 -0.37,-0.76 -1.04,-0.43 0.1,-1.34 0.42,-0.52 0,-0.33 -0.29,-1.1 -0.8,-0.69 -0.04,-1.2 -0.13,-0.42 0.15,-0.61 -0.05,-1.48 -0.11,-0.3 -0.53,-0.46 -0.15,-0.34 0.18,-0.73 0.85,-1.2 -0.02,-0.57 -0.48,-0.63 -1.5,-1.04 -0.71,0.03 -0.26,-0.19 -0.44,-1.55 0.43,-1.39 0,-0.31 -1.56,-0.17 -0.3,-0.14 -0.21,-0.3 -0.15,-0.68 0.42,-0.51 -0.64,-0.86 -0.06,-0.27 0.19,-0.6 -0.02,-0.92 -0.09,-0.24 -0.61,-0.42 -0.15,-0.29 0.56,-1.33 -0.11,-0.29 -0.42,-0.29 -0.82,-0.15 -0.55,-0.39 -1.38,0.3 -0.2,-0.17 -0.08,-0.63 -0.17,-0.36 -0.36,-0.2 -0.28,-0.02 -0.08,-0.22 0.15,-0.48 0.56,-0.34 0.28,-0.45 0.29,-1.08 0.59,-0.23 0.25,-0.37 -0.05,-0.38 -0.75,-0.34 -0.25,-0.33 -0.23,-1.92 0.08,-0.44 0.33,-0.38 0.39,-0.28 0.56,-0.01 z",
                        "Pulau-Penang" : "m 25.58,76.74 0.42,0.44 0.29,-0.08 0.65,0.18 0.15,0.41 0,0.67 0.69,0.51 0.67,0.11 -0.06,0.37 -1.12,1.21 -0.07,1.27 -1.29,3.29 0.04,0.38 -0.13,0.13 -0.24,-0.02 -0.31,-0.61 -0.3,-0.23 -0.42,-0.02 -0.86,-0.31 -0.46,0.19 -1.08,0.06 -0.17,0.25 -0.01,0.35 -0.3,-0.55 0.24,-0.63 -0.07,-0.39 0.29,-0.18 0.28,-0.01 -0.1,-0.6 0.06,-0.67 -0.38,-1.15 -0.09,-0.87 0,-1.54 -0.13,-0.48 0.15,-0.51 -0.09,-0.41 -0.25,-0.21 0,-0.13 0.18,-0.16 0.3,0.26 0.97,0.45 1.07,-0.22 0.71,-0.71 0.77,0.16 z m 2.94,-4.04 0.69,0.02 0.42,-0.26 0.65,0.05 1.18,0.68 1.14,-0.06 0.76,0.31 0.53,0.06 0.34,-0.05 0.69,-0.34 0.62,0.13 0.29,0.25 0.04,3.17 -0.17,2.9 0.08,0.64 -0.06,0.95 0.33,2.82 0.03,1.21 0.62,5.08 -0.18,0.19 -0.75,-0.26 -0.95,-0.12 0,0 -0.3,0.01 -0.38,0.33 -0.37,0.07 -3.04,0.3 -0.53,-0.08 0,0 0.09,-0.23 0.63,-0.49 0.64,-0.77 -0.01,-0.2 -0.2,-0.13 0.27,-1.85 -0.6,-1.9 0.31,-0.31 0,-0.33 -0.26,-1.07 -0.34,-0.31 0.11,-0.67 -1.64,-1.99 -0.1,-0.5 0.49,-0.99 0.25,-1.61 -0.39,-2.44 -0.39,-1.04 -0.27,-0.41 -0.65,-0.51 0.02,-0.13 0.36,-0.12 z",
                        "Perak" : "m 39.33,110.09 1.92,1.69 -0.15,0.4 -0.21,0.01 -0.22,0.21 0.18,0.99 -0.52,0.08 -0.62,0.34 -0.39,0.07 -0.96,-0.4 -0.29,0 -0.1,-0.12 0.21,-0.86 -0.07,-0.54 0.2,-0.61 0.49,-0.84 0.53,-0.42 z m 0.17,-4.38 1.56,0.71 0.29,0.7 -1,1.89 -0.11,0.07 -0.55,-0.16 -0.48,0.08 -0.68,0.31 -0.64,-1.89 -0.15,-1.03 0.04,-0.44 0.31,-0.56 0.56,0.2 0.85,0.12 z m 38.84,-47.34 1.67,1.41 0.5,0.79 1.07,0.3 0.09,0.31 -0.03,1.98 0.32,0.59 0.85,0.78 0.37,0.86 0.25,0.03 0.22,-0.22 0.14,-0.62 0.3,-0.21 0.46,-0.11 0.48,-0.34 0.4,-0.09 0.32,0.15 0.69,1.26 0.74,0.71 0.53,0.37 0.34,-0.04 -0.04,-1.05 0.34,-0.94 0.68,-0.11 0.79,-0.69 0.49,-0.19 0,0 0.48,0.68 0.19,1.02 0.19,0.31 1.03,0.63 0.15,0.51 0.54,0.15 0.35,0.66 0.29,-0.02 0.33,-0.26 0.28,0.16 -0.1,0.37 -0.38,0.36 0,0.28 0.16,0.46 0.56,0.7 0.04,0.3 -0.25,0.31 -0.14,0.77 -0.63,0.2 -0.23,0.62 0.69,0.39 0.27,0.41 0.03,0.49 -0.31,1.35 0.09,0.22 0.56,-0.03 0.63,0.24 -0.35,1.57 0.25,0.53 -0.03,0.19 -0.5,0.73 -0.46,0.09 -0.38,0.31 -0.02,0.38 0.22,0.94 -0.08,0.3 -1.84,2.01 -0.47,0.35 -0.84,0.04 -1.9,-0.25 -1.59,-0.03 -2.05,-1.59 -0.25,-0.31 0.04,0.42 0.29,0.48 0,0.4 -0.71,1.05 -0.81,0.19 -0.31,0.32 -0.52,0.22 -0.45,0.02 -1.8,-0.5 -0.82,-0.91 -0.59,-0.18 -0.2,0.21 -0.2,1.03 -0.55,0.39 -0.18,0.29 -0.18,1.08 -0.6,0.24 -0.54,0.58 -0.56,-0.09 -0.16,0.11 -0.05,0.32 0.19,0.71 -0.63,0.88 0.12,0.75 -0.66,0.81 -0.25,0.56 0.01,0.55 -0.17,0.46 0.09,0.61 -0.21,1.02 0.11,0.79 -0.77,0.76 -0.29,1.42 -0.44,0.56 0.13,0.31 -0.05,0.25 -0.89,0.87 0.04,0.43 0.85,0.76 -0.02,0.85 0.21,1.14 -0.16,0.54 -0.41,0.39 -0.09,0.3 0.4,0.37 -1.3,0.33 -0.36,0.38 -0.08,0.45 0.29,0.87 -0.04,0.19 -0.62,1.61 -0.71,0.25 -0.18,0.2 0.4,1.5 -0.11,0.29 -0.73,0.16 -0.8,-0.16 -0.32,0.48 0.01,0.54 0.19,0.4 0.37,0.46 0.8,1.42 0.57,0.69 0,0 -0.54,0.02 -0.39,0.28 -0.33,0.38 -0.08,0.44 0.23,1.92 0.25,0.33 0.75,0.34 0.05,0.38 -0.25,0.37 -0.59,0.23 -0.29,1.08 -0.28,0.45 -0.56,0.34 -0.15,0.48 0.08,0.22 0.28,0.02 0.36,0.2 0.17,0.36 0.08,0.63 0.2,0.17 1.38,-0.3 0.55,0.39 0.82,0.15 0.42,0.29 0.11,0.29 -0.56,1.33 0.15,0.29 0.61,0.42 0.09,0.24 0.02,0.92 -0.19,0.6 0.06,0.27 0.64,0.86 -0.42,0.51 0.15,0.68 0.21,0.3 0.3,0.14 1.56,0.17 0,0.31 -0.43,1.39 0.44,1.55 0.26,0.19 0.71,-0.03 1.5,1.04 0.48,0.63 0.02,0.57 -0.85,1.2 -0.18,0.73 0.15,0.34 0.53,0.46 0.11,0.3 0.05,1.48 -0.15,0.61 0.13,0.42 0.04,1.2 0.8,0.69 0.29,1.1 0,0.33 -0.42,0.52 -0.1,1.34 1.04,0.43 0.37,0.76 0,0 -0.99,-0.05 -0.13,0.26 0.25,0.33 -0.08,0.44 -0.28,0.38 -0.29,-0.14 -0.26,0.23 -0.29,0.56 0.15,0.41 -0.16,0.37 -0.4,0.25 -0.46,0.1 -0.44,0.77 -0.55,0.12 -0.53,-0.18 -1.38,-1.29 -1.21,-0.49 -0.24,-0.76 -0.19,-0.17 -0.74,-0.3 -1.07,-0.71 -0.33,0.07 -0.14,-0.83 -0.42,-0.36 -0.64,-0.1 -0.42,0.25 -0.38,0.04 -0.07,0.28 -0.38,0.48 0.81,2.18 -0.03,0.96 -0.33,0.25 -0.79,0.21 -0.36,0.4 -0.56,-0.03 -0.74,0.3 -0.84,-0.11 -0.34,-0.16 -0.03,-1.17 0.11,-0.6 -0.17,-0.04 -1.18,0.44 -0.49,-0.36 -0.29,-0.05 -0.88,0.24 -0.54,-0.63 -0.21,-0.61 -0.1,0.04 -0.1,0.42 -0.36,-0.04 -0.25,-0.18 0.27,-0.48 -0.34,-0.46 -0.5,0.77 -0.4,-0.09 -0.21,0.43 -0.13,0.02 -0.44,-0.41 -0.63,0.61 -0.17,-0.13 0,-0.14 0.2,-1.06 0.22,-0.05 0.51,0.21 0.18,-0.05 -0.41,-0.39 0,-0.48 -0.09,-0.09 -0.9,1 -0.27,-0.02 -0.16,-0.94 0.05,-0.51 -1.1,0.4 -0.1,-0.21 0.06,-0.4 -0.13,-0.11 -0.21,-0.09 -0.83,0.08 -0.38,0.23 -0.13,0.62 -0.21,0.3 -0.57,-0.06 -0.21,-0.19 -0.14,-0.55 0.13,-0.37 0.4,-0.36 0.06,-0.31 -0.22,-0.24 -0.96,-0.27 -0.24,-0.19 0.04,-1.11 -0.15,-0.16 -1.35,0.46 -3.01,0.3 -0.26,0.25 -0.22,1.11 -0.27,0.38 0,0 0.37,-1.61 0.03,-0.55 -0.66,-0.09 -0.6,0.17 -0.51,0.35 -0.88,-0.19 -1.59,-1.05 -0.38,-1.28 -0.18,-1.83 0.15,-1.47 0.17,-0.36 0.23,-0.17 0.55,-0.02 1.32,-0.5 0.28,-1.1 -0.22,-1.62 -0.53,-0.76 -0.59,-0.38 -1.11,-1.43 -0.48,-0.39 -1.28,-0.46 -1.05,0 -0.43,0.56 -0.43,-0.32 -0.15,-0.6 -0.38,-0.42 0.01,-0.31 0.28,-0.21 -0.01,-0.42 -0.56,-0.47 -0.19,-0.69 0.62,0.1 0.71,0.31 0.65,-0.19 0.39,-0.26 0.36,-0.36 0.29,-0.52 -0.11,-0.55 0.3,-0.86 -0.06,-0.67 -0.38,-0.15 0.09,0.36 -0.3,1.13 -0.04,0.88 -0.66,0.59 -1.23,-0.17 -0.63,-0.2 -0.18,-1.41 -0.44,-0.73 -0.11,-0.09 -0.6,0.1 0.05,-0.45 0.31,-0.45 0.73,-1.71 0.09,-1.52 -0.2,-0.18 0.37,-0.56 0.18,0.31 0.41,-0.08 0.25,-0.55 0.25,-1.28 -0.03,-1.61 0.16,-0.61 1.03,-0.79 0.48,-1.06 -0.21,-0.81 0.35,-0.25 0.06,-0.4 -1.67,-1.63 1.45,-1.4 0.55,-1.82 -0.3,-0.64 -0.87,-0.59 -1.15,-0.35 -0.14,-0.16 0.08,-0.49 0.37,-0.2 0.23,-0.39 -0.19,-0.61 0.24,-0.77 -0.2,-0.26 -0.86,-0.25 -0.66,0.03 -0.45,-0.73 -0.22,-0.03 -0.45,0.19 -0.43,-0.23 -0.07,-0.51 0.21,-0.13 0.03,-0.23 -0.65,-0.35 0.09,-0.23 0.11,-0.1 0.19,0.04 0.48,0.49 0.2,0.03 0.36,-0.2 0.21,-0.2 -0.1,-0.64 0.17,-0.18 -0.13,-0.23 -0.32,-0.12 -0.61,0.37 -0.33,-0.55 -0.38,0 -0.24,0.22 0.22,0.54 -0.18,0.03 -0.26,-0.21 -0.16,0.11 -0.02,0.16 0.25,0.38 -0.18,0.15 L 35.23,99.6 34.95,99.37 33.51,98.9 32.56,99.4 32.36,99.39 31.84,98.75 31.5,98.01 31.4,96.32 31.31,96.2 30.88,96.39 30.72,96.22 30.34,95.39 30.15,94.54 29.9,94.19 29.83,93.8 29.48,93.05 29,92.45 l 0.01,-0.26 0.2,-0.35 0.74,-0.45 0.22,-0.71 0,0 0.53,0.08 3.04,-0.3 0.37,-0.07 0.38,-0.33 0.3,-0.01 0,0 -0.35,0.52 0.19,0.43 0.42,-0.15 0.31,0.27 0.03,0.17 -0.28,0.34 0.12,0.35 0.73,0.29 0.54,-0.19 0.44,0.39 0.25,-0.01 0.5,-0.51 0.57,-1.01 0.88,-0.09 0.21,-0.13 0.65,-1.53 0.39,-0.04 0.38,-0.36 0.52,-0.01 0.21,-0.14 0.28,-0.67 -0.23,-0.35 0.73,-1.07 0.1,-0.52 0.1,-0.08 0.32,0.1 0.17,-0.05 0.4,-0.26 0.49,-0.12 0.37,-0.37 -0.02,-0.98 0.27,-0.38 0.08,-0.4 1.1,-0.25 0.53,0.12 0.67,-0.22 0.48,0.05 0.93,-0.95 0.5,-0.26 0.42,-1.85 -0.11,-0.66 0.49,-0.82 0.04,-1.18 0.27,-0.82 0.23,-0.41 0.31,-0.22 0.69,0.17 0.6,-0.28 0.93,-1.97 0,-0.27 -0.19,-0.34 -0.05,-0.93 -0.45,-0.53 -0.03,-0.54 0.07,-0.2 0.58,-0.45 0.24,-0.88 0.4,0.08 0.41,-0.14 0.13,-0.51 -0.02,-0.74 0.39,-1.1 -0.04,-0.3 -0.19,-0.26 -0.53,-0.31 -0.45,-0.54 -0.06,-1.05 0.11,-0.21 0.14,-0.03 0.82,0.2 0.33,-0.03 0.21,-0.56 -0.04,-0.18 0,0 1.05,0.73 0.57,1.02 0.19,0.09 0.9,-0.07 0.29,0.25 1.8,2.41 0.57,1.02 0.36,0.77 0.09,0.84 0.94,-0.64 0.66,-0.75 0.87,-0.19 0.41,-0.28 1.03,-1.21 1.04,-0.92 0.11,-0.7 -0.4,-1.19 0.54,-1.42 0.73,-0.83 0.29,-0.16 0.2,0.05 0.9,0.5 1.19,-0.47 0.96,-0.64 1.01,-1.56 0.68,-0.15 2.42,0.16 0.56,-0.15 2.24,-1.63 1.03,-0.19 0.69,-0.44 z",
                        "Perlis" : "m 22.8,26.53 0.39,0.13 0.81,1.06 0.72,-0.17 0,-0.34 0.18,-0.16 0.15,0.2 -0.01,0.47 0.46,0.1 -0.01,-0.22 0.24,-0.44 0.69,-0.03 0.02,0.88 0.31,0.48 0.86,0.48 -0.09,0.84 0.13,0.96 -0.48,0.35 -0.02,0.24 1.63,1.35 0.22,0.97 0.49,0.38 0,0 -0.17,2.9 -0.1,0.22 -0.71,0.89 -1.76,1.26 -0.9,1.47 -0.95,0.87 -0.4,0.63 -1.57,1.67 -0.34,0.59 -0.21,0.89 0,0 -0.39,-0.32 -0.62,-1.16 -1.37,-3.81 -0.37,-0.44 -0.11,-0.34 0.08,-0.58 0.86,-1.37 -0.11,-0.23 0.01,-0.39 0.58,-0.76 -0.24,-2.66 0.12,-0.95 0.06,-0.07 0.19,0.19 0.68,0.1 0.18,-0.22 -0.62,-1.45 -0.11,-0.71 0.3,-0.72 0.3,-0.24 -0.11,-0.55 0.07,-0.47 -0.26,-0.17 -0.07,-0.4 0.34,-0.2 0.3,-0.7 z",
                        "Selangor" : "m 47.14,144.08 0.27,-0.38 0.22,-1.11 0.26,-0.25 3.01,-0.3 1.35,-0.46 0.15,0.16 -0.04,1.11 0.24,0.19 0.96,0.27 0.22,0.24 -0.06,0.31 -0.4,0.36 -0.13,0.37 0.14,0.55 0.21,0.19 0.57,0.06 0.21,-0.3 0.13,-0.62 0.38,-0.23 0.83,-0.08 0.21,0.09 0.13,0.11 -0.06,0.4 0.1,0.21 1.1,-0.4 -0.05,0.51 0.16,0.94 0.27,0.02 0.9,-1 0.09,0.09 0,0.48 0.41,0.39 -0.18,0.05 -0.51,-0.21 -0.22,0.05 -0.2,1.06 0,0.14 0.17,0.13 0.63,-0.61 0.44,0.41 0.13,-0.02 0.21,-0.43 0.4,0.09 0.5,-0.77 0.34,0.46 -0.27,0.48 0.25,0.18 0.36,0.04 0.1,-0.42 0.1,-0.04 0.21,0.61 0.54,0.63 0.88,-0.24 0.29,0.05 0.49,0.36 1.15,-0.45 0.17,0.04 -0.11,0.6 0.03,1.17 0.34,0.16 0.84,0.11 0.74,-0.3 0.56,0.03 0.36,-0.4 0.79,-0.21 0.33,-0.25 0.03,-0.96 -0.81,-2.18 0.38,-0.48 0.07,-0.28 0.38,-0.04 0.42,-0.25 0.64,0.1 0.42,0.36 0.14,0.83 0.33,-0.07 1.07,0.71 0.74,0.3 0.19,0.17 0.24,0.76 1.21,0.49 1.38,1.29 0.53,0.18 0.55,-0.12 0.44,-0.77 0.46,-0.1 0.4,-0.25 0.16,-0.37 -0.15,-0.41 0.29,-0.56 0.26,-0.23 0.29,0.14 0.28,-0.38 0.08,-0.44 -0.25,-0.33 0.13,-0.26 0.99,0.05 0,0 1.29,1.67 1.13,0.69 0.77,0.14 1.07,-0.09 0.53,0.27 1.14,1.16 0.44,0.7 0.19,0.96 0.19,0.32 0.74,0.62 0.12,0.28 0.03,0.53 -0.27,0.61 0.03,0.88 -0.18,0.18 -0.82,0.31 -0.95,1.7 0.81,1.57 0.36,1.51 -0.17,0.45 -0.7,0.56 -0.31,1.05 0.7,0.47 0.13,0.37 1.5,2.16 2.07,1.16 1.15,-0.03 0.83,0.43 0,0 0.48,0.28 0.1,0.85 0.48,0.8 -0.01,0.99 0.17,0.85 0.48,0.98 -0.02,0.42 -0.46,0.82 -0.08,0.51 0.92,2 -0.03,0.66 -1.11,0.68 -0.1,0.6 -0.67,1.1 -1.44,3.31 -0.67,0.81 -4.91,-0.17 0.52,6.1 -0.15,1.26 -0.16,0.47 -0.39,0.48 0.16,0.54 -0.61,0.58 0.06,0.89 -0.86,0.28 -0.05,0.29 0,0 -0.01,0.13 -0.67,0.06 -0.28,-0.23 -0.2,-0.38 -0.51,-0.29 -1.72,-0.54 -0.76,-0.09 -1.26,-0.8 -1.57,-0.37 -1.68,-0.84 -0.59,-0.18 -0.85,-0.84 -1.35,-2.59 -0.71,-0.56 -0.24,-0.37 0.41,-0.46 0.07,-0.7 -0.19,-0.35 0.14,-0.47 0.34,-0.12 0.06,-0.61 0.79,-0.09 0.05,-0.51 0.32,-0.33 -0.1,-0.37 -0.61,-0.15 -0.31,-0.32 -0.19,0.15 0.27,0.39 -0.19,0.28 0,0.47 -0.18,-0.03 -0.03,-0.34 -0.33,-0.3 0.38,-0.72 0.3,-0.03 0.11,-0.17 -0.3,-0.6 -0.66,-0.04 -0.08,-0.22 0.45,-0.24 0.28,-0.37 0.54,-0.23 0.07,-0.29 -0.63,-0.5 -0.44,0.02 -0.21,0.21 -0.18,0.7 -0.67,0.65 -0.08,0.84 -0.17,0.38 -0.33,0.11 -0.53,-0.52 -0.02,-0.37 0.22,-0.43 0.19,-0.82 0.48,-0.55 0.42,-0.28 0.17,-0.33 -0.22,-0.54 -0.98,0.05 -0.34,-0.52 0.19,-1.94 -0.19,-0.53 -0.72,-0.88 -0.8,-0.68 -0.27,-0.55 -0.32,-3.45 -0.4,-1.7 -0.44,-0.75 -0.76,-0.98 -0.92,-0.73 -1.46,-0.95 -0.67,-0.28 -0.46,-1.22 -1.32,-2.02 -0.84,-0.83 -1.07,-1.64 -0.58,-1.63 -0.94,-2.15 -0.96,-1.37 -0.72,-0.75 -1.22,-0.97 -2.03,-0.61 -0.87,-2 -0.82,-0.94 -1.49,-0.97 -0.56,-0.15 -0.98,-0.02 -0.29,-0.3 -0.18,-0.78 z",
                        "Terengganu" : "m 117.81,62.54 1.54,0.88 1.29,1.08 0.87,1.29 1.45,1.73 1.53,1.38 1.3,0.68 1.6,1.22 1.97,1.95 1.87,1.17 1.01,0.47 0.65,0.16 0.57,-0.28 1.03,0.62 0.62,0.54 4.75,4.66 1.7,2.47 1.49,2.62 -0.12,0.58 0.5,0.98 1.28,1.96 2.26,4.67 2.68,4.91 3.03,5.18 0.59,1.4 -0.65,0.28 -0.07,0.28 1.12,3.2 -0.42,1.83 0.69,2.06 0.46,1.02 0.36,1.52 -0.39,0.48 -0.77,0.61 -0.15,1.19 0.48,1.43 -0.04,1.51 0.45,1.07 1.07,1.85 -0.85,2.74 -0.46,0.69 -0.74,0.33 -0.12,0.61 0.24,1.25 0,0 -3.1,0.4 -0.75,-0.14 -0.42,-0.24 -0.52,-0.54 -0.16,0.07 0.35,2.06 -0.21,0.72 -0.56,0.71 -0.19,1.36 0.2,0.42 0.54,0.36 0.25,0.37 0.01,1.88 0.46,1.44 0,0.37 -0.13,0.69 -0.85,0.75 0,0.25 0.36,0.65 -0.43,0.21 -0.19,-0.03 -0.26,-0.69 -1.03,-1.46 -0.04,-0.37 0.25,-0.39 -1.34,-1.21 -0.09,-0.78 -0.23,-0.11 -0.71,0.19 -0.26,-0.04 -0.28,-0.29 -0.2,-0.58 -0.16,-0.03 -0.78,0.29 -0.52,-0.03 -0.39,-0.49 -1.02,-0.58 -1.04,-1.29 -1.11,-0.24 -0.69,-0.71 -1.02,-0.14 -0.77,0.07 -1.01,-0.42 -1.08,0.42 -1.18,0.67 -0.92,-0.51 -0.57,-0.64 -0.11,-0.35 0.14,-0.35 0.73,-0.72 0.1,-0.26 0,-0.45 -0.27,-1.3 0.11,-0.38 0.6,-0.89 -0.13,-0.73 0.06,-0.44 1.02,-0.97 0.19,-0.85 0.27,-0.48 0.67,-0.21 0.7,0.15 0.32,-0.2 -0.03,-0.22 -0.29,-0.42 -0.09,-0.58 0.21,-0.54 0.59,-0.72 -0.14,-0.59 -0.52,-1.12 -0.49,-0.72 -0.86,-0.78 -0.73,-0.14 -1.07,0.48 -1.6,0 -0.47,-0.27 -0.38,-0.62 -0.5,-0.34 -0.44,-1.3 -0.07,-1.27 0.92,-0.24 0.24,-0.68 -0.4,-0.41 0,-0.16 0.98,-0.42 -0.63,-0.82 -0.25,-0.86 -0.77,-0.66 0.01,-0.25 -1.34,-0.17 -1.23,0.16 -2.26,-0.54 -0.78,-0.83 -0.75,-0.34 -1.25,-1.75 0,0 0.31,-0.37 0.1,-0.34 -0.44,-1.3 -0.28,-0.43 0.07,-0.92 -0.1,-0.2 -1.74,-1.07 -0.61,-0.06 -0.47,-0.47 -0.81,-0.47 -0.68,-0.04 -0.59,0.18 -0.29,-0.07 -0.17,-0.2 -0.02,-1.2 0.17,-0.55 -0.01,-0.4 -0.47,-1.64 0.54,-1.2 -0.19,-0.91 -0.49,-0.6 -0.06,-0.4 0.29,-0.52 0.56,-0.19 0.13,-0.37 -0.49,-1.01 -0.8,-0.49 -0.38,-0.51 -2.08,-1.03 -0.75,-0.11 0.28,-1.41 -0.23,-1.16 0.11,-2.36 0.09,-0.42 0.42,-0.77 0.08,-0.75 0.37,-0.68 -0.12,-0.18 -0.41,-0.18 -0.4,-0.62 -1.27,-0.83 -0.17,-0.24 0.03,-0.26 0.66,-0.4 -0.06,-1.13 -0.3,-0.66 0,-1.36 0.04,-0.41 0.47,-0.71 0.14,-0.53 -0.39,-1.2 -0.07,-1.44 -0.48,-1.68 -0.04,-1.14 1.43,-1.27 0.75,-0.93 1.43,-1.12 0.81,-1.1 0.92,-0.76 0.84,-1.08 0,0 0.93,0.55 z",
                        "Sabah" : "m 713.55,29.16 0.02,-0.31 0.21,-0.28 0.31,-0.18 1.35,-0.14 1.4,0.3 0.58,-0.3 0.57,-0.5 -0.49,-0.5 -1.17,-0.29 -0.32,-0.83 0.16,-0.34 1.09,-0.51 0.34,0.18 0.83,0.13 1.03,-0.46 0.16,0.23 -0.04,0.29 0.77,1.47 0.65,0.77 0.02,0.79 -0.38,0.56 -0.84,0.55 -1.13,0.17 -0.9,0.63 -0.7,-0.09 -0.66,0.22 -0.63,-0.51 -1.44,-0.17 -0.79,-0.88 z m -17.38,-22.23 -0.01,-0.2 -0.5,-0.2 -0.42,0.18 0.16,-0.47 0.35,-0.09 0.31,0.06 0.1,0.17 0.13,-0.05 0.15,-0.15 0.06,-0.45 0.38,-0.01 0.74,0.26 0.62,-0.31 0.41,-0.36 0.91,0.35 0.35,-0.11 -0.25,-0.71 -0.45,-0.26 -0.21,-0.4 0.1,-0.56 0.5,-0.66 0.72,0.24 -0.21,0.55 0.36,0.35 0.81,0.28 0.1,-0.22 -0.29,-0.65 0.22,-1.07 -0.24,-0.8 -0.39,-0.67 -0.28,0.01 -0.34,0.47 -0.08,0.64 -0.32,0.42 -0.61,0.24 -1.37,0.85 -0.44,-0.01 -0.11,-0.3 -0.36,-0.03 -0.1,0.25 -0.46,0.3 -0.38,-0.06 -0.21,0.48 -0.02,0.39 -0.33,0.36 -0.29,0.63 0.02,0.52 -0.15,0.55 -0.39,0.61 0.07,0.21 0.28,0.17 1.36,-0.74 z m 6.36,0.74 0.04,0.27 0.37,0.09 -0.16,0.21 0.08,0.09 0.57,-0.05 -0.04,0.27 -0.44,0.4 -0.11,1.1 0.02,0.24 0.66,0.43 -0.18,0.52 0.1,0.09 0.64,-0.62 0.11,-0.37 -0.1,-0.42 0.16,-0.17 1.71,-0.94 0.83,-0.67 1.1,-0.42 0.3,0.18 1.13,0.02 0.48,-0.86 0.53,-0.58 0.09,0.13 -0.03,0.74 -0.26,0.53 0.2,0.12 0.44,-0.16 0.16,-0.13 -0.07,-0.24 0.16,-0.47 0.39,-0.26 0.44,-0.76 -0.11,-0.3 0.03,-0.36 -0.15,-0.03 -0.24,0.21 -0.34,-0.01 -0.13,-0.37 0.71,-0.37 -0.15,-0.15 -0.34,0.08 -0.13,-0.19 0.02,-0.27 0.47,-0.73 -0.01,-0.35 0.8,-0.58 0.07,-0.34 -0.53,-0.92 -0.21,-0.19 -0.19,0.11 -0.43,-0.02 -1.1,-0.5 -0.76,0.15 -0.54,0.35 -0.21,-0.06 -0.27,-0.33 -0.31,0.06 -0.44,0.58 -0.25,0.12 -0.33,-0.09 -0.09,-0.27 -0.17,-0.09 -0.28,0.66 -0.87,0.85 -0.66,0.25 -0.3,-0.15 -0.36,0.03 -0.63,0.29 -0.55,0.49 0.34,1.28 -0.41,0.98 -0.16,0.91 -0.03,0.2 0.47,0.13 -0.08,0.28 -0.21,0.03 -0.26,0.32 z m 60.09,103.72 0.42,1.14 0.24,-0.28 0.1,-0.63 0.2,-0.28 0.2,-0.13 0.33,0.08 0.28,-0.2 0.04,-0.37 -1.24,-0.54 -0.34,-0.31 -0.22,-0.03 -0.28,0.4 -0.65,-0.12 0.06,-0.26 -0.18,-0.22 -0.33,-0.01 -0.07,0.6 -0.2,0.2 -0.2,0 -0.07,-0.71 -0.43,-0.43 0.08,-0.2 -0.53,-0.09 -0.26,-0.23 -0.13,-0.21 0.1,-0.28 -0.2,-0.22 -0.25,-0.01 -0.72,0.59 -0.23,0.07 -0.05,0.44 0.09,0.27 -0.1,0.12 -0.97,0.09 -0.62,-0.2 -0.8,0.15 -1.09,-0.21 -0.63,0.17 -0.3,0.27 0.87,0.47 0.38,0.05 0.79,-0.16 1.48,0.58 1.23,0.18 0.24,0.25 0.13,0.57 0.77,0.11 0.17,-0.31 0.33,-0.15 1.44,0.85 0.72,-0.02 0.04,-0.19 -0.19,-0.15 0.28,-0.44 0.27,-0.06 z m 29.16,-25.31 -0.42,0.19 -0.12,-0.13 0.04,-0.32 -0.22,-0.53 0.09,-0.28 0.32,-0.2 0.33,-1.33 -0.32,-1.95 -0.63,-1.18 -1.64,-1.63 -1.67,-0.84 -0.67,0.08 -1.32,0.47 -0.38,0.97 -0.73,0.32 -0.88,0.13 -1.94,-0.27 -2.22,-0.89 -0.53,-0.07 -0.08,0.35 0.21,1.18 -0.07,0.47 -0.97,0.29 -0.66,-0.01 -1.03,-0.44 0.91,-0.64 0.68,-0.1 0.19,-0.3 0.45,-0.25 -0.54,-0.82 -1.13,-0.78 -1.73,-0.86 -1.28,-1.07 -0.43,-0.17 0.16,1.03 -0.03,0.84 -0.09,0.88 -0.3,0.21 -0.13,-0.46 0.01,-1.32 0.27,-0.7 -0.4,-0.64 -0.87,-0.69 -1.14,-0.35 -1.46,-1.01 -2.31,-2.67 -0.38,-0.34 -0.49,-0.2 -0.49,0.09 -0.56,0.51 -0.45,0.23 -0.3,1.21 -0.1,1.02 -0.58,0.76 -0.34,1.25 -0.32,-0.01 -0.3,-0.29 0.31,-1.45 0.5,-0.41 0.34,-0.72 -0.2,-0.83 0.08,-0.73 0.57,-0.03 0.84,-0.64 -0.21,-0.5 -1.02,-1.07 -1.08,-0.56 -2.81,-2.01 -2.97,-1.63 -2.23,-1.56 -0.21,0.09 0.06,0.76 0.24,0.37 -0.13,0.82 -0.13,0.12 -0.59,-1.53 -0.27,-0.22 -1.41,-0.18 -1.98,-0.79 -0.13,-0.01 -0.29,0.45 -0.58,0.47 -2.52,0.62 -0.28,0.38 0.15,0.2 0.47,1.43 -0.31,0.46 -0.45,0.12 -0.3,-0.12 -0.37,0.58 0.9,1.42 -0.21,0.31 -0.46,0.18 -0.12,0.49 -0.24,0.09 -0.15,-0.15 -0.26,-1.49 -0.61,-0.19 -0.47,0.58 -0.81,-0.26 0.09,-0.69 -0.44,-0.04 -1,0.4 -0.43,0.62 -0.59,0.18 -0.56,0.46 -0.56,0.11 -1.09,-0.06 -0.44,0.5 0.05,-0.48 0.47,-0.47 -0.33,-0.1 -0.3,0.2 -0.17,-0.77 0.1,-0.37 0.38,-0.15 0.13,-0.22 -0.1,-0.31 -0.77,-0.17 -0.51,0.02 -0.45,-0.37 0.35,-0.48 -0.22,-0.07 -0.48,0.15 -0.4,-0.32 0.96,-0.44 -0.53,-0.56 0.04,-0.2 0.44,-0.01 0.31,-0.3 0.86,0.27 0.68,0.01 0.29,-0.16 -0.23,-0.29 1.36,0.01 0.77,-0.49 0.36,1.01 0.54,0.12 1.1,-0.71 0.85,-0.08 0.21,-0.33 -0.04,-0.35 0.54,-0.28 1.09,-0.31 0.39,-0.47 -0.76,-0.74 -0.41,-0.01 -0.3,-0.47 0.17,-0.93 -0.07,-0.15 -0.74,0.21 -1.24,-0.87 0.24,-0.6 0.48,-0.41 0.04,-0.37 -0.44,-0.34 -0.92,-1.31 -0.03,-0.24 0.34,-0.4 0.17,-0.62 -0.04,-0.19 -0.2,-0.02 -0.66,0.37 -0.43,0.03 -0.18,-1.35 -0.42,0.02 -0.6,-0.25 -0.53,0.34 -0.04,0.57 -0.19,0.25 -0.41,0.25 -0.32,0.49 -0.86,0.73 -0.53,0.22 -0.59,0.63 0.31,0.37 -0.38,0.69 -0.79,0.41 -1.29,0.28 -0.82,0.03 -1.38,-0.16 -1.35,0.03 -0.02,0.46 0.6,0.8 0.11,0.52 -0.03,0.35 -0.2,0.39 -0.13,-1.12 -0.45,-0.01 -1.02,0.29 -0.76,-0.09 -1.23,-0.39 -2.2,0.54 -1.21,-0.4 -3.82,1 -0.33,0.3 -0.2,0.38 -0.44,0.03 -0.23,-0.11 0.53,-0.67 0.24,-0.15 1.3,-0.28 2.48,-1.28 -0.41,-0.43 -0.13,0.41 -0.11,0.02 -0.13,-0.17 -0.09,-0.93 0.08,-0.27 0.29,0.01 0.1,0.52 0.17,0.04 0.25,-1.23 0.25,-0.09 0.25,0.19 0.29,-0.01 1.01,-0.85 0,-0.16 -0.17,-0.16 0.01,-1 0.33,-0.7 0.51,-0.33 0.43,-0.11 0.1,-0.26 -0.09,-0.5 -0.66,-1.21 -0.54,0.13 -0.02,-0.25 0.36,-0.35 -0.82,-0.84 -0.27,-0.76 -0.38,-0.48 -0.61,-0.33 0.93,-1.19 2.01,-1.32 1.07,0.07 0.96,0.22 0.18,-0.27 0.58,-1.58 0.25,-1.04 -0.07,-0.76 -0.3,-0.79 -0.08,-0.66 0.08,-1.25 0.58,-0.65 0.2,-0.89 -3.26,-2.57 -0.94,-0.52 -0.29,-0.35 -0.24,-0.03 -0.44,0.17 -0.33,-0.05 -2.16,-1.12 0.25,-0.59 -0.93,-1.12 -0.36,-0.91 -0.19,-1.18 -0.35,0.27 -0.85,1.31 -0.78,1.54 -0.41,0.03 -0.4,-0.18 -1.06,0.16 -0.83,-0.42 -0.47,-1.05 0.08,-0.34 -0.33,-0.21 -1.02,-0.17 -0.34,-0.47 -0.74,0.5 -0.67,-0.56 -0.38,0.49 -0.73,-0.29 -0.45,-1.53 -0.43,-0.95 -0.22,-0.93 0.71,-0.6 0.08,-0.5 -0.43,-0.57 -0.75,-0.38 -0.37,-0.36 -0.21,-1.2 -0.25,-0.65 -0.38,-0.13 -0.15,-0.39 0.56,-0.58 -0.25,-0.38 0.11,-0.28 0.85,-0.63 0.02,-0.25 -0.12,-0.14 -0.36,-0.04 0.65,-0.63 -0.13,-0.88 -0.26,-0.65 0.21,-0.36 -0.02,-0.18 -0.13,-0.11 -0.98,0.01 -0.47,-0.12 -0.66,-0.36 -0.23,-0.21 -0.09,-0.43 -0.4,-0.57 -0.47,-0.25 -0.62,-0.82 -0.81,0.02 -0.22,0.19 0.28,0.65 -0.09,0.17 -0.41,0.03 -0.84,-0.45 -1.11,0.49 -0.58,0.41 -0.12,0.47 0.12,0.13 0.59,0.42 0.45,0.08 -0.52,0.43 -0.33,0.11 -0.47,-0.04 -0.08,-0.39 -0.49,-0.28 -0.22,0.07 -0.1,0.17 -0.09,0.44 0.28,0.37 -0.13,1.39 0.46,0.09 0.49,0.48 0.04,0.7 -0.25,0.66 0.37,0.01 -0.03,0.21 -0.68,0.11 -0.64,0.3 -0.09,0.19 0.18,0.24 -0.63,1.19 -0.72,0.45 0.04,0.45 -0.76,0.78 -0.14,0.26 0.07,0.3 0.35,0.48 -0.13,0.71 -1.57,0.96 -0.48,0.6 -0.78,0.13 -1.31,1.67 -0.77,0.2 -0.15,0.63 -0.02,0.76 -1.74,0.69 -0.79,-0.01 -1.47,-0.57 -0.07,-0.36 0.2,-1.84 0.77,-0.81 0.29,-0.46 1.38,-2.77 1.6,-1.54 -0.27,-0.88 0.22,-1.22 -0.72,-0.6 0,-0.2 0.76,-0.53 -1.09,-0.25 -0.93,0.24 -0.31,0.22 -0.45,-0.57 -0.1,-0.77 0.24,0.01 0.72,0.57 0.16,-0.08 0.19,-0.6 0.29,-0.14 0.27,0 0.7,0.61 0.35,-0.09 0.1,-0.43 -0.96,-1.72 -0.06,-0.29 0.18,-0.33 -0.48,-0.85 -0.65,-0.2 -1.4,-1.63 -0.97,-0.92 -0.3,0.01 -0.89,1.94 0,0.86 -0.83,0.25 -0.09,0.25 0.25,0.58 -0.08,0.39 -0.97,1.74 -0.53,0.49 -1.17,0.41 0.17,1.07 0.9,0.34 0.16,0.34 -0.79,0.25 -0.44,1.08 -0.46,0.33 0.35,0.64 0.26,1.08 0.08,0.84 -0.1,0.36 -1.09,1.6 -0.54,0.31 -0.73,0.2 -0.4,0.31 -0.18,0.52 -1.02,1.38 -0.16,0.68 -1.51,1.92 -0.34,0.17 0.26,0.27 -0.26,1.08 -0.26,0.51 -0.35,0.4 -2.15,1.5 -2.42,1.55 -1.23,0.49 -0.06,0.17 0.44,0.37 0.01,0.31 -0.45,0.25 -0.19,-0.37 -0.46,0.22 -0.19,0.29 0.39,0.72 -0.19,0.65 0.46,0.58 -0.38,0.38 -0.74,0.11 -0.3,-0.08 0.11,-0.47 -0.12,-0.18 -0.25,0.1 -0.38,0.67 -0.28,0.24 -1.31,0.36 -0.35,0.26 -0.4,0.85 -0.62,0.41 -0.88,0.91 -0.55,1.35 -0.46,0.64 -0.46,0.4 -0.27,0.7 -1.25,1.08 -0.42,0.06 -0.59,0.32 0.75,1.18 0.58,-0.8 0.52,0.4 -0.51,1.16 -0.33,0.37 0.07,0.68 -0.08,1.41 -0.44,0.28 -0.46,-0.27 -0.71,0.76 -0.43,0.08 -0.5,1.25 -0.03,0.91 -0.12,0.53 -0.21,0.33 0.42,1.33 -0.21,0.65 -0.39,0.66 -0.01,0.28 -0.85,0.21 -0.24,0.41 -0.01,0.39 -1.38,0.94 -1.03,0.53 -1.72,0.67 -0.32,0.78 -0.08,2.4 -0.43,2.45 -0.28,0.83 -0.74,0.96 -0.94,0.62 -0.8,0.34 -1.38,0.42 -0.68,0.09 -0.95,-0.01 -3.15,-0.4 -0.88,-0.2 -0.73,-0.37 -0.67,-0.6 0.36,-1.1 0.23,-0.34 0.03,-0.36 -0.17,-0.37 -0.92,-0.26 -0.67,1.7 -0.76,1.3 -0.5,0.64 -2.11,1.61 -2.85,3.06 -0.71,0.44 -0.84,0.09 -0.38,0.26 -0.2,0.32 -0.03,1.56 -0.35,1.46 -0.27,0.46 -0.54,0.4 0.01,0.15 1.02,0.02 0.36,-0.28 0.19,-0.75 0.58,-0.41 0.19,0.03 -0.3,0.89 -0.49,0.58 1.38,0.92 0.02,-0.38 0.36,-0.25 0.52,0.57 0.03,0.45 -0.36,0.01 0.08,0.35 1.91,1.18 0.81,0.71 0.58,-0.05 0.27,0.09 0.19,0.32 0.96,-0.3 0.27,0.09 -0.14,0.43 -0.02,0.31 0.1,-0.01 0.52,-0.25 0.83,-1.47 0.46,0.12 0.07,0.14 -0.37,0.38 -0.06,0.25 0.15,0.94 -0.53,0.06 -0.26,0.41 -0.02,0.31 -0.76,0.87 0.1,1.03 -0.32,1.68 -0.79,0.86 -0.65,0.92 -0.79,0.16 -0.92,0.42 -0.58,1.16 0,0 1.03,0.49 0.91,0.25 0.74,-0.21 1.66,-0.94 2.04,-0.25 0.44,0.11 0.28,0.28 0.13,0.36 0.13,0.89 -0.05,0.5 0.48,1.13 0.21,1.4 0.53,1.88 -0.04,1.95 -0.17,0.34 -0.4,0.22 -0.27,0.39 -1.38,3.32 -1.67,1.71 -0.31,0.8 -0.04,0.52 0.14,0.38 0.74,1.06 -0.03,1.05 0.42,0.81 -0.03,0.64 -0.56,0.46 -0.08,0.31 0.02,0.21 0.72,1.12 0.55,1.26 -0.06,0.69 -0.24,0.81 0.06,0.6 0.86,0.74 1.53,0.4 0.63,0.66 0.19,0.52 0.02,0.81 -1,1.87 -0.38,2.49 0.56,1.99 0.35,0.29 0.64,0.26 0,0 0.19,-1.22 0.7,-1.38 0.26,-0.16 0.59,0.15 0.2,-0.06 0.29,-0.59 0.82,-0.34 0.57,-1.1 0.21,-0.08 0.66,0.07 0.48,0.84 0.44,0.03 0.43,-0.26 0.15,-0.29 0.03,-0.67 0.15,-0.37 0.53,-0.34 0.28,-0.47 0.87,-0.54 -0.35,-0.99 0.37,-2.43 0.22,-0.33 0.37,-0.08 0.68,0.1 0.54,0.96 0.4,0.38 1.37,0.05 1.33,0.23 1.22,0.79 0.4,1.47 1.39,0.83 0.36,-0.23 0.81,-1.62 0.46,-0.64 1.21,-0.16 0.44,-0.27 0.22,-0.51 0.07,-0.83 0.25,-0.29 3.25,0.41 0.86,0.52 0.91,-0.33 0.69,0.01 1.28,-0.59 0.58,0.02 1.73,1.08 0.51,0.94 0.59,0.22 0.14,0.27 0.08,0.95 0.11,0.18 0.34,0.15 0.88,-0.25 0.36,-0.22 0.51,-1.26 0.74,0.44 0.73,-0.03 0.45,-0.16 0.07,-0.25 -0.29,-0.8 0.07,-0.35 0.24,-0.5 0.89,-0.64 0.22,-0.55 0.19,0.08 0.48,0.96 0.28,0.17 0.6,0.06 0.24,0.22 0.24,1.14 0.33,0.26 1.04,-0.18 0.58,-0.41 0.71,0.33 1.17,0 0.85,-0.51 0.48,-1.2 0.22,-0.06 0.76,0.61 0.75,1.09 0.32,0.08 0.57,-0.26 0.33,0.18 0.51,0.52 0.34,0 1.24,-0.37 1.3,-1.03 0.41,-0.12 0.57,0.38 0.82,0.06 0.41,0.49 0.25,0.13 1.55,-0.07 0.18,0.13 0.3,0.7 0.25,0.08 0.26,-0.14 0.32,-0.69 0.48,-0.25 2.37,0.51 0.43,-0.06 1.04,-0.43 1.35,0.44 1.21,-0.14 0.4,-0.33 0.01,-0.44 0.11,-0.11 1.3,-0.59 1.18,1.19 1.64,1.38 4.29,2.64 0.36,0.53 0.03,0.7 0.2,0.39 0.9,0.78 2.75,0.77 0.12,-0.07 0.34,-0.86 -0.27,-1.3 0.09,-0.33 -0.17,-0.33 1.1,-0.9 -0.32,-0.35 0.02,-0.29 -0.24,-0.26 -0.17,-0.6 0.14,-0.25 -0.03,-0.2 0.35,-0.46 1.37,0.17 0.78,-0.23 0.31,0.69 0.29,-0.02 0.1,-0.18 0.17,-1.6 -0.21,-0.37 -0.3,-0.14 -0.24,0.55 -0.45,-1.14 -0.4,-0.67 0.35,-0.21 0.34,0.11 0.66,-0.12 0.01,-0.14 -0.92,-0.29 0.04,-0.23 0.45,-0.17 0.26,0.31 0.57,-0.51 1.04,-0.41 0.7,0.36 0.23,0.49 -0.17,0.75 0.56,0.62 1.1,0.86 0.51,-0.03 0.49,0.16 0.71,0.77 0.91,0.25 0.51,-0.1 0.36,0.21 0.44,0.8 1.58,0.64 0.39,0.48 0.57,1.36 0.36,0.17 0.56,0.02 0.73,-0.34 0.5,-0.03 1.41,0.48 0.49,0.51 0.72,0.05 3.24,-1.31 0.87,-0.68 1.18,-0.6 1.87,-0.46 0.53,0.26 0.33,0.01 1.1,-0.28 0.43,-0.46 0.52,-0.18 1.68,-0.38 1.5,-0.06 0.5,-0.5 0.06,-0.59 -0.12,-0.11 -0.52,0.04 -0.22,-0.31 -0.02,-0.23 1,0.25 0.56,0.84 0.45,-0.22 0.59,0.02 0.36,0.58 0.38,0.09 0.44,0.01 0.96,-0.63 2.04,-0.63 0.95,0.11 0.73,0.29 0.99,-0.04 -0.21,-0.59 -0.03,-0.32 0.11,-0.23 0.24,-0.05 -0.06,0.28 0.13,0.13 0.22,-0.03 1.4,-1.14 -0.44,-0.65 -0.36,-0.18 -0.06,-0.31 0.82,0.03 0.37,0.19 0.01,0.63 0.37,0.13 0.22,-0.13 0.07,-0.42 0.92,-0.99 -0.11,-0.3 -0.67,-0.65 -0.2,-0.44 -0.29,-0.2 -0.71,-0.14 -0.07,-0.39 -0.39,-0.12 -0.11,0.15 0.1,0.26 -0.48,-0.09 0.09,-0.29 0.83,-0.49 -0.08,-0.22 -1.16,-0.32 -0.82,-0.13 -0.41,0.06 -0.92,1.14 -0.33,0.6 -0.52,-0.11 -0.15,-0.42 -0.28,-0.29 -1.54,-0.96 0.09,-0.22 0.34,-0.11 0.38,0.13 0.18,0.2 0.47,-0.16 0.47,-1.3 -0.15,-0.28 -0.36,-0.26 -0.52,0.23 -0.33,-0.48 -0.81,-0.8 -0.64,0.04 -0.26,0.61 -0.4,0.15 -0.22,-0.4 -0.63,-0.35 -0.45,-0.47 0.06,-0.54 -0.08,-0.14 -0.66,-0.19 -0.37,0.19 -0.47,0.07 -1.1,-0.23 -0.05,-0.92 -0.64,-0.23 -0.73,0.08 -0.16,-0.09 -0.4,-0.97 -1.17,-0.82 -0.27,-0.77 -0.88,-1.34 -0.1,-1.49 -0.26,-0.51 -0.73,-0.46 -0.22,-0.51 0.08,-0.21 -0.16,-0.09 -1.32,-0.04 -0.06,-0.97 -0.21,-0.32 0.02,-0.23 0.85,-0.26 0.4,0.25 0.25,-0.64 0.06,-0.65 1.17,-0.43 0.05,-0.2 -0.37,-0.06 -0.06,-0.18 0.3,-0.36 0.55,-0.51 1.19,-0.62 0.68,-0.07 1.23,0.34 0.13,-0.34 -0.01,-0.36 0.32,-0.07 0.13,0.47 -0.16,0.29 0.47,0.1 0.25,-1.19 0.26,-0.59 0.45,-0.57 0.3,-0.12 0.86,0.16 1.39,-0.09 1.03,0.45 0.64,0.13 0.45,0.34 0.32,0.47 -0.26,0.87 0.25,0.56 0.69,0.69 0.12,0.42 1.81,0.01 0.45,-0.31 0.97,-1.24 0.46,0.29 0.79,0.06 1.03,0.34 2.51,0.43 0.38,-0.02 0.6,-0.51 1.01,-0.23 0.15,0.26 0.88,-0.09 0.49,-0.19 1.96,-1.26 1.34,-0.4 0.96,-0.01 1.27,-1.13 0.92,-0.36 1.27,-0.41 5.76,-1.42 3.22,-1.3 2.04,-1.62 0.52,-0.54 1.37,-1.82 -0.07,-0.22 0.16,-0.89 -0.21,-0.53 z m -66.29,38.79 -0.72,0.11 -1.22,-0.99 -0.52,-0.17 -0.21,0.13 0.12,-0.13 -0.13,-0.32 -0.33,0.33 -0.13,0.45 0.13,0.27 -0.02,0.3 0.26,0.23 -0.01,0.35 0.3,0.35 0.31,0.08 0.74,0.67 1.23,0.52 0.65,-0.65 0.74,-0.38 -0.15,-0.74 -0.19,-0.2 -0.85,-0.21 z m 44.83,-7.61 0.31,0.23 -0.19,0.6 -0.1,-0.06 0,-0.36 -0.52,-0.12 -0.1,-0.32 -0.13,0.01 -0.05,0.15 -0.42,-0.23 -0.37,0.1 -0.17,-0.3 -0.27,-0.14 0.05,-0.17 -0.12,-0.2 -0.34,0.02 -0.01,-0.2 -0.89,0.17 -0.75,-0.34 -0.16,0.05 0.42,0.41 -0.5,0.12 0.06,0.31 0.38,0.36 0.03,0.22 0.7,0.45 -0.03,0.27 0.12,0.1 -0.57,0.86 0.03,0.25 0.25,0.06 0.37,-0.2 0.13,-0.22 0.42,-0.06 0.51,-0.55 1.46,0.17 0.16,-0.19 0.59,-0.07 0.58,-0.57 -0.39,-0.06 -0.07,-0.38 -0.42,-0.17 z",
                        "Sarawak" : "m 437.74,231.08 0.93,0.28 0.28,0.51 0.24,0.94 0.34,0.48 -0.11,0.83 -0.17,0.27 -0.24,0.07 -0.95,-0.66 -0.36,-0.03 -0.59,0.86 -0.12,0.31 0.06,0.3 0.27,0.26 0.27,0.02 0.16,-0.14 0.18,-0.53 0.29,-0.17 0.15,0.17 -0.27,0.42 0.01,0.3 0.21,0.13 0.47,0.02 0.06,0.27 -0.9,0.15 -0.24,-0.33 -0.2,-0.04 -0.37,0.26 -0.26,-0.09 -0.44,0.26 -0.18,-0.15 -0.28,-0.03 -0.22,-0.32 -0.25,-0.09 -0.34,-0.72 -0.01,-0.76 0.16,-0.17 0.29,0.36 0.28,-0.13 0.19,-0.43 -0.36,-0.37 0.88,-0.1 0.31,-0.43 -0.02,-0.31 -0.36,-0.65 0.02,-0.26 0.5,-0.32 0.69,-0.24 z m -9.12,-3.05 0.3,0.07 0.17,0.22 0.11,-0.18 0.31,0.02 0.09,0.45 -0.3,0.24 -0.04,0.38 0.54,0.72 0.43,0.23 -0.06,0.2 -0.64,0.72 -0.48,0.18 -0.58,0.03 -0.19,-0.11 0.09,-0.38 -0.08,-0.19 -0.33,-0.23 0.06,-0.56 -0.18,-0.31 -1.23,-0.23 -0.24,-0.21 -0.02,-0.29 0.31,-0.39 1.96,-0.38 z m 9.66,-1.56 0.16,0.01 0.33,0.29 0.43,0.77 -0.53,0.17 -0.57,0.48 -0.33,0.99 0.18,0.36 -0.11,0.17 -0.48,0.1 -0.06,0.36 0.2,0.23 0.48,0.13 -0.88,0.3 -0.83,0.71 0.01,0.68 0.36,0.57 -0.19,0.13 -1.48,0.27 -0.37,0.31 -0.13,-0.07 -0.02,-0.3 -0.28,-0.22 -0.2,-0.07 -0.26,0.22 -0.18,-0.03 0.06,-0.5 -0.08,-0.13 -0.31,0.11 -0.46,-0.22 -0.19,-0.8 -0.36,-0.78 0.54,-0.4 0.35,0.13 0.2,-0.11 0.03,-0.26 -0.21,-0.5 0.01,-0.63 0.58,-0.21 0.79,0.15 0.47,0.51 0.5,0.11 -0.28,-0.26 0.15,-0.48 0.47,-0.55 0.11,-0.92 0.67,-0.21 0.39,0.02 0.34,0.48 0.52,-0.08 0.45,-0.27 -0.25,-0.54 0.26,-0.22 z m -6.71,-2.26 0.43,0.33 -0.36,0.48 0.03,0.3 0.3,0.5 0.36,0.31 -0.09,1.6 0.76,0.56 0.01,1.2 0.25,0.65 -0.1,0.23 -0.48,-0.11 -0.24,0.28 -0.27,0.11 -0.47,-1.06 0.18,-1.25 -0.26,-0.37 -0.25,-0.13 -0.67,0.01 -0.11,-0.51 -0.43,-0.34 0.16,-0.47 0.39,-0.22 0.15,-0.23 -0.12,-0.29 0.13,-0.42 0.33,-0.45 -0.07,-0.17 0.1,-0.31 0.34,-0.23 z m 41.39,-15.93 0.11,-0.41 0.67,-0.13 -0.01,0.47 0.67,0.16 0.29,0.37 -0.26,0.37 -0.39,0.1 -0.24,-0.41 -0.25,-0.07 -0.19,0.08 -0.1,0.18 0.01,0.65 -0.83,0.27 -0.41,0.39 -0.12,0.36 0.05,0.69 -0.07,0.22 -0.19,0.14 -0.52,-0.18 -0.87,-0.67 -2.01,-0.51 -0.85,0.16 -0.59,-0.04 -1.15,0.49 -1.01,-0.88 0.32,-1.11 0.63,-0.25 0.9,-0.78 0.38,-0.8 0.19,-0.18 0.18,0.06 0.42,0.93 0.53,0.76 0.77,0.17 0.67,-0.34 0.19,-0.25 0.12,-0.67 -0.06,-1.44 -0.26,-0.88 0.06,-0.17 0.91,0.24 0.98,0.58 0.47,0.42 0.37,0.93 -0.14,0.79 0.35,0.34 0.28,-0.15 z m -4.57,-9.4 0.14,0.05 -0.01,0.14 -0.47,0.81 0.13,0.16 0.42,-0.45 1.42,0.68 1.48,0.45 0.09,0.2 -0.1,0.21 -0.65,0.52 -0.3,0.5 0.08,0.3 0.53,0.26 0.09,0.3 -0.71,0.3 -0.09,0.49 -0.98,1.36 0,1.73 0.25,1.32 -0.3,0.27 -0.67,0.19 -0.3,-0.09 -0.32,-1.05 -0.57,-0.73 -0.33,-0.24 -0.48,-0.06 -0.69,0.62 -0.14,-0.38 0.13,-1.97 -0.22,-1.45 -0.08,-1.56 0.56,-1.24 0.77,-0.86 1,-0.6 0.11,-0.16 0.21,-0.02 z m 5.83,-11.23 -0.41,-1.43 0.81,-0.55 0.07,0.11 -0.47,1.87 z m -2.4,-3.42 0.43,0.31 0.83,1.81 0.71,0.6 0.16,0.38 -0.27,1.66 0.17,2.31 -0.03,1.2 -0.24,1.08 0.11,2.08 -0.1,1.14 0.74,1.17 0.34,2.17 0.26,0.52 0.45,0.41 -0.12,0.41 -0.17,0.15 -0.27,0.01 -0.63,-0.22 -0.53,0.11 -0.25,0.32 -0.15,0.49 -0.28,0.17 -0.73,-0.89 0.02,-0.86 -0.21,-0.53 -0.54,-0.54 -1.01,-0.52 -0.07,-1.4 0.41,-1.89 -1.19,-5.3 -0.02,-2.5 0.33,-1.59 0.41,-0.91 0.59,-0.91 0.57,-0.38 0.28,-0.06 z m 22.24,-2.82 4.62,-0.68 6.37,-1.42 4.76,-1.41 9.26,-1.99 2.45,-0.42 0.66,0.21 0.46,-0.17 0.32,-0.38 0.78,-0.36 2.35,-0.74 3.05,-0.72 4.57,-0.89 2.21,-0.66 2.23,-1.12 1.13,-0.75 0.82,-0.69 0.78,-0.97 1.13,-1.71 -0.07,-0.2 -0.68,-0.73 0.98,-0.89 1.98,-1.34 1.02,-0.96 1.62,-2.79 1.67,-1.26 2.11,-1.99 0.6,-0.95 -0.38,-0.65 0.45,-0.66 2.73,-2.74 1.72,-2.89 0.43,-0.95 -0.15,-0.81 0.48,-0.77 1.19,-0.88 3.62,-2.29 4.71,-3.88 0.97,-0.94 2.74,-2.97 0.85,-1.13 1.42,-2.61 1.54,-1.65 2.78,-3.58 0.94,-1.52 0.63,-1.3 0.29,-1.09 -0.3,-0.23 -0.1,-0.31 0.92,-1.14 0.53,-2.08 0.06,-1.18 -0.16,-1.14 -1.08,-3.21 0.62,-0.53 3.93,0.31 1.92,-0.02 1.16,0.28 0,0 0.63,0.34 0.95,1.23 0.48,-0.16 0.38,0.11 0,0 0.8,0.52 0,0 1.09,1.41 1.79,3.1 -0.13,1.61 0.1,0.22 0.73,0.57 0.12,0.21 -0.5,1.76 0.05,1.31 0.29,0.22 1.01,0.25 0.4,-0.11 0.45,-0.36 0.27,-0.06 1.4,0.44 0.31,-0.11 0.46,-0.64 0.32,-0.1 0.33,0.1 0.25,0.31 0.06,1.01 0.18,0.77 0.67,1.44 0.97,1.6 1.43,0.16 0.63,0.65 0.29,0.79 0.89,1.42 0.97,0.61 1.32,0.22 0.13,0.41 -0.69,0.75 0,0 -0.05,0.28 0,0 0.66,0.16 0,0 1.64,-0.51 0,0 1.85,-1.09 0.93,-0.88 0.69,-0.87 0.66,-1.09 1.32,-0.93 0.23,-0.35 0.08,-0.27 -0.88,0.11 -0.07,-0.15 0.13,-0.53 0.51,-0.46 1.51,-2.21 0.43,-1.26 -0.12,-0.08 -0.96,0.92 -0.34,0.03 -0.09,-0.25 0.08,-0.62 1.36,-1.54 1.05,-2.1 0.06,-1.97 -0.25,-0.16 -1.33,-0.3 -0.44,-0.26 -0.28,-0.52 -0.23,-2.58 0.07,-1.47 -0.41,-3.73 -0.16,-1.01 -0.88,-1.46 -0.03,-0.74 0.17,-0.77 0.24,-0.25 0.35,-0.11 1.15,-0.11 0.44,-0.37 0.61,-1.54 0.52,-0.34 1.27,-0.33 2.2,-0.31 0.53,-0.28 1.24,-2.34 0,0 0.78,-0.39 0.13,0.7 0.17,0.28 -1.1,1.3 -0.38,1.49 0,1.02 0.22,0.2 0.21,-0.08 0.21,-2.42 0.38,-0.65 0.21,-0.1 0.14,0.27 -0.16,0.54 0.02,0.52 0.41,0.67 0.66,0.41 0.02,0.17 0,0 -0.54,1.4 0.39,1.27 -0.13,0.67 0,0 -0.02,0.44 0,0 0.31,0.64 0.08,0.93 0.15,0.36 0.03,0.86 0.18,0.59 0.52,0.85 1.32,4.26 -0.16,1.3 0.33,1.28 -0.17,0.92 0.14,0.26 0.47,0.33 0.6,0 0.18,-0.1 0,0 0.54,-0.06 0,0 2.1,0.76 1.57,-0.12 0.31,0.23 0.21,1.07 1.25,-0.16 0.52,0.24 0.29,0.25 0.22,0.58 0.37,0.37 0.47,0.12 0.26,-0.07 0.59,-0.34 0.58,-0.56 0.04,-0.72 -0.54,-0.61 -0.46,-0.89 -1.46,-1.1 -0.67,-0.74 -0.24,-0.45 -0.17,-0.56 0.2,-0.69 -0.22,-0.58 0,-0.93 -0.29,-0.37 0.11,-0.89 -0.13,-0.48 0.63,-0.9 0.03,-0.78 0.15,-0.47 -0.18,-1.15 -0.8,-0.55 -0.29,-0.33 0.26,-0.39 0.06,-0.61 -0.43,-0.4 -0.14,-0.42 0.19,-0.82 -0.07,-0.63 -0.22,-0.37 -0.65,-0.57 -0.11,-0.32 0.25,-1.38 -0.48,-0.61 -1.28,-0.85 0,0 -0.6,-0.52 0,0 0.08,-0.45 -0.53,-0.15 -0.56,-0.76 -0.17,-0.66 0,0 -0.27,-0.03 -0.2,-0.34 2.06,-0.72 0.22,-0.41 -0.11,-0.96 0.52,-0.22 0.71,-0.04 0.31,0.14 0.1,0.18 0.49,1.4 0.5,0.38 1.34,0.28 1,0.66 0.58,0.02 1.03,-0.18 0.73,-0.32 0.5,-0.5 -0.14,-0.38 -0.01,-0.52 0.47,-0.12 1.14,-1.17 0.87,-0.16 0,0 1.03,0.49 0.95,0.19 0.74,-0.21 1.66,-0.94 2.04,-0.25 0.44,0.11 0.28,0.28 0.13,0.36 0.13,0.89 -0.05,0.5 0.48,1.13 0.21,1.4 0.53,1.88 -0.04,1.95 -0.17,0.34 -0.4,0.22 -0.27,0.39 -1.38,3.32 -1.67,1.71 -0.31,0.8 -0.04,0.52 0.14,0.38 0.74,1.06 -0.03,1.05 0.42,0.81 -0.03,0.64 -0.56,0.46 -0.08,0.31 0.02,0.21 0.72,1.12 0.55,1.26 -0.06,0.69 -0.24,0.81 0.06,0.6 0.86,0.74 1.53,0.4 0.63,0.66 0.19,0.52 0.02,0.81 -1,1.87 -0.38,2.49 0.56,1.99 0.35,0.29 0.64,0.26 0,0 0.24,0.06 -0.32,2.09 -1.05,3.41 -0.66,1.08 -0.67,0.49 -0.65,0.25 -1.07,0.03 -0.34,0.16 -0.08,0.16 0.19,0.51 0.51,0.6 1.26,0.78 0.29,0.27 0.09,0.39 -0.22,1.2 -1.01,2.34 -0.3,1.06 -0.3,1.33 -0.07,2.41 0.37,2.37 0.88,1.11 0.31,2.63 1.23,1.78 0.25,0.69 -0.67,1.25 -0.32,0.15 -0.24,-0.09 -0.46,-1.35 -0.72,-0.21 -0.26,0.09 -1.43,2.83 -0.49,2.04 -0.21,0.48 -0.03,2.05 0.12,0.66 -0.08,0.64 -0.37,0.86 0.47,0.47 1.25,0.83 0.08,0.35 -0.13,0.33 -1.88,1.78 -0.09,0.43 0.11,0.78 -0.07,1.03 -0.33,0.6 -1.06,0.71 -1.45,-0.02 -0.54,0.15 -0.47,0.53 -0.19,0.43 -0.73,0.68 -2.46,0.2 -0.54,-0.13 -0.31,-1.26 -1.16,-1.24 -0.55,1.75 -0.97,1.05 -1.45,0.58 -0.7,0.84 -0.95,0.32 -0.13,0.13 -0.35,2.21 -0.79,0.93 -0.86,0.46 -0.6,0.67 -0.08,0.2 0.57,0.34 0.87,-0.01 0.25,0.24 0.11,0.32 -0.46,0.83 0.04,1 -0.28,0.38 -0.95,0.53 -0.23,0.29 0.04,0.96 0.49,1.46 -0.26,1 -0.69,0.54 0.02,0.46 0.48,0.45 0.19,0.48 0.11,0.04 0.65,-0.05 0.56,-0.5 0.67,-0.24 0.45,0.1 0.85,1.13 0.7,0.66 0.11,0.85 0.99,0.4 0.12,0.41 -0.08,0.84 -0.44,0.45 -1.32,0.66 -1.32,-0.18 -1.18,0.25 -0.96,0.75 -0.41,0.5 -0.39,1.35 -0.14,0.07 -1.04,-0.16 -0.43,0.05 -0.84,0.79 -0.38,0.66 -0.57,0.19 -0.54,0.5 -0.37,-0.12 -0.52,-0.55 -0.49,0.12 -0.43,0.7 -0.21,1.03 0.12,0.42 0.53,0.41 -0.03,0.39 -0.19,0.25 -0.82,0.24 -0.67,0.76 -0.41,0.14 -1.08,-0.1 -2.58,0.34 -0.55,0.31 -0.1,0.7 -0.31,0.69 -0.26,1.47 -0.1,1.08 0.1,0.74 0.29,0.54 0.6,0.07 0.29,0.32 0.07,0.59 -0.37,0.35 -0.07,0.21 -0.01,1.22 0.57,1.17 0.41,0.04 1.44,-0.81 0.54,0.13 0.48,0.36 0.11,0.48 -1.42,1.28 -0.27,0.54 0.06,0.73 0.94,0.86 0.09,0.27 -0.91,0.82 -1.33,0.06 -0.87,0.93 -0.31,0.69 -0.38,0.18 -0.4,-0.03 -0.68,-0.5 -0.49,-0.09 -0.48,0.09 -0.5,0.34 0.15,0.61 -0.08,0.35 -1.09,0.85 0.08,0.27 0.4,0.39 0.15,0.54 -0.18,0.99 0.32,1.08 -0.28,0.72 0.05,0.81 -0.12,0.69 -0.3,0.49 -0.8,0.6 -0.41,1.14 -0.44,0.7 -1.93,1.1 -0.03,0.66 -0.37,0.86 0.35,0.94 -0.19,0.89 -0.73,1.04 -0.3,0.68 -0.62,0.69 -1.12,-0.15 -1.72,-1.4 -0.94,-0.06 -2.83,-1.81 -0.33,0.01 -0.25,0.27 -0.14,0.46 -0.28,0.29 -1.62,0.47 -1.19,0.5 -0.82,0.63 -0.6,0.15 -1.01,-0.04 -0.31,0.12 -0.21,0.15 -0.83,1.18 -0.36,0.22 -0.4,-0.58 -1.33,-0.79 -0.69,-0.79 -0.28,-0.1 -1.16,0.34 -0.55,-0.3 -0.61,0.01 -2.41,0.71 -0.65,-0.04 -0.54,-0.25 -0.43,-0.02 -1.25,0.48 -0.29,0.32 -0.23,0.52 -3.45,1.3 -1.09,0.58 -0.2,0.44 0.35,0.41 0.06,0.66 -0.57,1.06 -0.28,0.31 -2.62,1.14 -1.51,0.42 -1.72,1.68 -0.69,-0.09 -0.64,0.15 -0.31,-0.23 0,-0.88 -0.99,-0.53 -0.71,-1.7 -0.24,-0.16 -0.58,-0.07 -0.85,-0.6 -0.33,0.02 -0.68,0.29 -0.8,0.01 -1.37,0.51 -0.71,0.65 -0.72,0.08 -0.44,-0.29 -0.8,-0.97 -1.07,-0.45 -0.47,-1.19 -0.2,-0.15 -0.85,-0.4 -2.31,-0.7 -2.11,-0.16 -0.79,0.36 -1.13,0.11 -1.49,-0.5 -0.91,-1.49 -0.62,-0.48 -0.2,0 -1.59,0.8 -1.54,0.5 -1.67,0.01 -0.19,-0.31 -0.01,-0.66 0.38,-0.67 2.14,-0.95 0.14,-0.15 0.33,-1.42 0.33,-0.43 0.46,-0.27 0.07,-0.21 -0.33,-0.84 -1.23,-0.38 -1.23,-0.58 -0.31,0.08 -0.41,0.45 -0.58,0.02 -1.71,-0.18 -0.66,-0.48 -0.48,-0.16 -0.49,0.01 -0.27,0.15 -0.43,0.67 -0.59,0.49 -0.22,0.52 -1.77,-0.1 -0.31,-0.46 -0.98,-0.41 -0.69,0.28 -0.27,-0.02 -0.58,-0.28 -1.37,0.43 -0.8,-0.03 -0.37,-0.13 -0.62,-0.46 -0.81,0.24 -1.39,-0.24 -3.45,-0.21 -0.67,-0.22 -0.65,0.2 -1.21,0.83 -0.19,0.23 -0.2,0.62 -0.33,0.33 -1.07,0.17 -2.14,0.72 -1.27,-0.09 -1.76,1.4 -1.18,0.42 -1.04,0.12 -0.63,0.42 -0.19,0.27 -0.2,1.12 0.13,0.2 0.92,0.48 0.08,0.29 -0.73,2.01 -1.09,1.04 -0.19,0.39 -0.23,0.9 0.05,0.79 -0.47,0.63 0.22,0.77 -0.15,0.73 -0.66,0.93 0.32,0.8 -0.16,0.51 -0.57,0.28 -1.73,-0.01 -2.06,0.38 -3.21,0.29 -0.53,0.21 -0.29,0.28 -0.44,0.91 -0.76,0.64 -0.75,0.39 -0.51,0.85 0.02,0.65 -0.17,0.76 -0.17,0.17 -0.55,0.12 -0.98,-0.11 -1.27,-0.55 -0.16,0.09 -0.18,0.58 -0.23,0 -0.74,-0.78 -1.21,0.37 -0.48,-0.01 -0.36,-0.55 -2.03,-0.83 -0.82,0.34 -1.75,1.51 -0.51,0.26 -0.6,-0.06 -0.59,0.11 0.06,1.2 -0.05,0.23 -0.24,0.14 -0.88,-0.33 -0.7,-1.83 -0.55,-0.61 -0.83,-0.52 -0.66,-0.03 -0.81,0.64 -0.45,0.2 -0.92,0.11 -0.7,-0.07 -0.45,-0.14 -1.24,-0.81 -3.99,-1.19 -0.71,-0.62 -0.66,0.21 -0.94,0.51 -2.23,0.5 -3.22,0.24 -1.4,0.55 -3.68,0.36 -0.98,-0.13 -0.44,0.3 -0.26,0.42 -0.08,0.64 -1.57,1.76 -1.09,-0.08 -0.88,0.23 -0.09,0.42 0.37,0.68 -0.09,0.36 -0.17,0.2 -0.28,0.05 -0.39,-0.21 -0.42,-0.72 -0.39,-0.14 -0.24,0.19 -0.06,0.64 -0.15,0.23 -0.32,0.07 -1.1,-0.19 -1.19,0.87 -1.02,0.25 -0.57,-0.23 -0.17,-0.23 -0.06,-0.56 -0.4,-0.16 -0.23,0.1 -0.04,0.89 -0.27,0.44 -2.08,0.7 -1.63,-0.61 -1.71,-0.32 -1.75,-1.31 -0.4,-0.57 -0.01,-0.19 0.21,-0.23 -0.02,-0.29 -0.33,-0.18 -0.91,-0.13 -0.09,-1.06 -0.15,-0.35 -0.33,-0.31 -0.53,-0.02 -0.74,0.34 -0.63,-0.19 -0.41,-0.32 -2.2,0.11 -0.26,-0.08 -0.09,-0.2 0.17,-0.54 0.02,-1.25 -0.67,-0.22 -0.69,-1.21 -0.01,-0.76 -0.15,-0.4 -0.37,-0.22 -0.75,0.05 -0.18,-0.1 -0.13,-0.43 0.06,-0.92 -0.57,-0.91 -0.28,-0.28 -1.44,-0.67 -1.38,0.14 -0.76,-0.1 -0.55,-0.63 -1.67,0.34 0.04,-0.42 0.75,-0.67 0.17,-0.29 -0.15,-0.79 -0.18,-0.25 -1.46,-0.65 -0.68,-0.53 -0.82,0.02 -0.2,-0.17 -0.76,-2.55 -0.03,-1.28 -0.87,-0.86 -0.55,-0.24 -2.81,0.1 -0.96,-0.2 -0.11,-1.33 0.35,-1 -0.3,-0.02 -0.68,0.66 -0.16,0.06 -0.3,-0.18 -0.79,-1.34 -3.56,-3.57 -0.28,-0.64 -0.81,-0.29 -0.56,-0.8 0.5,-3.89 0.66,-1.41 0,-0.55 -0.36,-0.39 -0.96,-0.34 -1.18,-0.12 -0.77,-0.32 -0.29,-0.38 -0.45,-1.08 -0.26,-0.18 -0.69,-0.1 -0.18,-0.21 -0.03,-0.64 -0.27,-0.37 -0.32,-1.48 0.17,-0.22 0.36,-0.12 0.45,0.2 0.32,-0.16 0.31,-0.39 0.44,-1.23 1.21,-0.73 0.57,-0.9 0.38,-0.75 0.19,-0.94 0.16,0.32 0.26,0.21 -0.17,0.08 0.02,0.52 -0.26,0.61 0.22,0.39 0.45,0.28 0.14,0.26 -0.38,-0.07 -0.26,0.18 0.01,1.01 -0.17,0.28 0.13,1.39 0.27,0.54 1.12,1.02 -0.11,0.63 0.31,0.27 1.39,0.72 2.04,0.71 0.2,0.56 0.58,0.61 0.12,-0.04 -0.05,-0.26 -0.35,-0.46 2.25,0.83 0.36,0.65 1.23,0.72 -0.42,0.9 0.63,0.4 1.02,0.35 0.49,0.46 -0.13,0.13 -0.4,-0.27 -0.31,-0.01 -0.38,0.14 0.01,0.14 0.47,-0.06 0.25,0.29 0.49,0.25 0.55,-0.03 0.41,-0.21 0.09,-0.32 0.33,-0.08 0.67,0.31 -0.07,0.2 0.12,0.43 0.7,-0.63 0.5,-0.18 4.62,-0.01 3.09,-0.32 0.18,0.23 -0.09,0.71 0.67,0.37 0.85,0.08 0.24,0.19 -0.01,0.58 0.08,0.19 0.36,0.2 -0.1,0.42 0.34,0.58 0.44,-0.14 0.8,-0.53 0.65,-0.69 -0.13,-0.88 -0.29,-0.29 -0.08,-0.25 0.57,-0.29 0.15,-0.36 0.69,-0.4 0.21,0.06 0.3,0.36 -0.24,1.3 0.86,1.86 0.25,0.8 0.47,0.23 0.35,-0.05 0,0.58 0.26,0.04 0.19,-0.17 0.4,0.12 0.06,0.29 -0.11,0.37 -0.43,0.23 0.23,0.34 0.33,0.01 0.18,-0.16 0.2,-0.6 0.26,-0.2 0.87,0.29 0.06,0.13 -0.3,0.4 -0.35,-0.32 -0.25,0.19 0.07,1.03 0.23,0.47 0.32,0.12 0.25,0.33 0.45,0.19 0.47,-0.25 0.22,0.11 0.48,-0.29 0.43,0.42 0.21,-0.12 0.5,0.06 0.19,-0.13 0.01,-0.26 -0.12,-0.12 -0.64,-0.13 0.29,-0.62 -0.12,-0.29 -0.18,-0.04 -0.34,0.21 -0.29,0.67 -0.2,-0.06 -0.2,-0.23 0.04,-0.36 0.66,-0.89 0.15,0 0.81,0.65 0.53,0.01 0.3,-0.39 0.22,-1.08 1.01,-0.47 1.01,-0.13 0.77,0.15 2.51,1.2 1.17,0.43 0.92,0.19 0.28,0.2 0.48,1.28 -0.02,0.92 -0.15,0.38 -1.31,0.61 -0.99,0.67 -1.27,0.49 -0.25,0.29 -0.1,0.79 0.16,0.31 0.54,0.41 0.45,-0.07 0.81,-0.65 0.57,-0.27 0.88,0.35 0.72,0.58 0.17,-0.09 -0.21,-0.34 -0.58,-0.37 -0.93,-0.36 -0.52,0.11 -0.89,0.72 -0.43,0.15 -0.34,-0.39 -0.11,-0.58 0.29,-0.29 1.14,-0.31 1.86,-0.82 0.89,-0.59 0.43,-0.87 0.2,-1.46 -0.1,-1.13 0.17,-0.31 0.35,-0.08 0.31,-0.36 0.61,0.01 2.29,1.13 0.65,0.48 2.65,0.61 1.55,0.95 0.66,0.48 0.46,0.51 0.7,1.33 0.49,0.6 0.75,0.67 0.54,0.3 1.28,0.21 0.95,0.29 1.19,0.88 0.73,0.3 0.98,-0.41 0.97,-0.86 1.36,-0.15 0.33,0.16 0.16,0.23 0.43,1.37 0.22,0.36 1.23,0.61 0.4,0.03 0.12,-0.11 0,-0.28 -0.48,-0.51 -0.18,-0.5 -0.03,-1.13 -0.48,-0.44 -1.37,-0.61 -0.83,-0.07 -1.53,0.36 -1.19,0.82 -1.6,-1.24 -2.24,-0.77 -0.52,-0.38 -0.28,-0.39 -0.22,-0.98 -0.65,-1.08 -0.93,-0.61 -0.31,-0.05 -0.28,0.16 -0.16,-0.11 0.21,-0.7 -0.21,-1.26 0.23,-0.33 0.69,-2.84 0.42,-0.61 0.51,-0.47 1.43,0.11 1.02,-0.38 1.01,0.25 0.57,0.01 0.16,0.13 0.04,0.71 0.27,0.73 0.72,0.49 0.58,-0.04 0.96,-0.45 0.21,0.09 0.38,0.55 0.55,0.29 1.22,-0.12 0.28,0.13 0.41,-0.19 -0.31,-0.23 -0.51,-0.17 -1.06,0.06 -0.54,-0.64 -0.54,-0.27 -0.46,0 -0.92,0.52 -0.35,-0.1 -0.3,-0.5 0.05,-0.92 -0.21,-0.55 -0.3,-0.26 -0.98,-0.17 -0.56,-0.76 -0.05,-0.53 -0.91,-0.94 0.27,-0.58 0.41,-0.45 0.99,-0.29 0.34,-0.48 0.18,-0.63 -0.18,-0.12 -0.73,1.06 -0.5,0.05 -0.14,-0.49 0.05,-0.63 0.43,-1.13 2.21,-4.23 0.12,-0.38 -0.12,-0.26 0.13,-0.8 0.3,-0.91 0.67,-1.39 0.59,-1.95 0.87,0.84 0.86,0.34 0.69,0.04 0.52,-0.29 0.43,0.14 0.38,0.47 0.58,-0.09 0.53,-0.36 0.04,-0.4 0.68,-0.61 -0.07,-0.63 0.17,-0.26 0.25,-1.56 0.31,0 0.68,0.48 0.54,-0.04 0.74,-0.39 1,0.59 0.18,-0.23 -0.61,-0.24 -0.57,-0.42 -0.44,0 -0.84,0.43 -0.4,-0.53 0.14,-0.26 0.01,-0.62 0.07,-0.08 0.54,0.52 0.52,0.25 0.2,-0.14 0.09,-0.41 -0.17,-0.48 -0.29,-0.35 -0.63,-0.22 0.11,-0.37 -0.09,-0.09 -0.79,0.13 -0.15,0.49 -0.23,0 -0.18,-0.25 0.15,-0.75 -0.33,-0.93 -0.6,-0.64 -0.98,-0.75 -0.19,-0.43 0.07,-0.27 0.87,-1.18 -0.07,-0.45 -0.61,-0.5 0.24,-0.26 0.56,-0.26 1.04,1.32 0.62,0.03 0.24,-0.14 0.53,-0.99 1.02,0.2 0.43,-0.18 0.64,-0.53 0.81,0.58 0.74,0.25 0.48,0.51 0.14,0.02 -0.2,-0.6 -0.34,-0.35 -0.75,-0.56 -1,-0.52 -0.86,-0.85 -0.16,-0.38 0.06,-1.26 -0.13,-0.32 -0.73,-0.91 0.21,-0.19 0.65,0.03 0.66,0.16 1.01,0.49 0.55,0.09 0.71,-0.21 0.62,-0.52 0.15,0.18 0.03,0.74 0.17,0.42 1.4,0.94 0.57,-0.19 0.12,-0.18 0.08,-0.61 0.17,-0.21 0.42,0.55 0.33,0.23 0.49,0.18 0.22,-0.35 -0.73,-0.16 -0.3,-0.67 -0.48,-0.1 -0.28,0.16 -0.29,0.95 -0.13,0.15 -0.16,-0.01 -0.55,-0.58 -0.59,-0.4 -0.04,-0.96 -0.26,-0.36 -0.62,-0.1 -0.75,0.51 -0.42,0.03 -1.47,-0.81 -1.18,-0.95 -0.09,-0.19 0.08,-1.01 0.87,-2.77 0.31,-1.47 0.12,-1.25 0.68,-0.46 1.09,-0.38 0.37,-0.85 0.29,-0.2 2.2,-0.85 2.14,-1.13 0.45,-0.46 0.34,-0.94 0.71,-0.82 0.57,0 0.35,0.78 1.61,0.78 1.73,0.57 0.14,-0.25 -2.67,-1.36 0.3,-0.21 0.95,-0.26 4.37,-0.86 1.86,-0.28 0.7,0.17 z",
                        "Labuan" : "m 624.42,86.91 0.28,-0.07 0.15,0.09 0.1,0.29 -0.42,0.13 -0.2,-0.33 -0.3,-0.19 0.12,-0.13 0.27,0.21 z m 8.5,-1.82 -0.07,0.2 -0.25,-0.14 -0.37,-0.02 -0.17,-0.17 0.38,-0.43 0.4,0.08 0.08,0.48 z m -3.52,-4.65 0.22,0.24 -0.04,0.15 -0.19,0 -0.25,0.51 0.04,0.75 0.24,0.27 0.14,0.83 0.55,0.58 0.11,0.47 0.27,0.33 -0.18,0.29 -0.39,0.19 -0.35,0.05 -0.3,-0.19 -0.17,0.08 0.1,0.13 -0.01,0.43 0.43,0.19 -0.2,0.33 0,0.25 -0.11,0.04 -0.2,-0.28 -0.34,-0.08 -0.09,-0.14 0.08,-0.08 -0.39,-0.73 -0.48,-0.08 -0.12,-0.15 -0.15,0.15 -0.48,0.1 -0.19,0.41 -0.2,0.19 -0.24,-0.04 -0.24,0.44 -0.57,0.05 -0.02,-0.3 0.35,-0.51 0.1,-0.39 0.05,-0.7 0.65,-1.29 0.27,-0.28 0,-0.16 0.48,-0.73 1.08,-1.2 0.27,0.01 0.42,-0.2 0.05,0.07 z"
                    }
                }
            }
        }
    );
})(jQuery);
