/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.hprtree.HPRtree;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.relateng.EdgeSegmentIntersector;
import org.locationtech.jts.operation.relateng.EdgeSegmentOverlapAction;
import org.locationtech.jts.operation.relateng.RelateSegmentString;

class EdgeSetIntersector {
    private HPRtree index = new HPRtree();
    private Envelope envelope;
    private List<MonotoneChain> monoChains = new ArrayList<MonotoneChain>();
    private int idCounter = 0;

    public EdgeSetIntersector(List<RelateSegmentString> edgesA, List<RelateSegmentString> edgesB, Envelope env) {
        this.envelope = env;
        this.addEdges(edgesA);
        this.addEdges(edgesB);
        this.index.build();
    }

    private void addEdges(Collection<RelateSegmentString> segStrings) {
        for (SegmentString segmentString : segStrings) {
            this.addToIndex(segmentString);
        }
    }

    private void addToIndex(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            if (this.envelope != null && !this.envelope.intersects(mc.getEnvelope())) continue;
            mc.setId(this.idCounter++);
            this.index.insert(mc.getEnvelope(), mc);
            this.monoChains.add(mc);
        }
    }

    public void process(EdgeSegmentIntersector intersector) {
        EdgeSegmentOverlapAction overlapAction = new EdgeSegmentOverlapAction(intersector);
        for (MonotoneChain queryChain : this.monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                if (testChain.getId() <= queryChain.getId()) continue;
                testChain.computeOverlaps(queryChain, overlapAction);
                if (!intersector.isDone()) continue;
                return;
            }
        }
    }
}

