/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge;
import org.locationtech.jts.operation.polygonize.PolygonizeEdge;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.util.Assert;

class EdgeRing {
    private GeometryFactory factory;
    private List<PolygonizeDirectedEdge> deList = new ArrayList<PolygonizeDirectedEdge>();
    private LinearRing ring = null;
    private IndexedPointInAreaLocator locator;
    private Coordinate[] ringPts = null;
    private List<LinearRing> holes;
    private EdgeRing shell;
    private boolean isHole;
    private boolean isValid = false;
    private boolean isProcessed = false;
    private boolean isIncludedSet = false;
    private boolean isIncluded = false;

    public static EdgeRing findEdgeRingContaining(EdgeRing testEr, List<EdgeRing> erList) {
        EdgeRing minContainingRing = null;
        for (EdgeRing edgeRing : erList) {
            if (!edgeRing.contains(testEr) || minContainingRing != null && !super.getEnvelope().contains(edgeRing.getEnvelope())) continue;
            minContainingRing = edgeRing;
        }
        return minContainingRing;
    }

    public static List<PolygonizeDirectedEdge> findDirEdgesInRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        ArrayList<PolygonizeDirectedEdge> edges = new ArrayList<PolygonizeDirectedEdge>();
        do {
            edges.add(de);
            de = de.getNext();
            Assert.isTrue(de != null, "found null DE in ring");
            Assert.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
        } while (de != startDE);
        return edges;
    }

    public EdgeRing(GeometryFactory factory) {
        this.factory = factory;
    }

    public void build(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        do {
            this.add(de);
            de.setRing(this);
            de = de.getNext();
            Assert.isTrue(de != null, "found null DE in ring");
            Assert.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
        } while (de != startDE);
    }

    private void add(DirectedEdge de) {
        this.deList.add((PolygonizeDirectedEdge)de);
    }

    public List<PolygonizeDirectedEdge> getEdges() {
        return this.deList;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public void computeHole() {
        LinearRing ring = this.getRing();
        this.isHole = Orientation.isCCW(ring.getCoordinates());
    }

    public void addHole(LinearRing hole) {
        if (this.holes == null) {
            this.holes = new ArrayList<LinearRing>();
        }
        this.holes.add(hole);
    }

    public void addHole(EdgeRing holeER) {
        holeER.setShell(this);
        LinearRing hole = holeER.getRing();
        if (this.holes == null) {
            this.holes = new ArrayList<LinearRing>();
        }
        this.holes.add(hole);
    }

    public Polygon getPolygon() {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = this.holes.get(i);
            }
        }
        Polygon poly = this.factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void computeValid() {
        this.getCoordinates();
        if (this.ringPts.length <= 3) {
            this.isValid = false;
            return;
        }
        this.getRing();
        this.isValid = this.ring.isValid();
    }

    public boolean isIncludedSet() {
        return this.isIncludedSet;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
        this.isIncludedSet = true;
    }

    private PointOnGeometryLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.getRing());
        }
        return this.locator;
    }

    public int locate(Coordinate pt) {
        return this.getLocator().locate(pt);
    }

    private boolean contains(EdgeRing ring) {
        Envelope testEnv;
        Envelope env = this.getEnvelope();
        if (!env.containsProperly(testEnv = ring.getEnvelope())) {
            return false;
        }
        return this.isPointInOrOut(ring);
    }

    private boolean isPointInOrOut(EdgeRing ring) {
        for (Coordinate pt : ring.getCoordinates()) {
            int loc = this.locate(pt);
            if (loc == 0) {
                return true;
            }
            if (loc != 2) continue;
            return false;
        }
        return false;
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordList = new CoordinateList();
            for (PolygonizeDirectedEdge de : this.deList) {
                PolygonizeEdge edge = (PolygonizeEdge)de.getEdge();
                EdgeRing.addEdge(edge.getLine().getCoordinates(), de.getEdgeDirection(), coordList);
            }
            this.ringPts = coordList.toCoordinateArray();
        }
        return this.ringPts;
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    public LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        try {
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.ring;
    }

    private Envelope getEnvelope() {
        return this.getRing().getEnvelopeInternal();
    }

    private static void addEdge(Coordinate[] coords, boolean isForward, CoordinateList coordList) {
        if (isForward) {
            for (int i = 0; i < coords.length; ++i) {
                coordList.add(coords[i], false);
            }
        } else {
            for (int i = coords.length - 1; i >= 0; --i) {
                coordList.add(coords[i], false);
            }
        }
    }

    public void setShell(EdgeRing shell) {
        this.shell = shell;
    }

    public boolean hasShell() {
        return this.shell != null;
    }

    public EdgeRing getShell() {
        if (this.isHole()) {
            return this.shell;
        }
        return this;
    }

    public boolean isOuterHole() {
        if (!this.isHole) {
            return false;
        }
        return !this.hasShell();
    }

    public boolean isOuterShell() {
        return this.getOuterHole() != null;
    }

    public EdgeRing getOuterHole() {
        if (this.isHole()) {
            return null;
        }
        for (int i = 0; i < this.deList.size(); ++i) {
            PolygonizeDirectedEdge de = this.deList.get(i);
            EdgeRing adjRing = ((PolygonizeDirectedEdge)de.getSym()).getRing();
            if (!adjRing.isOuterHole()) continue;
            return adjRing;
        }
        return null;
    }

    public void updateIncluded() {
        if (this.isHole()) {
            return;
        }
        for (int i = 0; i < this.deList.size(); ++i) {
            PolygonizeDirectedEdge de = this.deList.get(i);
            EdgeRing adjShell = ((PolygonizeDirectedEdge)de.getSym()).getRing().getShell();
            if (adjShell == null || !adjShell.isIncludedSet()) continue;
            this.setIncluded(!adjShell.isIncluded());
            return;
        }
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.getCoordinates()));
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    static class EnvelopeAreaComparator
    implements Comparator<EdgeRing> {
        EnvelopeAreaComparator() {
        }

        @Override
        public int compare(EdgeRing r0, EdgeRing r1) {
            return Double.compare(r0.getRing().getEnvelope().getArea(), r1.getRing().getEnvelope().getArea());
        }
    }

    static class EnvelopeComparator
    implements Comparator<EdgeRing> {
        EnvelopeComparator() {
        }

        @Override
        public int compare(EdgeRing r0, EdgeRing r1) {
            return r0.getRing().getEnvelope().compareTo(r1.getRing().getEnvelope());
        }
    }
}

