/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.Closeable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Pool of Threads")
public interface ThreadPool
extends Executor {
    public void join() throws InterruptedException;

    @ManagedAttribute(value="number of threads in pool")
    public int getThreads();

    @ManagedAttribute(value="number of idle threads in pool")
    public int getIdleThreads();

    @ManagedAttribute(value="indicates the pool is low on available threads")
    public boolean isLowOnThreads();

    public static void executeImmediately(Executor executor, Runnable task) {
        TryExecutor tryExecutor;
        if (task == null) {
            return;
        }
        Invocable.InvocationType invocationType = Invocable.getInvocationType(task);
        if (invocationType == Invocable.InvocationType.NON_BLOCKING) {
            task.run();
            return;
        }
        if (invocationType == Invocable.InvocationType.EITHER) {
            Invocable.invokeNonBlocking(task);
            return;
        }
        if (executor instanceof TryExecutor && (tryExecutor = (TryExecutor)executor).tryExecute(task)) {
            return;
        }
        Executor virtual = VirtualThreads.getVirtualThreadsExecutor(executor);
        if (virtual != null) {
            virtual.execute(task);
            return;
        }
        try {
            new Thread(task, "jetty-immediate-executor").start();
        }
        catch (Throwable ignored) {
            task.run();
        }
    }

    public static boolean reject(Runnable task, Throwable cause) {
        Logger log = LoggerFactory.getLogger(ThreadPool.class);
        if (log.isDebugEnabled()) {
            log.debug("rejected {}", (Object)task, (Object)cause);
        }
        if (task instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)task);
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.warn("Unable to close rejected job: {}", (Object)task, (Object)t);
                ExceptionUtil.addSuppressedIfNotAssociated(cause, t);
            }
            return true;
        }
        return false;
    }

    public static interface SizedThreadPool
    extends ThreadPool {
        public int getMinThreads();

        public int getMaxThreads();

        public void setMinThreads(int var1);

        public void setMaxThreads(int var1);

        default public ThreadPoolBudget getThreadPoolBudget() {
            return null;
        }
    }
}

