/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncRuntimeException
extends RuntimeException {
    @NotNull
    public static RuntimeException fillInStackTrace(@NotNull RuntimeException e) {
        if (e instanceof AsyncRuntimeException) {
            int remove;
            AsyncRuntimeException copy = ((AsyncRuntimeException)e).copy();
            StackTraceElement[] stackTrace = copy.getStackTrace();
            for (remove = 0; remove < stackTrace.length; ++remove) {
                StackTraceElement stackTraceElement = stackTrace[remove];
                if (!stackTraceElement.getClassName().equals(AsyncRuntimeException.class.getCanonicalName()) || !stackTraceElement.getMethodName().equals("fillInStackTrace")) continue;
                break;
            }
            copy.setStackTrace(Arrays.copyOfRange(stackTrace, remove, stackTrace.length));
            return copy;
        }
        return e;
    }

    protected AsyncRuntimeException(@Nullable String message) {
        super(message, null);
    }

    protected AsyncRuntimeException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    protected AsyncRuntimeException(@Nullable Throwable cause) {
        super(cause);
    }

    protected AsyncRuntimeException(@NotNull AsyncRuntimeException e) {
        super(e.getMessage(), e.getCause());
        super.fillInStackTrace();
    }

    @Override
    @NotNull
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @NotNull
    protected abstract AsyncRuntimeException copy();
}

