/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Mqtt3SimpleAuthView
implements Mqtt3SimpleAuth {
    @NotNull
    private final MqttSimpleAuth delegate;

    @NotNull
    private static MqttSimpleAuth delegate(@NotNull MqttUtf8StringImpl username, @Nullable ByteBuffer password) {
        return new MqttSimpleAuth(username, password);
    }

    @NotNull
    static Mqtt3SimpleAuthView of(@NotNull MqttUtf8StringImpl username, @Nullable ByteBuffer password) {
        return new Mqtt3SimpleAuthView(Mqtt3SimpleAuthView.delegate(username, password));
    }

    @NotNull
    public static Mqtt3SimpleAuthView of(@NotNull MqttSimpleAuth delegate) {
        return new Mqtt3SimpleAuthView(delegate);
    }

    private Mqtt3SimpleAuthView(@NotNull MqttSimpleAuth delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public MqttUtf8String getUsername() {
        return Checks.stateNotNull(this.delegate.getRawUsername(), "Username");
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getPassword() {
        return this.delegate.getPassword();
    }

    @NotNull
    public MqttSimpleAuth getDelegate() {
        return this.delegate;
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3SimpleAuthView)) {
            return false;
        }
        Mqtt3SimpleAuthView that = (Mqtt3SimpleAuthView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

