/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttAckFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttOutgoingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowables;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishWithFlow;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishResult;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttAckSingle
extends Single<Mqtt5PublishResult> {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttPublish publish;

    public MqttAckSingle(@NotNull MqttClientConfig clientConfig, @NotNull MqttPublish publish) {
        this.clientConfig = clientConfig;
        this.publish = publish;
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5PublishResult> observer) {
        if (this.clientConfig.getState().isConnectedOrReconnect()) {
            ClientComponent clientComponent = this.clientConfig.getClientComponent();
            MqttOutgoingQosHandler outgoingQosHandler = clientComponent.outgoingQosHandler();
            MqttPublishFlowables publishFlowables = outgoingQosHandler.getPublishFlowables();
            Flow flow = new Flow(observer, this.clientConfig, outgoingQosHandler);
            observer.onSubscribe((Disposable)flow);
            publishFlowables.add((Flowable<MqttPublishWithFlow>)Flowable.just((Object)new MqttPublishWithFlow(this.publish, flow)));
        } else {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), observer);
        }
    }

    private static class Flow
    extends MqttAckFlow
    implements Disposable {
        @NotNull
        private final SingleObserver<? super Mqtt5PublishResult> observer;
        @NotNull
        private final MqttOutgoingQosHandler outgoingQosHandler;
        @Nullable
        private MqttPublishResult result;

        Flow(@NotNull SingleObserver<? super Mqtt5PublishResult> observer, @NotNull MqttClientConfig clientConfig, @NotNull MqttOutgoingQosHandler outgoingQosHandler) {
            super(clientConfig);
            this.observer = observer;
            this.outgoingQosHandler = outgoingQosHandler;
            this.init();
        }

        @Override
        @CallByThread(value="Netty EventLoop")
        void onNext(@NotNull MqttPublishResult result) {
            if (result.acknowledged()) {
                this.done(result);
            } else {
                this.result = result;
            }
        }

        @Override
        @CallByThread(value="Netty EventLoop")
        void acknowledged(long acknowledged) {
            MqttPublishResult result = this.result;
            assert (acknowledged == 1L && result != null) : "a single publish must be acknowledged exactly once";
            this.result = null;
            this.done(result);
        }

        @CallByThread(value="Netty EventLoop")
        private void done(@NotNull MqttPublishResult result) {
            if (this.setDone()) {
                Throwable error = result.getRawError();
                if (error == null) {
                    this.observer.onSuccess((Object)result);
                } else {
                    this.observer.onError(error);
                }
            }
            this.outgoingQosHandler.request(1L);
        }
    }
}

