/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.spi.v1;

import com.google.api.core.InternalApi;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@InternalApi
public final class HttpRpcContext {
    private static final Object GET_INSTANCE_LOCK = new Object();
    private static volatile HttpRpcContext instance;
    private final ThreadLocal<UUID> invocationId = new InheritableThreadLocal<UUID>();
    private final Supplier<UUID> supplier;

    HttpRpcContext(Supplier<UUID> randomUUID) {
        this.supplier = randomUUID;
    }

    @InternalApi
    @Nullable
    public UUID getInvocationId() {
        return this.invocationId.get();
    }

    @InternalApi
    public UUID newInvocationId() {
        this.invocationId.set(this.supplier.get());
        return this.getInvocationId();
    }

    @InternalApi
    public void clearInvocationId() {
        this.invocationId.remove();
    }

    @InternalApi
    public static HttpRpcContext init() {
        return new HttpRpcContext(UUID::randomUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi
    public static HttpRpcContext getInstance() {
        if (instance == null) {
            Object object = GET_INSTANCE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = HttpRpcContext.init();
                }
            }
        }
        return instance;
    }
}

