/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class StorageChannelUtils {
    private StorageChannelUtils() {
    }

    public static int blockingFillFrom(ByteBuffer buf, ReadableByteChannel c) throws IOException {
        int total = 0;
        while (buf.hasRemaining()) {
            int read = c.read(buf);
            if (read != -1) {
                total += read;
                continue;
            }
            if (total != 0) break;
            return -1;
        }
        return total;
    }

    public static int blockingEmptyTo(ByteBuffer buf, WritableByteChannel c) throws IOException {
        int total = 0;
        while (buf.hasRemaining()) {
            int written = c.write(buf);
            if (written == 0) continue;
            total += written;
        }
        return total;
    }
}

