/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.LinearExponentialRangeSpecFunction;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.ObjectReadSessionSeekableByteChannel;
import com.google.cloud.storage.RangeSpecFunction;
import com.google.cloud.storage.ReadProjectionConfig;
import com.google.cloud.storage.StorageByteChannels;
import com.google.common.base.MoreObjects;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@BetaApi
@Immutable
public final class ReadAsSeekableChannel
extends ReadProjectionConfig<SeekableByteChannel> {
    static final ReadAsSeekableChannel INSTANCE = new ReadAsSeekableChannel(Hasher.enabled(), LinearExponentialRangeSpecFunction.INSTANCE);
    private final Hasher hasher;
    private final RangeSpecFunction rangeSpecFunction;

    private ReadAsSeekableChannel(Hasher hasher, RangeSpecFunction rangeSpecFunction) {
        this.hasher = hasher;
        this.rangeSpecFunction = rangeSpecFunction;
    }

    @BetaApi
    public RangeSpecFunction getRangeSpecFunction() {
        return this.rangeSpecFunction;
    }

    @BetaApi
    public ReadAsSeekableChannel withRangeSpecFunction(RangeSpecFunction rangeSpecFunction) {
        Objects.requireNonNull(rangeSpecFunction, "rangeSpecFunction must be non null");
        return new ReadAsSeekableChannel(this.hasher, rangeSpecFunction);
    }

    @BetaApi
    boolean getCrc32cValidationEnabled() {
        return Hasher.enabled().equals(this.hasher);
    }

    @BetaApi
    ReadAsSeekableChannel withCrc32cValidationEnabled(boolean enabled) {
        if (enabled && Hasher.enabled().equals(this.hasher)) {
            return this;
        }
        if (!enabled && Hasher.noop().equals(this.hasher)) {
            return this;
        }
        return new ReadAsSeekableChannel(enabled ? Hasher.enabled() : Hasher.noop(), this.rangeSpecFunction);
    }

    @Override
    SeekableByteChannel project(ObjectReadSession session, IOAutoCloseable closeAlongWith) {
        return StorageByteChannels.seekable(new ObjectReadSessionSeekableByteChannel(session, this, closeAlongWith));
    }

    @Override
    ReadProjectionConfig.ProjectionType getType() {
        return ReadProjectionConfig.ProjectionType.SESSION_USER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadAsSeekableChannel)) {
            return false;
        }
        ReadAsSeekableChannel that = (ReadAsSeekableChannel)o;
        return Objects.equals(this.rangeSpecFunction, that.rangeSpecFunction);
    }

    public int hashCode() {
        return Objects.hashCode(this.rangeSpecFunction);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rangeSpecFunction", (Object)this.rangeSpecFunction).toString();
    }
}

