/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

class Crc32cUtility {
    private static final long CASTAGNOLI_POLY = 4812730177L;
    private static final int DEGREE = 32;
    private static final long[] X_POW_2K_TABLE = new long[]{2L, 4L, 16L, 256L, 65536L, 517762881L, 984302966L, 408362264L, 1503875210L, 2862076957L, 3884826397L, 1324787473L, 621200174L, 1758783527L, 1416537776L, 1180494764L, 648569364L, 2521473789L, 994858823L, 1728245375L, 3498467999L, 4059169852L, 3345064394L, 2828422810L, 2429203150L, 3336788029L, 860151998L, 2102628683L, 1033187991L, 4243778976L, 1123580069L};

    private Crc32cUtility() {
    }

    private static int multiply(int p, int q) {
        long q64 = q;
        int result = 0;
        long topBit = 0x100000000L;
        for (int i = 0; i < 32; ++i) {
            if ((p & 1) != 0) {
                result ^= (int)q64;
            }
            if (((q64 <<= 1) & topBit) != 0L) {
                q64 ^= 0x11EDC6F41L;
            }
            p >>= 1;
        }
        return result;
    }

    private static int extendByZeros(int crc, long numBits) {
        crc = Integer.reverse(crc);
        int i = 0;
        while (numBits != 0L) {
            if ((numBits & 1L) != 0L) {
                crc = Crc32cUtility.multiply(crc, (int)X_POW_2K_TABLE[i % X_POW_2K_TABLE.length]);
            }
            ++i;
            numBits >>= 1;
        }
        crc = Integer.reverse(crc);
        return crc;
    }

    public static int concatCrc32c(int crcA, int crcB, long numBytesInB) {
        if (numBytesInB == 0L) {
            return crcA;
        }
        return Crc32cUtility.extendByZeros(crcA, 8L * numBytesInB) ^ crcB;
    }
}

