/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.cloud.storage.BidiAppendableUnbufferedWritableByteChannel;
import com.google.cloud.storage.BlobAppendableUpload;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

@BetaApi
final class BlobAppendableUploadImpl
implements BlobAppendableUpload {
    private final WritableByteChannelSession<AppendableObjectBufferedWritableByteChannel, BlobInfo> delegate;
    private boolean open;

    BlobAppendableUploadImpl(WritableByteChannelSession<AppendableObjectBufferedWritableByteChannel, BlobInfo> delegate) {
        this.delegate = delegate;
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobAppendableUpload.AppendableUploadWriteableByteChannel open() throws IOException {
        BlobAppendableUploadImpl blobAppendableUploadImpl = this;
        synchronized (blobAppendableUploadImpl) {
            Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"already open");
            this.open = true;
            return this.delegate.open();
        }
    }

    @Override
    public ApiFuture<BlobInfo> getResult() {
        return this.delegate.getResult();
    }

    static final class AppendableObjectBufferedWritableByteChannel
    implements BufferedWritableByteChannelSession.BufferedWritableByteChannel,
    BlobAppendableUpload.AppendableUploadWriteableByteChannel {
        private final BufferedWritableByteChannelSession.BufferedWritableByteChannel buffered;
        private final BidiAppendableUnbufferedWritableByteChannel unbuffered;
        private final boolean finalizeOnClose;
        private final ReentrantLock lock;

        AppendableObjectBufferedWritableByteChannel(BufferedWritableByteChannelSession.BufferedWritableByteChannel buffered, BidiAppendableUnbufferedWritableByteChannel unbuffered, boolean finalizeOnClose) {
            this.buffered = buffered;
            this.unbuffered = unbuffered;
            this.finalizeOnClose = finalizeOnClose;
            this.lock = new ReentrantLock();
        }

        @Override
        public void flush() throws IOException {
            this.lock.lock();
            try {
                this.buffered.flush();
                try {
                    this.unbuffered.flush();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    interruptedIOException.initCause(e);
                    throw interruptedIOException;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            boolean locked = this.lock.tryLock();
            if (!locked) {
                return 0;
            }
            try {
                int n = this.buffered.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            try {
                boolean bl = this.buffered.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void finalizeAndClose() throws IOException {
            this.lock.lock();
            try {
                if (this.buffered.isOpen()) {
                    this.unbuffered.nextWriteShouldFinalize();
                    this.buffered.close();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void closeWithoutFinalizing() throws IOException {
            this.lock.lock();
            try {
                if (this.buffered.isOpen()) {
                    this.buffered.close();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.finalizeOnClose) {
                this.finalizeAndClose();
            } else {
                this.closeWithoutFinalizing();
            }
        }
    }
}

