/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import javax.annotation.Nullable;

public interface ReadWriteLogRecord {
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> var1, T var2);

    default public ReadWriteLogRecord setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, value) -> this.setAttribute((AttributeKey)attributeKey, (Object)value));
        return this;
    }

    public LogRecordData toLogRecordData();

    @Nullable
    default public <T> T getAttribute(AttributeKey<T> key) {
        return (T)this.toLogRecordData().getAttributes().get(key);
    }

    default public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.toLogRecordData().getInstrumentationScopeInfo();
    }

    default public long getTimestampEpochNanos() {
        return this.toLogRecordData().getTimestampEpochNanos();
    }

    default public long getObservedTimestampEpochNanos() {
        return this.toLogRecordData().getTimestampEpochNanos();
    }

    default public SpanContext getSpanContext() {
        return this.toLogRecordData().getSpanContext();
    }

    default public Severity getSeverity() {
        return this.toLogRecordData().getSeverity();
    }

    @Nullable
    default public String getSeverityText() {
        return this.toLogRecordData().getSeverityText();
    }

    @Nullable
    default public Value<?> getBodyValue() {
        return this.toLogRecordData().getBodyValue();
    }

    default public Attributes getAttributes() {
        return this.toLogRecordData().getAttributes();
    }
}

