/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.LeastRequestLoadBalancer;
import java.util.Map;

@Internal
public final class LeastRequestLoadBalancerProvider
extends LoadBalancerProvider {
    static final int MIN_CHOICE_COUNT = 2;
    static final int MAX_CHOICE_COUNT = 10;
    @VisibleForTesting
    static final Integer DEFAULT_CHOICE_COUNT = 2;

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new LeastRequestLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "least_request_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Integer choiceCount = JsonUtil.getNumberAsInteger(rawConfig, (String)"choiceCount");
            if (choiceCount == null) {
                choiceCount = DEFAULT_CHOICE_COUNT;
            }
            if (choiceCount < 2) {
                return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("Invalid 'choiceCount' in least_request_experimental config"));
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new LeastRequestLoadBalancer.LeastRequestConfig(choiceCount));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to parse least_request_experimental LB config: " + rawConfig));
        }
    }
}

