/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;

public class BinaryCodec {
    protected static final byte TYPE_POINT = 1;
    protected static final byte TYPE_RECT = 2;
    protected static final byte TYPE_CIRCLE = 3;
    protected static final byte TYPE_COLL = 4;
    protected static final byte TYPE_GEOM = 5;
    protected final SpatialContext ctx;

    public BinaryCodec(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    public Shape readShape(DataInput dataInput) throws IOException {
        byte type = dataInput.readByte();
        Shape s = this.readShapeByTypeIfSupported(dataInput, type);
        if (s == null) {
            throw new IllegalArgumentException("Unsupported shape byte " + type);
        }
        return s;
    }

    public void writeShape(DataOutput dataOutput, Shape s) throws IOException {
        boolean written = this.writeShapeByTypeIfSupported(dataOutput, s);
        if (!written) {
            throw new IllegalArgumentException("Unsupported shape " + s.getClass());
        }
    }

    protected Shape readShapeByTypeIfSupported(DataInput dataInput, byte type) throws IOException {
        switch (type) {
            case 1: {
                return this.readPoint(dataInput);
            }
            case 2: {
                return this.readRect(dataInput);
            }
            case 3: {
                return this.readCircle(dataInput);
            }
            case 4: {
                return this.readCollection(dataInput);
            }
        }
        return null;
    }

    protected boolean writeShapeByTypeIfSupported(DataOutput dataOutput, Shape s) throws IOException {
        byte type = this.typeForShape(s);
        dataOutput.writeByte(type);
        return this.writeShapeByTypeIfSupported(dataOutput, s, type);
    }

    protected boolean writeShapeByTypeIfSupported(DataOutput dataOutput, Shape s, byte type) throws IOException {
        switch (type) {
            case 1: {
                this.writePoint(dataOutput, (Point)s);
                break;
            }
            case 2: {
                this.writeRect(dataOutput, (Rectangle)s);
                break;
            }
            case 3: {
                this.writeCircle(dataOutput, (Circle)s);
                break;
            }
            case 4: {
                this.writeCollection(dataOutput, (ShapeCollection)s);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected byte typeForShape(Shape s) {
        if (s instanceof Point) {
            return 1;
        }
        if (s instanceof Rectangle) {
            return 2;
        }
        if (s instanceof Circle) {
            return 3;
        }
        if (s instanceof ShapeCollection) {
            return 4;
        }
        return 0;
    }

    protected double readDim(DataInput dataInput) throws IOException {
        return dataInput.readDouble();
    }

    protected void writeDim(DataOutput dataOutput, double v) throws IOException {
        dataOutput.writeDouble(v);
    }

    public Point readPoint(DataInput dataInput) throws IOException {
        return this.ctx.makePoint(this.readDim(dataInput), this.readDim(dataInput));
    }

    public void writePoint(DataOutput dataOutput, Point pt) throws IOException {
        this.writeDim(dataOutput, pt.getX());
        this.writeDim(dataOutput, pt.getY());
    }

    public Rectangle readRect(DataInput dataInput) throws IOException {
        return this.ctx.makeRectangle(this.readDim(dataInput), this.readDim(dataInput), this.readDim(dataInput), this.readDim(dataInput));
    }

    public void writeRect(DataOutput dataOutput, Rectangle r) throws IOException {
        this.writeDim(dataOutput, r.getMinX());
        this.writeDim(dataOutput, r.getMaxX());
        this.writeDim(dataOutput, r.getMinY());
        this.writeDim(dataOutput, r.getMaxY());
    }

    public Circle readCircle(DataInput dataInput) throws IOException {
        return this.ctx.makeCircle(this.readPoint(dataInput), this.readDim(dataInput));
    }

    public void writeCircle(DataOutput dataOutput, Circle c) throws IOException {
        this.writePoint(dataOutput, c.getCenter());
        this.writeDim(dataOutput, c.getRadius());
    }

    public ShapeCollection readCollection(DataInput dataInput) throws IOException {
        byte type = dataInput.readByte();
        int size = dataInput.readInt();
        ArrayList<Shape> shapes = new ArrayList<Shape>(size);
        for (int i = 0; i < size; ++i) {
            if (type == 0) {
                shapes.add(this.readShape(dataInput));
                continue;
            }
            Shape s = this.readShapeByTypeIfSupported(dataInput, type);
            if (s == null) {
                throw new InvalidShapeException("Unsupported shape byte " + type);
            }
            shapes.add(s);
        }
        return this.ctx.makeCollection(shapes);
    }

    public void writeCollection(DataOutput dataOutput, ShapeCollection col) throws IOException {
        byte type = 0;
        dataOutput.writeByte(type);
        dataOutput.writeInt(col.size());
        for (int i = 0; i < col.size(); ++i) {
            Object s = col.get(i);
            if (type == 0) {
                this.writeShape(dataOutput, (Shape)s);
                continue;
            }
            boolean written = this.writeShapeByTypeIfSupported(dataOutput, (Shape)s, type);
            if (written) continue;
            throw new IllegalArgumentException("Unsupported shape type " + s.getClass());
        }
    }
}

