/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TramigoProtocolDecoder
extends BaseProtocolDecoder {
    private static final String[] DIRECTIONS = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};

    public TramigoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short protocol = buf.readUnsignedByte();
        if (protocol == 1) {
            return this.decode01(channel, remoteAddress, buf);
        }
        if (protocol == 4) {
            return this.decode04(channel, remoteAddress, buf);
        }
        if (protocol == 128) {
            return this.decode80(channel, remoteAddress, buf);
        }
        return null;
    }

    private Position decode01(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readUnsignedByte();
        int index = buf.readUnsignedShortLE();
        int type = buf.readUnsignedShortLE();
        if (type == 256 || type == 254) {
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            long id = buf.readUnsignedIntLE();
            buf.readUnsignedInt();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("index", index);
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            position.setValid(true);
            position.setLatitude((double)buf.readUnsignedIntLE() * 1.0E-7);
            position.setLongitude((double)buf.readUnsignedIntLE() * 1.0E-7);
            position.set("rssi", buf.readUnsignedShortLE());
            position.set("sat", buf.readUnsignedShortLE());
            position.set("satVisible", buf.readUnsignedShortLE());
            position.set("gpsAntennaStatus", buf.readUnsignedShortLE());
            position.setSpeed((double)buf.readUnsignedShortLE() * 0.194384);
            position.setCourse(buf.readUnsignedShortLE());
            position.set("odometer", buf.readUnsignedIntLE());
            position.set("battery", buf.readUnsignedShortLE());
            position.set("charge", buf.readUnsignedShortLE());
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            return position;
        }
        return null;
    }

    private Position decode04(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int index = buf.readUnsignedShortLE();
        long id1 = buf.readUnsignedIntLE();
        long id2 = buf.readUnsignedIntLE();
        long time = buf.readUnsignedIntLE();
        String id = String.format("%08d%07d", id1, id2);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(4);
            response.writeShortLE(24);
            response.writeShortLE(0);
            response.writeShortLE(index);
            response.writeIntLE((int)id1);
            response.writeIntLE((int)id2);
            response.writeIntLE((int)time);
            response.writeByte(255);
            response.writeShortLE(index);
            response.writeShortLE(0);
            response.setShortLE(3, Checksum.crc16(Checksum.CRC16_CCITT_FALSE, response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        position.setDeviceTime(new Date(time * 1000L));
        block11: while (buf.isReadable()) {
            short type = buf.readUnsignedByte();
            switch (type) {
                case 0: {
                    position.set("event", buf.readUnsignedShortLE());
                    buf.readUnsignedIntLE();
                    int status = buf.readUnsignedShortLE();
                    position.set("ignition", BitUtil.check(status, 5));
                    position.set("status", status);
                    position.setValid(true);
                    position.setLatitude((double)buf.readIntLE() * 1.0E-5);
                    position.setLongitude((double)buf.readIntLE() * 1.0E-5);
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                    position.setCourse(buf.readUnsignedShortLE());
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("gps", buf.readUnsignedByte());
                    position.set("batteryLevel", buf.readUnsignedByte());
                    position.set("tripOdometer", buf.readUnsignedShortLE());
                    position.set("maxAcceleration", (double)buf.readUnsignedShortLE() * 0.001);
                    position.set("maxDeceleration", (double)buf.readUnsignedShortLE() * 0.001);
                    buf.readUnsignedShortLE();
                    buf.readUnsignedIntLE();
                    position.setFixTime(new Date(buf.readUnsignedIntLE() * 1000L));
                    buf.readUnsignedByte();
                    continue block11;
                }
                case 1: {
                    buf.skipBytes(buf.readUnsignedShortLE() - 3);
                    continue block11;
                }
                case 4: {
                    buf.skipBytes(53);
                    continue block11;
                }
                case 20: {
                    buf.skipBytes(32);
                    continue block11;
                }
                case 22: {
                    buf.readUnsignedByte();
                    buf.skipBytes(buf.readUnsignedShortLE());
                    continue block11;
                }
                case 30: {
                    buf.skipBytes(79);
                    continue block11;
                }
                case 40: {
                    buf.skipBytes(40);
                    continue block11;
                }
                case 50: {
                    buf.skipBytes(buf.readUnsignedShortLE() - 3);
                    continue block11;
                }
                case 255: {
                    buf.skipBytes(4);
                    continue block11;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown type %d", type));
        }
        return position.getValid() ? position : null;
    }

    private Position decode80(Channel channel, SocketAddress remoteAddress, ByteBuf buf) throws ParseException {
        buf.readUnsignedByte();
        int index = buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        long id = buf.readUnsignedInt();
        buf.readUnsignedInt();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)("gprs,ack," + index), (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        String sentence = buf.toString(StandardCharsets.US_ASCII);
        Pattern pattern = Pattern.compile("(-?\\d+\\.\\d+), (-?\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(sentence);
        if (!matcher.find()) {
            return null;
        }
        position.setLatitude(Double.parseDouble(matcher.group(1)));
        position.setLongitude(Double.parseDouble(matcher.group(2)));
        position.setValid(true);
        pattern = Pattern.compile("([NSWE]{1,2}) with speed (\\d+) km/h");
        matcher = pattern.matcher(sentence);
        if (matcher.find()) {
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (!matcher.group(1).equals(DIRECTIONS[i])) continue;
                position.setCourse((double)i * 45.0);
                break;
            }
            position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(matcher.group(2))));
        }
        if (!(matcher = (pattern = Pattern.compile("(\\d{1,2}:\\d{2}(:\\d{2})? \\w{3} \\d{1,2})")).matcher(sentence)).find()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(matcher.group(2) != null ? "HH:mm:ss MMM d yyyy" : "HH:mm MMM d yyyy", Locale.ENGLISH);
        position.setTime(DateUtil.correctYear(dateFormat.parse(matcher.group(1) + " " + Calendar.getInstance().get(1))));
        if (sentence.contains("Ignition on detected")) {
            position.set("ignition", true);
        } else if (sentence.contains("Ignition off detected")) {
            position.set("ignition", false);
        }
        return position;
    }
}

