/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RaveonProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$PRAVE,").number("(d+),").number("d+,").number("(-?)(d+)(dd.d+),").number("(-?)(d+)(dd.d+),").number("(dd)(dd)(dd),").number("(d),").number("(d+),").number("(-?d+),").number("(-?d+),").number("(d+.d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").expression("([PMACIVSX])?,").any().compile();

    public RaveonProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS));
        position.setValid(parser.nextInt(0) != 0);
        position.set("sat", parser.nextInt(0));
        position.setAltitude(parser.nextInt(0));
        position.set("temp1", parser.nextInt(0));
        position.set("power", parser.nextDouble(0.0));
        position.set("input", parser.nextInt(0));
        position.set("rssi", parser.nextInt(0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.setCourse(parser.nextInt(0));
        position.addAlarm(parser.next());
        return position;
    }
}

