/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.traccar.BaseProtocolPoller;
import org.traccar.Protocol;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class OrbcommProtocolPoller
extends BaseProtocolPoller {
    private final String accessId;
    private final String password;
    private final String host;
    private Date startTime = new Date();

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public OrbcommProtocolPoller(Protocol protocol, Config config) {
        super(config.getLong(Keys.PROTOCOL_INTERVAL.withPrefix(protocol.getName())));
        this.accessId = config.getString(Keys.ORBCOMM_ACCESS_ID);
        this.password = config.getString(Keys.ORBCOMM_PASSWORD);
        this.host = config.getString(Keys.PROTOCOL_ADDRESS.withPrefix(protocol.getName()));
    }

    @Override
    protected void sendRequest(Channel channel, SocketAddress remoteAddress) {
        QueryStringEncoder encoder = new QueryStringEncoder("/GLGW/2/RestMessages.svc/JSON/get_return_messages/");
        encoder.addParam("access_id", this.accessId);
        encoder.addParam("password", this.password);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        encoder.addParam("start_utc", dateFormat.format(this.startTime));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, encoder.toString(), Unpooled.buffer());
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
        request.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        channel.writeAndFlush((Object)request);
    }
}

