/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OigoProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_AR_LOCATION = 0;
    public static final int MSG_AR_REMOTE_START = 16;
    public static final int MSG_ACKNOWLEDGEMENT = 224;

    public OigoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeArMessage(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.skipBytes(1);
        buf.readUnsignedShort();
        short type = buf.readUnsignedByte();
        short tag = buf.readUnsignedByte();
        DeviceSession deviceSession = switch (BitUtil.to(tag, 3)) {
            case 0 -> {
                String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
                yield this.getDeviceSession(channel, remoteAddress, imei);
            }
            case 1 -> {
                buf.skipBytes(1);
                String meid = buf.readSlice(14).toString(StandardCharsets.US_ASCII);
                yield this.getDeviceSession(channel, remoteAddress, meid);
            }
            default -> this.getDeviceSession(channel, remoteAddress, new String[0]);
        };
        if (deviceSession == null || type != 0) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", buf.readUnsignedByte());
        int mask = buf.readInt();
        if (BitUtil.check(mask, 0)) {
            position.set("index", buf.readUnsignedShort());
        }
        if (BitUtil.check(mask, 1)) {
            short date = buf.readUnsignedByte();
            DateBuilder dateBuilder = new DateBuilder().setDate(BitUtil.between(date, 4, 8) + 2010, BitUtil.to(date, 4), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
        }
        if (BitUtil.check(mask, 2)) {
            buf.skipBytes(5);
        }
        if (BitUtil.check(mask, 3)) {
            position.setLatitude((double)buf.readUnsignedInt() * 1.0E-6 - 90.0);
            position.setLongitude((double)buf.readUnsignedInt() * 1.0E-6 - 180.0);
        }
        if (BitUtil.check(mask, 4)) {
            short status = buf.readUnsignedByte();
            position.setValid(BitUtil.between(status, 4, 8) != 0);
            position.set("sat", BitUtil.to(status, 4));
            position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
        }
        if (BitUtil.check(mask, 5)) {
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        }
        if (BitUtil.check(mask, 6)) {
            position.setCourse(buf.readUnsignedShort());
        }
        if (BitUtil.check(mask, 7)) {
            position.setAltitude(buf.readShort());
        }
        if (BitUtil.check(mask, 8)) {
            position.set("rssi", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 9)) {
            position.set("power", (double)buf.readUnsignedShort() * 0.001);
        }
        if (BitUtil.check(mask, 10)) {
            position.set("battery", (double)buf.readUnsignedShort() * 0.001);
        }
        if (BitUtil.check(mask, 11)) {
            buf.skipBytes(2);
        }
        if (BitUtil.check(mask, 12)) {
            position.set("odometer", buf.readUnsignedInt() * 1000L);
        }
        if (BitUtil.check(mask, 13)) {
            buf.skipBytes(6);
        }
        if (BitUtil.check(mask, 14)) {
            buf.skipBytes(5);
        }
        if (BitUtil.check(mask, 15)) {
            buf.readUnsignedShort();
        }
        return position;
    }

    private double convertCoordinate(long value) {
        boolean negative = value < 0L;
        value = Math.abs(value);
        double minutes = (double)(value % 100000L) * 0.001;
        double degrees = (double)(value /= 100000L) + minutes / 60.0;
        return negative ? -degrees : degrees;
    }

    private Position decodeMgMessage(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession;
        buf.readUnsignedByte();
        short flags = buf.getUnsignedByte(buf.readerIndex());
        if (BitUtil.check(flags, 6)) {
            buf.readUnsignedByte();
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        } else {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        }
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.skipBytes(8);
        int date = buf.readUnsignedShort();
        DateBuilder dateBuilder = new DateBuilder().setDate(2010 + BitUtil.from(date, 12), BitUtil.between(date, 8, 12), BitUtil.to(date, 8)).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), 0);
        position.setValid(true);
        position.setLatitude(this.convertCoordinate(buf.readInt()));
        position.setLongitude(this.convertCoordinate(buf.readInt()));
        position.setAltitude(UnitsConverter.metersFromFeet(buf.readShort()));
        position.setCourse(buf.readUnsignedShort());
        position.setSpeed(UnitsConverter.knotsFromMph(buf.readUnsignedByte()));
        position.set("power", (double)buf.readUnsignedByte() * 0.1);
        position.set("io1", buf.readUnsignedByte());
        dateBuilder.setSecond(buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        position.set("rssi", buf.readUnsignedByte());
        short index = buf.readUnsignedByte();
        position.set("versionFw", buf.readUnsignedByte());
        position.set("sat", buf.readUnsignedByte());
        position.set("odometer", (long)((double)buf.readUnsignedInt() * 1609.34));
        if (channel != null && BitUtil.check(flags, 7)) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(224);
            response.writeByte((int)index);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedByte(buf.readerIndex()) == 126) {
            return this.decodeArMessage(channel, remoteAddress, buf);
        }
        return this.decodeMgMessage(channel, remoteAddress, buf);
    }
}

