/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class MqttClient {
    private final Mqtt5AsyncClient client;

    MqttClient(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        Mqtt5SimpleAuth simpleAuth = this.getSimpleAuth(uri);
        String host = uri.getHost();
        int port = uri.getPort();
        Mqtt5ClientBuilder builder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().identifier("traccar-" + String.valueOf(UUID.randomUUID()))).serverHost(host)).serverPort(port)).simpleAuth(simpleAuth).automaticReconnectWithDefaultConfig();
        this.client = builder.buildAsync();
        ((CompletableFuture)this.client.connectWith().send()).whenComplete((message, e) -> {
            throw new RuntimeException((Throwable)e);
        });
    }

    private Mqtt5SimpleAuth getSimpleAuth(URI uri) {
        String userInfo = uri.getUserInfo();
        Mqtt5SimpleAuth simpleAuth = null;
        if (userInfo != null) {
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                throw new IllegalArgumentException("Wrong MQTT credentials. Should be in format \"username:password\"");
            }
            simpleAuth = ((Mqtt5SimpleAuthBuilder.Complete)((Mqtt5SimpleAuthBuilder.Complete)Mqtt5SimpleAuth.builder().username(userInfo.substring(0, delimiter++))).password(userInfo.substring(delimiter).getBytes())).build();
        }
        return simpleAuth;
    }

    public void publish(String pubTopic, String payload, BiConsumer<? super Mqtt5PublishResult, ? super Throwable> whenComplete) {
        ((CompletableFuture)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)this.client.publishWith().topic(pubTopic)).qos(MqttQos.AT_LEAST_ONCE)).payload(payload.getBytes())).send()).whenComplete(whenComplete);
    }
}

