/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public class ListPlatformApplicationsIterable
implements SdkIterable<ListPlatformApplicationsResponse> {
    private final SnsClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlatformApplicationsIterable(SnsClient client, ListPlatformApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public Iterator<ListPlatformApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformApplications() != null) {
                return response.platformApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlatformApplicationsResponseFetcher
    implements SyncPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlatformApplicationsResponse nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsIterable.this.client.listPlatformApplications(ListPlatformApplicationsIterable.this.firstRequest);
            }
            return ListPlatformApplicationsIterable.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

