/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Query;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class QueryPartition {
    private final Query query;
    @Nullable
    private final Object[] startAt;
    @Nullable
    private final Object[] endBefore;

    public QueryPartition(Query query, @Nullable Object[] startAt, @Nullable Object[] endBefore) {
        this.query = query;
        this.startAt = startAt;
        this.endBefore = endBefore;
    }

    @Nullable
    public Object[] getStartAt() {
        return this.startAt;
    }

    @Nullable
    public Object[] getEndBefore() {
        return this.endBefore;
    }

    public Query createQuery() {
        Query baseQuery = this.query;
        if (this.startAt != null) {
            baseQuery = baseQuery.startAt(this.startAt);
        }
        if (this.endBefore != null) {
            baseQuery = baseQuery.endBefore(this.endBefore);
        }
        return baseQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryPartition)) {
            return false;
        }
        QueryPartition partition = (QueryPartition)o;
        return this.query.equals(partition.query) && Arrays.equals(this.startAt, partition.startAt) && Arrays.equals(this.endBefore, partition.endBefore);
    }

    public int hashCode() {
        int result = Objects.hash(this.query);
        result = 31 * result + Arrays.hashCode(this.startAt);
        result = 31 * result + Arrays.hashCode(this.endBefore);
        return result;
    }
}

