/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class GenericQuerySnapshot<QueryT>
implements Iterable<QueryDocumentSnapshot> {
    protected final QueryT query;
    protected final Timestamp readTime;
    private List<DocumentChange> documentChanges;
    private final List<QueryDocumentSnapshot> documents;

    protected GenericQuerySnapshot(QueryT query, Timestamp readTime, @Nonnull List<QueryDocumentSnapshot> documents, List<DocumentChange> documentChanges) {
        this.query = query;
        this.readTime = readTime;
        this.documentChanges = documentChanges != null ? Collections.unmodifiableList(documentChanges) : documentChanges;
        this.documents = Collections.unmodifiableList(documents);
    }

    @Nonnull
    public QueryT getQuery() {
        return this.query;
    }

    @Nonnull
    public Timestamp getReadTime() {
        return this.readTime;
    }

    @Nonnull
    public List<QueryDocumentSnapshot> getDocuments() {
        return this.documents;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nonnull
    public Iterator<QueryDocumentSnapshot> iterator() {
        return this.getDocuments().iterator();
    }

    @Nonnull
    public <T> List<T> toObjects(@Nonnull Class<T> clazz) {
        List<QueryDocumentSnapshot> documents = this.getDocuments();
        ArrayList<T> results = new ArrayList<T>(documents.size());
        for (DocumentSnapshot documentSnapshot : documents) {
            results.add(CustomClassMapper.convertToCustomClass(documentSnapshot.getData(), clazz, documentSnapshot.getReference()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<DocumentChange> getDocumentChanges() {
        if (this.documentChanges == null) {
            List<QueryDocumentSnapshot> list = this.documents;
            synchronized (list) {
                if (this.documentChanges == null) {
                    int size = this.documents.size();
                    ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
                    for (int i = 0; i < size; ++i) {
                        builder.add((Object)new DocumentChange(this.documents.get(i), DocumentChange.Type.ADDED, -1, i));
                    }
                    this.documentChanges = builder.build();
                }
            }
        }
        return this.documentChanges;
    }

    public int size() {
        return this.getDocuments().size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericQuerySnapshot that = (GenericQuerySnapshot)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.getDocumentChanges(), that.getDocumentChanges()) && Objects.equals(this.getDocuments(), that.getDocuments());
    }

    public int hashCode() {
        return Objects.hash(this.query, this.getDocumentChanges(), this.getDocuments());
    }

    public String toString() {
        return String.format("%s{query=%s, readTime=%s, documentChanges=%s, documents=%s}", this.getClass().getSimpleName(), this.query, this.readTime, this.documentChanges, this.documents);
    }
}

