/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.InternalHelpers;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.DataEvent;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.QuerySpec;

public class ValueEventRegistration
extends EventRegistration {
    private final Repo repo;
    private final ValueEventListener eventListener;
    private final QuerySpec spec;

    public ValueEventRegistration(Repo repo, ValueEventListener eventListener, @NotNull QuerySpec spec) {
        this.repo = repo;
        this.eventListener = eventListener;
        this.spec = spec;
    }

    @Override
    public boolean respondsTo(Event.EventType eventType) {
        return eventType == Event.EventType.VALUE;
    }

    public boolean equals(Object other) {
        return other instanceof ValueEventRegistration && ((ValueEventRegistration)other).eventListener.equals(this.eventListener) && ((ValueEventRegistration)other).repo.equals(this.repo) && ((ValueEventRegistration)other).spec.equals(this.spec);
    }

    public int hashCode() {
        int result = this.eventListener.hashCode();
        result = 31 * result + this.repo.hashCode();
        result = 31 * result + this.spec.hashCode();
        return result;
    }

    @Override
    public DataEvent createEvent(Change change, QuerySpec query) {
        DatabaseReference ref = InternalHelpers.createReference(this.repo, query.getPath());
        DataSnapshot dataSnapshot = InternalHelpers.createDataSnapshot(ref, change.getIndexedNode());
        return new DataEvent(Event.EventType.VALUE, this, dataSnapshot, null);
    }

    @Override
    public void fireEvent(DataEvent eventData) {
        if (this.isZombied()) {
            return;
        }
        this.eventListener.onDataChange(eventData.getSnapshot());
    }

    @Override
    public void fireCancelEvent(DatabaseError error) {
        this.eventListener.onCancelled(error);
    }

    @Override
    public EventRegistration clone(QuerySpec newQuery) {
        return new ValueEventRegistration(this.repo, this.eventListener, newQuery);
    }

    @Override
    public boolean isSameListener(EventRegistration other) {
        return other instanceof ValueEventRegistration && ((ValueEventRegistration)other).eventListener.equals(this.eventListener);
    }

    @Override
    @NotNull
    public QuerySpec getQuerySpec() {
        return this.spec;
    }

    public String toString() {
        return "ValueEventRegistration";
    }

    @Override
    Repo getRepo() {
        return this.repo;
    }
}

