/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.netty;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.quarkus.micrometer.runtime.binder.netty.NettyMeters;

public class NettyAllocatorMetrics
implements MeterBinder {
    private final ByteBufAllocatorMetricProvider allocator;
    private final String name;

    public NettyAllocatorMetrics(String name, ByteBufAllocatorMetricProvider allocator) {
        this.name = name;
        this.allocator = allocator;
    }

    public void bindTo(MeterRegistry registry) {
        ByteBufAllocatorMetric allocatorMetric = this.allocator.metric();
        Tags tags = Tags.of((String[])new String[]{NettyMeters.AllocatorKeyNames.NAME.asString(), this.name, NettyMeters.AllocatorKeyNames.ALLOCATOR_TYPE.asString(), this.allocator.getClass().getSimpleName()});
        Gauge.builder((String)NettyMeters.ALLOCATOR_MEMORY_USED.getName(), (Object)allocatorMetric, ByteBufAllocatorMetric::usedHeapMemory).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(registry);
        Gauge.builder((String)NettyMeters.ALLOCATOR_MEMORY_USED.getName(), (Object)allocatorMetric, ByteBufAllocatorMetric::usedDirectMemory).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(registry);
        ByteBufAllocatorMetricProvider byteBufAllocatorMetricProvider = this.allocator;
        if (byteBufAllocatorMetricProvider instanceof PooledByteBufAllocator) {
            PooledByteBufAllocator pooledByteBufAllocator = (PooledByteBufAllocator)byteBufAllocatorMetricProvider;
            PooledByteBufAllocatorMetric pooledAllocatorMetric = pooledByteBufAllocator.metric();
            Gauge.builder((String)NettyMeters.ALLOCATOR_MEMORY_PINNED.getName(), (Object)pooledByteBufAllocator, PooledByteBufAllocator::pinnedHeapMemory).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_MEMORY_PINNED.getName(), (Object)pooledByteBufAllocator, PooledByteBufAllocator::pinnedDirectMemory).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_ARENAS.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::numHeapArenas).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_ARENAS.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::numDirectArenas).tags((Iterable)tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_CACHE_SIZE.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::normalCacheSize).tags((Iterable)tags.and(NettyMeters.AllocatorPooledCacheKeyNames.CACHE_TYPE.asString(), "normal")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_CACHE_SIZE.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::smallCacheSize).tags((Iterable)tags.and(NettyMeters.AllocatorPooledCacheKeyNames.CACHE_TYPE.asString(), "small")).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_THREADLOCAL_CACHES.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::numThreadLocalCaches).tags((Iterable)tags).register(registry);
            Gauge.builder((String)NettyMeters.ALLOCATOR_POOLED_CHUNK_SIZE.getName(), (Object)pooledAllocatorMetric, PooledByteBufAllocatorMetric::chunkSize).tags((Iterable)tags).register(registry);
        }
    }
}

