/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class MergedUpdate<S extends SessionEntity>
implements SessionUpdateTask<S> {
    private static final Logger logger = Logger.getLogger(MergedUpdate.class);
    private final List<SessionUpdateTask<S>> childUpdates = new LinkedList<SessionUpdateTask<S>>();
    private SessionUpdateTask.CacheOperation operation;
    private final long lifespanMs;
    private final long maxIdleTimeMs;

    private MergedUpdate(SessionUpdateTask.CacheOperation operation, long lifespanMs, long maxIdleTimeMs) {
        this.operation = operation;
        this.lifespanMs = lifespanMs;
        this.maxIdleTimeMs = maxIdleTimeMs;
    }

    @Override
    public void runUpdate(S session) {
        for (SessionUpdateTask<S> child : this.childUpdates) {
            child.runUpdate(session);
        }
    }

    @Override
    public boolean shouldRemove(S session) {
        for (SessionUpdateTask<S> child : this.childUpdates) {
            if (!child.shouldRemove(session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SessionUpdateTask.CacheOperation getOperation() {
        return this.operation;
    }

    public long getLifespanMs() {
        return this.lifespanMs;
    }

    public long getMaxIdleTimeMs() {
        return this.maxIdleTimeMs;
    }

    public static <S extends SessionEntity> MergedUpdate<S> computeUpdate(List<SessionUpdateTask<S>> childUpdates, SessionEntityWrapper<S> sessionWrapper, long lifespanMs, long maxIdleTimeMs) {
        if (childUpdates == null || childUpdates.isEmpty()) {
            return null;
        }
        MergedUpdate<S> result = null;
        S session = sessionWrapper.getEntity();
        for (SessionUpdateTask<S> child : childUpdates) {
            if (result == null) {
                SessionUpdateTask.CacheOperation operation = child.getOperation();
                if (lifespanMs == -2L || maxIdleTimeMs == -2L) {
                    operation = SessionUpdateTask.CacheOperation.REMOVE;
                    logger.tracef("Entry '%s' is expired. Will remove it from the cache", sessionWrapper);
                }
                result = new MergedUpdate<S>(operation, lifespanMs, maxIdleTimeMs);
                result.childUpdates.add(child);
                continue;
            }
            result.operation = result.getOperation().merge(child.getOperation(), (SessionEntity)session);
            if (result.operation == SessionUpdateTask.CacheOperation.REMOVE) {
                result = new MergedUpdate<S>(result.operation, lifespanMs, maxIdleTimeMs);
                result.childUpdates.add(child);
                return result;
            }
            result.childUpdates.add(child);
        }
        return result;
    }

    public String toString() {
        return "MergedUpdate" + String.valueOf(this.childUpdates);
    }
}

