/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.marshalling;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;
import org.jboss.logging.Logger;
import org.keycloak.marshalling.KeycloakModelSchema;

public class KeycloakIndexSchemaUtil {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String BASIC_ANNOTATION = "Basic";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SEARCHABLE_ATTRIBUTE = "searchable";
    private static final String PROJECTABLE_ATTRIBUTE = "projectable";
    private static final String AGGREGABLE_ATTRIBUTE = "aggregable";
    private static final String SORTABLE_ATTRIBUTE = "sortable";
    private static final String INDEX_NULL_AS_ATTRIBUTE = "indexNullAs";
    private static final List<String> INDEX_ANNOTATION = List.of("Basic");

    public static void uploadAndReindexCaches(RemoteCacheManager remoteCacheManager, GeneratedSchema schema, List<IndexedEntity> indexedEntities) {
        String key = schema.getProtoFileName();
        String current = schema.getProtoFile();
        RemoteCache protostreamMetadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        MetadataValue stored = protostreamMetadataCache.getWithMetadata((Object)key);
        if (stored == null) {
            if (protostreamMetadataCache.putIfAbsent((Object)key, (Object)current) == null) {
                logger.info((Object)"Infinispan ProtoStream schema uploaded for the first time.");
            } else {
                logger.info((Object)"Failed to update Infinispan ProtoStream schema. Assumed it was updated by other Keycloak server.");
            }
            KeycloakIndexSchemaUtil.checkForProtoSchemaErrors((RemoteCache<String, String>)protostreamMetadataCache);
            return;
        }
        if (Objects.equals(stored.getValue(), current)) {
            logger.info((Object)"Infinispan ProtoStream schema is up to date!");
            return;
        }
        if (protostreamMetadataCache.replaceWithVersion((Object)key, (Object)current, stored.getVersion())) {
            logger.info((Object)"Infinispan ProtoStream schema successful updated.");
            KeycloakIndexSchemaUtil.reindexCaches(remoteCacheManager, (String)stored.getValue(), current, indexedEntities);
        } else {
            logger.info((Object)"Failed to update Infinispan ProtoStream schema. Assumed it was updated by other Keycloak server.");
        }
        KeycloakIndexSchemaUtil.checkForProtoSchemaErrors((RemoteCache<String, String>)protostreamMetadataCache);
    }

    private static void checkForProtoSchemaErrors(RemoteCache<String, String> protostreamMetadataCache) {
        String errors = (String)protostreamMetadataCache.get((Object)".errors");
        if (errors == null) {
            return;
        }
        for (String errorFile : errors.split("\n")) {
            logger.errorf("%nThere was an error in proto file: %s%nError message: %s%nCurrent proto schema: %s%n", (Object)errorFile, protostreamMetadataCache.get((Object)(errorFile + ".errors")), protostreamMetadataCache.get((Object)errorFile));
        }
    }

    private static void reindexCaches(RemoteCacheManager remoteCacheManager, String oldSchema, String newSchema, List<IndexedEntity> indexedEntities) {
        if (indexedEntities == null || indexedEntities.isEmpty()) {
            return;
        }
        FileDescriptor oldPS = KeycloakModelSchema.parseProtoSchema(oldSchema);
        FileDescriptor newPS = KeycloakModelSchema.parseProtoSchema(newSchema);
        RemoteCacheManagerAdmin admin = remoteCacheManager.administration();
        indexedEntities.stream().filter(Objects::nonNull).filter(indexedEntity -> KeycloakIndexSchemaUtil.isEntityChanged(oldPS, newPS, indexedEntity.entity())).map(IndexedEntity::cache).distinct().forEach(cacheName -> KeycloakIndexSchemaUtil.updateSchemaAndReIndexCache(admin, cacheName));
    }

    private static boolean isEntityChanged(FileDescriptor oldSchema, FileDescriptor newSchema, String entity) {
        Optional<Descriptor> v1 = KeycloakModelSchema.findEntity(oldSchema, entity);
        Optional<Descriptor> v2 = KeycloakModelSchema.findEntity(newSchema, entity);
        return v1.isPresent() && v2.isPresent() && KeycloakIndexSchemaUtil.isIndexSchemaChanged(v1.get(), v2.get());
    }

    private static void updateSchemaAndReIndexCache(RemoteCacheManagerAdmin admin, String cacheName) {
        admin.updateIndexSchema(cacheName);
        admin.reindexCache(cacheName);
    }

    public static void configureAnnotationProcessor(Configuration.Builder builder) {
        builder.annotationsConfig().annotation(BASIC_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).attribute(NAME_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").attribute(SEARCHABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)true).attribute(PROJECTABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(AGGREGABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(SORTABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(INDEX_NULL_AS_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"__Infinispan_indexNullAs_doNotIndexNull");
    }

    public static boolean isIndexSchemaChanged(Descriptor oldDescriptor, Descriptor newDescriptor) {
        Set allFields = Stream.concat(oldDescriptor.getFields().stream().map(AnnotatedDescriptorImpl::getName), newDescriptor.getFields().stream().map(AnnotatedDescriptorImpl::getName)).collect(Collectors.toSet());
        for (String fieldName : allFields) {
            FieldDescriptor newField;
            FieldDescriptor oldField = oldDescriptor.findFieldByName(fieldName);
            if (KeycloakIndexSchemaUtil.isNewFieldAdded(oldField, newField = newDescriptor.findFieldByName(fieldName))) {
                if (!KeycloakIndexSchemaUtil.isFieldIndexed(newField)) continue;
                return true;
            }
            if (KeycloakIndexSchemaUtil.isNewFieldRemoved(oldField, newField)) {
                if (!KeycloakIndexSchemaUtil.isFieldIndexed(oldField)) continue;
                return true;
            }
            if (KeycloakIndexSchemaUtil.isFieldIndexed(oldField) != KeycloakIndexSchemaUtil.isFieldIndexed(newField)) {
                return true;
            }
            if (!KeycloakIndexSchemaUtil.isFieldIndexed(oldField) && !KeycloakIndexSchemaUtil.isFieldIndexed(newField) || !KeycloakIndexSchemaUtil.isAnnotationChanged(oldField, newField)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewFieldAdded(FieldDescriptor oldField, FieldDescriptor newField) {
        return oldField == null && newField != null;
    }

    private static boolean isNewFieldRemoved(FieldDescriptor oldField, FieldDescriptor newField) {
        return oldField != null && newField == null;
    }

    private static boolean isFieldIndexed(FieldDescriptor descriptor) {
        Map annotations = descriptor.getAnnotations();
        return INDEX_ANNOTATION.stream().anyMatch(annotations::containsKey);
    }

    private static boolean isAnnotationChanged(FieldDescriptor oldField, FieldDescriptor newField) {
        return INDEX_ANNOTATION.stream().anyMatch(s -> {
            AnnotationElement.Annotation oldAnnot = (AnnotationElement.Annotation)oldField.getAnnotations().get(s);
            AnnotationElement.Annotation newAnnot = (AnnotationElement.Annotation)newField.getAnnotations().get(s);
            return KeycloakIndexSchemaUtil.isAnnotatedDifferent(oldAnnot, newAnnot);
        });
    }

    private static boolean isAnnotatedDifferent(AnnotationElement.Annotation oldAnnot, AnnotationElement.Annotation newAnnot) {
        if (oldAnnot == null && newAnnot == null) {
            return false;
        }
        if (oldAnnot != null && newAnnot == null) {
            return true;
        }
        if (oldAnnot == null) {
            return true;
        }
        return !Objects.equals(KeycloakIndexSchemaUtil.getAnnotationValues(oldAnnot), KeycloakIndexSchemaUtil.getAnnotationValues(newAnnot));
    }

    private static Map<String, Object> getAnnotationValues(AnnotationElement.Annotation annotation) {
        return annotation.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AnnotationElement.Attribute)e.getValue()).getValue().getValue()));
    }

    public record IndexedEntity(String entity, String cache) {
        public IndexedEntity {
            Objects.requireNonNull(entity);
            Objects.requireNonNull(cache);
        }
    }
}

