/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationTargetImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

abstract class DeclarationInfoImpl<JandexDeclaration extends Declaration>
extends AnnotationTargetImpl
implements DeclarationInfo {
    final JandexDeclaration jandexDeclaration;

    DeclarationInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, JandexDeclaration jandexDeclaration) {
        super(jandexIndex, annotationOverlay, (EquivalenceKey)EquivalenceKey.of(jandexDeclaration));
        this.jandexDeclaration = jandexDeclaration;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationOverlay.hasAnnotation(this.jandexDeclaration, annotationType);
    }

    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            if (!predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation))) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationInstance annotation = this.annotationOverlay.annotation(this.jandexDeclaration, annotationType);
        if (annotation == null) {
            return null;
        }
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation);
    }

    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotationsWithRepeatable(this.jandexDeclaration, annotationType)) {
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            AnnotationInfoImpl annotationInfo = new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation);
            if (!predicate.test(annotationInfo)) continue;
            result.add(annotationInfo);
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<AnnotationInfo> annotations() {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return this.jandexDeclaration.toString();
    }
}

