/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.util.Arrays;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class EnumHelper {
    public static String[] getEnumeratedValues(Type type) {
        return EnumHelper.getEnumeratedValues(type.getReturnedClass(), ((BasicType)type).getJdbcType());
    }

    public static String[] getEnumeratedValues(Class<?> javaType, JdbcType jdbcType) {
        String[] enumValues;
        Class<?> enumClass = javaType;
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case 6000: 
            case 6001: {
                enumValues = EnumHelper.getSortedEnumeratedValues(enumClass);
                break;
            }
            default: {
                enumValues = EnumHelper.getEnumeratedValues(enumClass);
            }
        }
        return enumValues;
    }

    public static String[] getEnumeratedValues(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] values = enumClass.getEnumConstants();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].name();
        }
        return names;
    }

    public static String[] getSortedEnumeratedValues(Class<? extends Enum<?>> enumClass) {
        Object[] names = EnumHelper.getEnumeratedValues(enumClass);
        Arrays.sort(names);
        return names;
    }
}

