/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sql.internal.ResultSetMappingProcessor;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;

public class NativeSelectQueryPlanImpl<R>
implements NativeSelectQueryPlan<R> {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<ParameterOccurrence> parameterList;
    private final JdbcValuesMappingProducer resultSetMapping;

    public NativeSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<ParameterOccurrence> parameterList, ResultSetMapping resultSetMapping, SessionFactoryImplementor sessionFactory) {
        ResultSetMappingProcessor processor = new ResultSetMappingProcessor(resultSetMapping, sessionFactory);
        SQLQueryParser parser = new SQLQueryParser(sql, processor.process(), sessionFactory);
        this.sql = parser.process();
        this.parameterList = parameterList;
        this.resultSetMapping = processor.generateResultMapping(parser.queryHasAliases());
        if (affectedTableNames == null) {
            affectedTableNames = new HashSet<String>();
        }
        if (resultSetMapping != null) {
            resultSetMapping.addAffectedTableNames(affectedTableNames, sessionFactory);
        }
        this.affectedTableNames = affectedTableNames;
    }

    @Override
    public <T> T executeQuery(DomainQueryExecutionContext executionContext, ResultsConsumer<T, R> resultsConsumer) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(queryParameterBindings, this.parameterList, jdbcParameterBinders, executionContext.getSession().getFactory());
        }
        JdbcOperationQuerySelect jdbcSelect = new JdbcOperationQuerySelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames);
        return executionContext.getSession().getJdbcServices().getJdbcSelectExecutor().executeQuery(jdbcSelect, jdbcParameterBindings, (ExecutionContext)SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext), null, null, -1, resultsConsumer);
    }

    @Override
    public List<R> performList(DomainQueryExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        QueryOptions queryOptions = executionContext.getQueryOptions();
        if (queryOptions.getEffectiveLimit().getMaxRowsJpa() == 0) {
            return Collections.emptyList();
        }
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(queryParameterBindings, this.parameterList, jdbcParameterBinders, executionContext.getSession().getFactory());
        }
        JdbcOperationQuerySelect jdbcSelect = new JdbcOperationQuerySelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames);
        executionContext.getSession().autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
        return executionContext.getSession().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext), null, queryOptions.getUniqueSemantic() == null ? ListResultsConsumer.UniqueSemantic.NEVER : queryOptions.getUniqueSemantic());
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(queryParameterBindings, this.parameterList, jdbcParameterBinders, executionContext.getSession().getFactory());
        }
        JdbcOperationQuerySelect jdbcSelect = new JdbcOperationQuerySelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames);
        executionContext.getSession().autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
        return executionContext.getSession().getJdbcServices().getJdbcSelectExecutor().scroll(jdbcSelect, scrollMode, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext), null, -1);
    }
}

